// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#ifdef USEMFC
#include "stdafx.h"
#include <GL/gl.h>
#else
#include <GL/glut.h>
#endif
#include "GSkater.h"
#include "GGoalie.h"
#include "Puck.h"
#include "Point.h"
#include "Constants.h"
#include "Model.h"
#include "SprayMaker.h"
#include "GTeam.h"
#include "LineSet.h"
#include "SoundEffectsManager.h"

#ifndef GAME
#define GAME

class Game
{
// friend class HMainWindow;
  public:
  Game (int hometeamid, int visitorteamid,CoachSettings & HomeCoachSettings, CoachSettings & VisitorCoachSettings);
#ifndef TWODVERSION
  void Play (long Timer, CoachSettings & HomeCoachSettings, CoachSettings & VisitorCoachSettings, ControlData HControl, ControlData VControl, KeyData Keys, uint32 * IceTexture /*[1024][512][3] */ , int Textures, int Display, int SoundEffectsOn);
#endif
#ifdef TWODVERSION
void Play (long Timer, CoachSettings & HomeCoachSettings, CoachSettings & VisitorCoachSettings, ControlData HControl, ControlData VControl, KeyData Keys, uint32 * IceTexture /*[1024][512][3] */ , int Textures, int Display, int SoundEffectsOn, CDC &dc);
#endif

  void Coach (int homeorvisitor);
  int GetScore (int homeorvisitor);
  int GetShots (int homeorvisitor);
  int GetMaxPlayers (int homeorvisitor);
  void GenerateTextures ();
  PositionData Home[2][6];	//Player home positions...index 5 is the goalie

  double GetPuckX ();
  double GetPuckY ();
  double GetPuckZ ();
  double GetPuckXVelocity ();
  double GetPuckYVelocity ();
  double GetPuckZVelocity ();
  char *GetStatusBarText ();
  int GetStrength (int homeorvisitor);
  int GetGoalieStrength (int homeorvisitor);
  Point GetHomeGoalieCoordinates ();
  int CurrentPlayer;
protected:
  SoundEffectsManager SoundManager;
  Model PlayerModel;
  Model GoalieModel;
  int LastPlayerToShoot;
  int HomeOffsides, VisitorOffsides;
  int CountPlayersOnIce (int homeorvisitor);
  int GetReplacement(int index);
//              void DrawScore(CDC &dc);
  void SetCoachSettings (int homeorvisitor, int &Breakout, int &PassDump,
			 int &ShotAggression, int &ForecheckingAggression,
			 int &NumForeCheckers, int &Coverage, int &ManPuck,
			 int &StayHomeAttack);
  void UseFunnel (int homeorvisitor);
  void UseDiamond (int homeorvisitor);
  void Use212 (int homeorvisitor);
  void SetOffensiveFormation (int homeorvisitor, int ourspeed, int theirspeed,
			      int ourpower, int theirpower);
  void CheckOffsides ();
  void CheckCollisions ();
  void MakeView (GPlayer * Skater, PlayerView Status[(PlayersPerTeam * 2) + 4]);
  void DoAction (PlayerView Status[PlayersPerTeam * 2 + 4], GPlayer * s, Puck & p);
  void HandleDeflections (GPlayer * s, Puck & p);
  void ResolvePossessionConflicts (Puck & MrPuck, int PuckHog);
  void CheckGoaliePossession (GGoalie * g, Puck & p, int &shotcounter);
  void SetNumberOfPlayers (int homeorvisitor, int maxplayers);
  void CheckNumberOfPlayers (int homeorvisitor);
  void UpdatePenaltyStatus (int s);
  void CenterIceFaceOff ();
  void FaceOff ();
  void UpdateSprayMakers(int display);
  GTeam HomeTeam, VisitorTeam;
  LineSet HomeLines, VisitorLines;
  GSkater *Skaters[PlayersPerTeam * 2];
  GGoalie *HomeGoalie, *VisitorGoalie;
  Puck MrPuck;
  std::list<SprayMaker> SprayMakers;
  CoachSettings & HomeCoachSettings;
  CoachSettings & VisitorCoachSettings;
  int HomeScore;
  int HomeShots;
  int VisitorScore;
  int VisitorShots;
  int HomeMaxPlayers;
  int VisitorMaxPlayers;
  int LastPlayerToTouch[6];
  int LastTouchX;
  //int BlueLine[2];
  long LastTimePuckMoved;
  char StatusBarText[80];

};
#endif
