// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


// HomePositionPicture.cpp : implementation file
//

#include "stdafx.h"
//#include "simulator.h"
#include "HomePositionPicture.h"
#include "utils.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// HomePositionPicture

HomePositionPicture::HomePositionPicture(PositionData *Home)
{
	Positions=Home;
	SelectedIndex=-1;
	Mode=0;
}

HomePositionPicture::~HomePositionPicture()
{
}


BEGIN_MESSAGE_MAP(HomePositionPicture, CWnd)
	//{{AFX_MSG_MAP(HomePositionPicture)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// HomePositionPicture message handlers

BOOL HomePositionPicture::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	return CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
}

void HomePositionPicture::DrawIce(CPaintDC & DC)
{
 CPen BluePen(PS_SOLID,2,RGB(0,0,200));
 CPen BorderPen(PS_SOLID,1,RGB(0,0,0));
 CPen RedPen(PS_SOLID,2,RGB(150,0,0));
 CBrush WhiteBrush(RGB(255,255,255));

 CPen *pPen=DC.SelectObject(&BluePen);
 CBrush *pBrush=DC.SelectObject(&WhiteBrush);

 CRect ClientRect;
 ClientRect.top=0;
 ClientRect.bottom=(int)(width/2);
 ClientRect.right=(int)(length/2);
 ClientRect.left=0;
 //GetClientRect(ClientRect);
  
 DC.ExtTextOut(0,0,ETO_OPAQUE,ClientRect,"",0);
 DC.SelectObject(&BluePen);

 DC.MoveTo((int)BlueLine[0]/2,0);
 DC.LineTo((int)BlueLine[0]/2,(int)width/2);
 DC.MoveTo((int)BlueLine[1]/2,0);
 DC.LineTo((int)BlueLine[1]/2,(int)width/2);
 DC.SelectObject(&BorderPen);

 DC.MoveTo(0,0);
 DC.LineTo((int)length/2-25,0);
 CRect Corner;
 Corner.top=0;
 Corner.bottom=75;
 Corner.left=(int)length/2-75;
 Corner.right=(int)length/2;
 CPoint Start((int)length/2,37);
 CPoint End((int)length/2-37,0);
 DC.Arc(Corner,Start,End);

 DC.MoveTo((int)length/2-1, 37);
 DC.LineTo((int)length/2-1,(int)width/2-37);
 Corner.top=(int)width/2-75;
 Corner.bottom=(int)width/2;
 Corner.left=(int)length/2-75;
 Corner.right=(int)length/2;
 CPoint Start2((int)length/2-37,(int)width/2);
 CPoint End2((int)length/2,(int)width/2-37);
 DC.Arc(Corner,Start2,End2);
 
	DC.MoveTo((int)length/2-37, (int)width/2-1);
 DC.LineTo(25,(int)width/2-1);
 Corner.top=(int)width/2-75;
 Corner.bottom=(int)width/2;
 Corner.left=0;
 Corner.right=75;
 CPoint Start3(0,(int)width/2-37);
 CPoint End3(37,(int)width/2);
 DC.Arc(Corner,Start3,End3);

 DC.MoveTo(0, (int)width/2-37);
 DC.LineTo(0,37);
 Corner.top=0;
 Corner.bottom=75;
 Corner.left=0;
 Corner.right=75;
 CPoint Start4(37,0);
 CPoint End4(0,37);
 DC.Arc(Corner,Start4,End4);
 DC.MoveTo((int)length/2-1, 37);
 DC.SelectObject(&RedPen);

 DC.MoveTo((int)homegoalx/2+3,6);
 DC.LineTo((int)homegoalx/2+3,(int)width/2-6);
 DC.MoveTo((int)visitorgoalx/2-3,6);
 DC.LineTo((int)visitorgoalx/2-3,(int)width/2-6);


 DC.SelectObject(&WhiteBrush);
 DC.SelectObject(&RedPen);
 CRect FaceoffCircle;
 FaceoffCircle.top=(int)((3.0/80.0)*width/2);
 FaceoffCircle.bottom=(int)((33.0/80.0)*width/2);
 FaceoffCircle.left=(int)((16.0/200.0)*length/2);
 FaceoffCircle.right=(int)((46.0/200.0)*length/2);
 DC.Ellipse(FaceoffCircle);

 FaceoffCircle.top=(int)(width/2-(3.0/80.0)*width/2);
 FaceoffCircle.bottom=(int)(width/2-(33.0/80.0)*width/2);
 FaceoffCircle.left=(int)((16.0/200.0)*length/2);
 FaceoffCircle.right=(int)((46.0/200.0)*length/2);
 DC.Ellipse(FaceoffCircle);

 FaceoffCircle.top=(int)((3.0/80.0)*width/2);
 FaceoffCircle.bottom=(int)((33.0/80.0)*width/2);
 FaceoffCircle.left=(int)(length/2-(16.0/200.0)*length/2);
 FaceoffCircle.right=(int)(length/2-(46.0/200.0)*length/2);
 DC.Ellipse(FaceoffCircle);

 FaceoffCircle.top=(int)(width/2-(3.0/80.0)*width/2);
 FaceoffCircle.bottom=(int)(width/2-(33.0/80.0)*width/2);
 FaceoffCircle.left=(int)(length/2-(16.0/200.0)*length/2);
 FaceoffCircle.right=(int)(length/2-(46.0/200.0)*length/2);
 DC.Ellipse(FaceoffCircle);

 FaceoffCircle.top=(int)(width/4-(22.0/80.0)*width/2);
 FaceoffCircle.bottom=(int)(width/4+(22.0/80.0)*width/2);
 FaceoffCircle.left=(int)(length/4-(22.0/200.0)*length/2);
 FaceoffCircle.right=(int)(length/4+(22.0/200.0)*length/2);
 DC.Ellipse(FaceoffCircle);

 DC.MoveTo((int)(length/4),0);
 DC.LineTo((int)(length/4),(int)width/2);

 DC.SelectObject(&BorderPen);
 CRect Goal1;
 Goal1.top=(int)((width/4)-goallength/4);
 Goal1.bottom=(int)((width/4)+goallength/4);
 Goal1.left=(int)(homegoalx/2-goalwidth/4);
 Goal1.right=(int)(homegoalx/2+goalwidth/4);
 CRect Goal2;
 Goal2.top=(int)((width/4)-goallength/4);
 Goal2.bottom=(int)((width/4)+goallength/4);
 Goal2.left=(int)(visitorgoalx/2-goalwidth/6);
 Goal2.right=(int)(visitorgoalx/2+goalwidth/6);
 DC.SelectObject(&BorderPen);
 DC.Rectangle(Goal1);
 DC.Rectangle(Goal2);

 if (DC.SelectObject(pPen)==NULL)
  MessageBox("Big pen Trouble!","!!!",MB_OK);
 if (DC.SelectObject(pBrush)==NULL)
  MessageBox("Big brush Trouble!","!!!",MB_OK);
}


void HomePositionPicture::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect bound;
	bound.top=0;
	bound.bottom=(int)width/2;
	bound.left=(int)length/2;
	bound.right=0;
	dc.Rectangle(bound);
 DrawIce(dc);
 for (int x=0;x<5;x++)
	{
		if (Mode==0)
		{
			dc.MoveTo((int)Positions[x].OffenseX/2, (int)Positions[x].OffenseY/2);
		 bound.top=(int)Positions[x].OffenseY/2-5;
		 bound.bottom=(int)Positions[x].OffenseY/2+5;
		 bound.left=(int)Positions[x].OffenseX/2-5;
		 bound.right=(int)Positions[x].OffenseX/2+5;
		}
  else
		{
			dc.MoveTo((int)Positions[x].DefenseX/2, (int)Positions[x].DefenseY/2);
		 bound.top=(int)Positions[x].DefenseY/2-5;
		 bound.bottom=(int)Positions[x].DefenseY/2+5;
		 bound.left=(int)Positions[x].DefenseX/2-5;
		 bound.right=(int)Positions[x].DefenseX/2+5;
		}
		dc.Ellipse(bound);
		
	}
	
	// Do not call CWnd::OnPaint() for painting messages
}

void HomePositionPicture::OnLButtonDown(UINT nFlags, CPoint point) 
{
	for (int x=0;x<5;x++)
 	if ((Mode==0&&Distance(point.x, point.y, Positions[x].OffenseX/2, Positions[x].OffenseY/2)<5)||
			   (Mode==1&&Distance(point.x, point.y, Positions[x].DefenseX/2, Positions[x].DefenseY/2)<5))
			SelectedIndex=x;
	
	CWnd::OnLButtonDown(nFlags, point);
}


void HomePositionPicture::OnLButtonUp(UINT nFlags, CPoint point) 
{
 SelectedIndex=-1;
	
	CWnd::OnLButtonUp(nFlags, point);
}

void HomePositionPicture::OnMouseMove(UINT nFlags, CPoint point) 
{
 if (SelectedIndex!=-1)	
	{
		if (Mode==0)
		{
			Positions[SelectedIndex].OffenseX=point.x*2;
 		Positions[SelectedIndex].OffenseY=point.y*2;
		}
		else
		{
			Positions[SelectedIndex].DefenseX=point.x*2;
 		Positions[SelectedIndex].DefenseY=point.y*2;
  }
 	Invalidate();
	}
	
	CWnd::OnMouseMove(nFlags, point);
}

void HomePositionPicture::SetMode(int mode)
{
	Mode=mode;
	Invalidate();
}
