#include "JointAngles.h"

JointAngles::JointAngles():Head (), Neck (), Torso (), LeftUpperArm (),
 LeftLowerArm (), LeftHand (), RightUpperArm (),
 RightLowerArm (), RightHand (), Hip (), RightThigh (),
 LeftThigh (), RightShin (), LeftShin (), RightFoot (),
 LeftFoot ()
{
}

ostream &operator<<(ostream &o, JointAngles &s)
{
 o<<s.Head<<s.Neck<<s.Torso<<s.LeftUpperArm<<s.LeftLowerArm<<s.LeftHand
  <<s.RightUpperArm<<s.RightLowerArm<<s.RightHand<<s.Hip<<s.RightThigh
  <<s.LeftThigh<<s.RightShin<<s.LeftShin<<s.RightFoot<<s.LeftFoot<<s.Stick;
 return o;
}

istream &operator>>(istream &i, JointAngles &s)
{
  i>>s.Head>>s.Neck>>s.Torso>>s.LeftUpperArm>>s.LeftLowerArm>>s.LeftHand
  >>s.RightUpperArm>>s.RightLowerArm>>s.RightHand>>s.Hip>>s.RightThigh
  >>s.LeftThigh>>s.RightShin>>s.LeftShin>>s.RightFoot>>s.LeftFoot>>s.Stick;
 return i;
}

bool JointAngles::operator==(JointAngles &rhs)
{
 return (Head==rhs.Head && 
         Neck==rhs.Neck &&
         Torso==rhs.Torso &&
         LeftUpperArm==rhs.LeftUpperArm &&
         LeftLowerArm==rhs.LeftLowerArm && 
         LeftHand==rhs.LeftHand &&
         RightUpperArm==rhs.RightUpperArm &&
         RightLowerArm==rhs.RightLowerArm && 
         RightHand==rhs.RightHand && 
         Hip==rhs.Hip && 
         RightThigh==rhs.RightThigh && 
         LeftThigh==rhs.LeftThigh && 
         RightShin==rhs.RightShin &&
         LeftShin==rhs.LeftShin &&
         RightFoot==rhs.RightFoot && 
         LeftFoot==rhs.LeftFoot &&
         Stick==rhs.Stick);
}

void JointAngles::MoveTowards(JointAngles &s)
{
 Head.MoveTowardsUnlimited(s.Head);
 Neck.MoveTowardsUnlimited(s.Neck);
 Torso.MoveTowardsUnlimited(s.Torso);
 LeftUpperArm.MoveTowardsUnlimited(s.LeftUpperArm);
 LeftLowerArm.MoveTowardsUnlimited(s.LeftLowerArm);
 LeftHand.MoveTowardsUnlimited(s.LeftHand);
 RightUpperArm.MoveTowardsUnlimited(s.RightUpperArm);
 RightLowerArm.MoveTowardsUnlimited(s.RightLowerArm);
 RightHand.MoveTowardsUnlimited(s.RightHand);
 Hip.MoveTowardsUnlimited(s.Hip);
 RightThigh.MoveTowardsUnlimited(s.RightThigh);
 LeftThigh.MoveTowardsUnlimited(s.LeftThigh);
 RightShin.MoveTowardsUnlimited(s.RightShin);
 LeftShin.MoveTowardsUnlimited(s.LeftShin);
 RightFoot.MoveTowardsUnlimited(s.RightFoot);
 LeftFoot.MoveTowardsUnlimited(s.LeftFoot);
 Stick.MoveTowardsUnlimited(s.Stick);
}

void JointAngles::EnforceRigidity(int AppendageOnGround)
{
  if (Hip.X >= 180)
    Hip.X -= 360;
  if (Hip.X < -180)
    Hip.X += 360;
  if (Hip.Y >= 180)
    Hip.X -= 360;
  if (Hip.Y < -180)
    Hip.X += 360;


  ConstrainUpper (LeftThigh.X, 160);
  ConstrainLower (LeftThigh.X, -60);
  ConstrainUpper (RightThigh.X, 160);
  ConstrainLower (RightThigh.X, -60);

  ConstrainUpper (LeftShin.X, 0);
  ConstrainLower (LeftShin.X, -170);
  ConstrainUpper (RightShin.X, 0);
  ConstrainLower (RightShin.X, -170);

  ConstrainUpper (LeftLowerArm.X, 170);
  ConstrainLower (LeftLowerArm.X, 0);
  ConstrainUpper (RightLowerArm.X, 170);
  ConstrainLower (RightLowerArm.X, 0);

  if (AppendageOnGround > 1 && Hip.X < -50 && Hip.XVelocity < 0)
    Hip.XVelocity = 0;
  if (AppendageOnGround > 1 && Hip.X > 50 && Hip.XVelocity > 0)
    Hip.XVelocity = 0;

}

void JointAngles::
ConstrainUpper (double &number, int max)
{
  if (number > max)
    number = max;
}

void JointAngles::
ConstrainUpperPointX (Point & p, int max)
{
  if (p.X > max && p.XVelocity > 0)
    {
      p.X = max;
      p.XVelocity= 0; //-abs(p.XVelocity/2)-1;
    }
}


void JointAngles::
ConstrainLower (double &number, int min)
{
  if (number < min)
    number = min;
}

void JointAngles::
ConstrainLowerPointX (Point & p, int min)
{
  if (p.X < min && p.XVelocity < 0)
    {
      p.X = min;
      p.XVelocity = 0;//abs(p.XVelocity/2)+1;
    }
}

void JointAngles::Move()
{
  Head.Move ();
  Head.ModAll(360);
  Neck.Move ();
  Neck.ModAll(360);
  Torso.Move ();
  Torso.ModAll(360);
  LeftUpperArm.Move ();
  LeftUpperArm.ModAll(360);
  LeftLowerArm.Move ();
  LeftLowerArm.ModAll(360);
  LeftHand.Move ();
  LeftHand.ModAll(360);
  RightUpperArm.Move ();
  RightUpperArm.ModAll(360);
  RightLowerArm.Move ();
  RightLowerArm.ModAll(360);
  RightHand.Move ();
  RightHand.ModAll(360);
  LeftThigh.Move ();
  LeftThigh.ModAll(360);
  LeftShin.Move ();
  LeftShin.ModAll(360);
  LeftFoot.Move ();
  LeftFoot.ModAll(360);
  RightThigh.Move ();
  RightThigh.ModAll(360);
  RightShin.Move ();
  RightShin.ModAll(360);
  RightFoot.Move ();
  RightFoot.ModAll(360);
  Hip.Move ();
  Hip.ModAll(360);
}
