#include "KeyFrameAnimation.h"

KeyFrameAnimation::KeyFrameAnimation()
{
 ActiveFrame = -1;
 FrameIsNew = true;
 NumFrames = -1;
}

KeyFrameAnimation::KeyFrameAnimation(const char *filename)
{
 ActiveFrame = -1;
 NumFrames = -1;
 FrameIsNew = true;
 Load(filename);
}

bool KeyFrameAnimation::Load(const char *filename)
{
 fstream in(filename, ios::in);
 if (in.bad())
  return false;
 while (!in.eof())
 {
  JointAngles *temp = new JointAngles();
  in>>*temp;
  NumFrames++;
  JointPositions.push_back(temp);
 }
// cout<<"Loaded "<<filename<<"..numframes = "<<NumFrames<<endl;
 in.close();
 return true;
}

void KeyFrameAnimation::Animate(JointAngles &s)
{
  if (ActiveFrame != -1 && ((s == *JointPositions[ActiveFrame]) || FrameIsNew))
 {
  s.MoveTowards(*JointPositions[ActiveFrame]);
  FrameIsNew = false;
 }
 if (!Done && (ActiveFrame == -1 || (s == *JointPositions[ActiveFrame])))
 {
  ActiveFrame++;
  FrameIsNew = true;
  //  cout<<"Moving towards frame "<<ActiveFrame<<endl;
  if (ActiveFrame >= NumFrames)
  //   s.MoveTowards(*JointPositions[ActiveFrame]);
    //  else
  {
    //   FrameIsNew = true;
    //   Done = true;
    //   ActiveFrame = -1;
   Reset();
  }
 }
}

void KeyFrameAnimation::Reset()
{
 ActiveFrame = -1;
 FrameIsNew = true;
 Done = false;
}

