// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.

#include "LineSet.h"
#include "SpeedFactor.h"
//#include "GTeam.h"
#include <queue>
#include <vector>

using namespace std;

LineSet::LineSet()
{
 Team=0;
 Description="";
 for (int x=0;x<NUMLINES;x++)
  for (int y=0;y<5;y++)
   Lines[x][y]=0;
}

LineSet::LineSet(int team, string description, int **lines)
{
 Team=team;
 Description=description;
 for (int x=0;x<NUMLINES;x++)
  for (int y=0;y<5;y++)
   Lines[x][y]=lines[x][y];
}

int **LineSet::GetLines(int situation)
{
 int **lines=new int*[NUMLINESPERSITUATION];
 for (int x=0;x<NUMLINESPERSITUATION;x++)
 {
  lines[x]=new int[5];
  lines[x]=Lines[(situation*NUMLINESPERSITUATION)+x];
 }
 return lines;
}

void LineSet::Generate(SKATERLIST *skaters)
{
 for (int x=0;x<NUMSITUATIONS;x++)
  {
//   if (x<NUMSITUATIONS+3)
    //   {
    queue<GSkater> lw;
    queue<GSkater> c;
    queue<GSkater> rw;
    queue<GSkater> rd;
    queue<GSkater> ld;

/*	 
	priority_queue<GSkater, vector<GSkater>, SpeedFactor> lw;
    priority_queue<GSkater, vector<GSkater>, SpeedFactor> c;
    priority_queue<GSkater, vector<GSkater>, SpeedFactor> rw;
    priority_queue<GSkater, vector<GSkater>, SpeedFactor> rd;
    priority_queue<GSkater, vector<GSkater>, SpeedFactor> ld;
*/
//    SKATERLIST::iterator i;
    for (int i=0;i<skaters->size();i++)
    {
      GSkater s=(*skaters)[i];
      //      cout<<"ID="<<s.GetID()<<", SpeedFactor="<<s.SpeedFactor()<<endl;
     switch (s.GetPosition())
     {
      case CENTER:
       c.push(s); break;
      case LEFTWING:
       lw.push(s); break;
      case RIGHTWING:
       rw.push(s); break;
      case LEFTDEFENSE:
       ld.push(s); break;
      case RIGHTDEFENSE:
       rd.push(s); break;
     }
     // cout<<"Pushed it..."<<endl;
    }
    //    cout<<"Starting to pop all kinds of stuff...hope the pq's are full."<<endl;
	for (int y=0;y<NUMLINESPERSITUATION;y++)
    {
	 //int x = c.front().GetID();
      //    cout<<"Generating line "<<x*NUMLINESPERSITUATION+y<<endl;
     Lines[(x*NUMLINESPERSITUATION)+y][CENTER]=c.front().GetID();
     Lines[(x*NUMLINESPERSITUATION)+y][LEFTWING]=lw.front().GetID();
     Lines[(x*NUMLINESPERSITUATION)+y][RIGHTWING]=rw.front().GetID();
     Lines[(x*NUMLINESPERSITUATION)+y][LEFTDEFENSE]=ld.front().GetID();
     Lines[(x*NUMLINESPERSITUATION)+y][RIGHTDEFENSE]=rd.front().GetID();
     c.pop();
     lw.pop();
     rw.pop();
     ld.pop();
     rd.pop();
    }
  }    
//  cout<<"========================================="<<endl;
//  for (int z=0;z<NUMLINES;z++)
//  {
//    cout<<"Line set "<<z<<":  ";
//    for (int w=0;w<5;w++)
//      cout<<Lines[z][w]<<" ";
//    cout<<endl;
//  }

}