// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#ifndef GAMEDRIVER
#define GAMEDRIVER

#ifdef USEMFC
#include "stdafx.h"
#include <GL/gl.h>
#else
#include <GL/glut.h>
#endif
#include "Constants.h"
#include "Utils.h"
#include "Game.h"
#include "Point.h"
#include "Tiff.h"
#include "Bitmap.h"
#include "Environment.h"

class GameDriver
{
  public:
  GameDriver (int display, int hometeamid, int visitorteamid, int SoundEffectsOn);
   ~GameDriver ();
#ifndef TWODVERSION
		void Init ();
  void DrawGoal ();
  void Play (KeyData * keys);
  void DrawIce ();
#endif
#ifdef TWODVERSION
  void Play (KeyData * keys, CDC &dc);
  void DrawIce (CDC &dc);
#endif

  double GetPuckX ();
  double GetPuckY ();
  double GetPuckZ ();
  double GetPuckXVelocity ();
  double GetPuckYVelocity ();
  double GetPuckZVelocity ();
  int GetHomeScore ();
  int GetVisitorScore ();
  int GetHomeShots ();
  int GetVisitorShots ();
  int GetHomeStrength ();
  int GetVisitorStrength ();
  int GetHomeGoalieStrength ();
  int GetVisitorGoalieStrength ();
  Point GetHomeGoalieCoordinates ();
  char *GetStatusBarText ();
  char *GetTimeText ();
  int WriteTiff(char *filename, char *description, int x, int y, int width, int height, int compression);
  CoachSettings HomeCoachSettings, VisitorCoachSettings;
  Game *MrGame;
  ControlData HomeControl, VisitorControl;
  int IceTexturesOn, PlayerTexturesOn;
  int SoundEffectsOn;
 protected:
  int Display;
  GLuint IceTexName1, IceTexName2, IceTexName3;
  GLuint AdTexName1, AdTexName2, AdTexName3, AdTexName4, AdTexName5, AdTexName6, AdTexName7, AdTexName8, AdTexName9, AdTexName10;
//      CBitmap IceTexture;
  uint32 *IceTexture1, *IceTexture2, *IceTexture3;
  GLubyte *AdTexture1, *AdTexture2, *AdTexture3, *AdTexture4, *AdTexture5, 
   *AdTexture6, *AdTexture7, *AdTexture8, *AdTexture9, *AdTexture10;
  Tiff Ice1, Ice2, Ice3;
  Bitmap Ad1, Ad2, Ad3, Ad4, Ad5, Ad6, Ad7, Ad8, Ad9,
    Ad10;
  Environment Arena;
  char TimeText[10];
  long Time;
  KeyData *Keys;
};
#endif
