// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#ifdef USEMFC
#include "stdafx.h"
#include <GL/gl.h>
#else
#include <GL/glut.h>
#endif

#include <time.h>
#include "Main.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

GameDriver::GameDriver (int display):
  Ice1 (), Ice2 (), Ice3 (), Ad1 (), Ad2 (), Ad3 (), Ad4 (), Ad5 (), Ad6 (),
  Ad7 (), Ad8 (), Ad9 (), 
Ad10 ()
{
  Display = display;
#ifndef TWODVERSION
  if (Display)
    {
      // Load the bitmaps in Windows Format
      Ice1.Load ("ice1.bmp");
      Ice2.Load ("ice2.bmp");
      Ice3.Load ("ice3.bmp");
      Ad1.Load ("ad1.bmp");
      Ad2.Load ("ad2.bmp");
      Ad3.Load ("ad3.bmp");
      Ad4.Load ("ad4.bmp");
      Ad5.Load ("ad5.bmp");
      Ad6.Load ("ad6.bmp");
      Ad7.Load ("ad7.bmp");
      Ad8.Load ("ad8.bmp");
      Ad9.Load ("ad9.bmp");
      Ad10.Load ("ad10.bmp");
    }
#endif
  //Seed the random number generator
  srand ((unsigned int) time (NULL));
  Time = 0;			//initialize the game time

  //Initialize the coach settings to neutral values
  HomeCoachSettings.Breakout = 50;
  HomeCoachSettings.PassDump = 50;
  HomeCoachSettings.ShotAggression = 50;
  HomeCoachSettings.ForecheckingAggression = 50;
  HomeCoachSettings.NumForeCheckers = 3;
  HomeCoachSettings.Coverage = 1;
  HomeCoachSettings.ManPuck = 50;
  HomeCoachSettings.StayHomeAttack = 50;
  VisitorCoachSettings.Breakout = 50;
  VisitorCoachSettings.PassDump = 50;
  VisitorCoachSettings.ShotAggression = 50;
  VisitorCoachSettings.ForecheckingAggression = 50;
  VisitorCoachSettings.NumForeCheckers = 3;
  VisitorCoachSettings.Coverage = 1;
  VisitorCoachSettings.ManPuck = 50;
  VisitorCoachSettings.StayHomeAttack = 50;

  // Initialize user input settings - starts at none
  HomeControl.Coaching = -1;
  VisitorControl.Coaching = -1;
  HomeControl.LineChanges = 0;
  VisitorControl.LineChanges = 0;
  HomeControl.Player = -1;
  VisitorControl.Player = -1;
  HomeControl.Position = -1;
  VisitorControl.Position = -1;
  HomeControl.PuckHog = -1;
  VisitorControl.PuckHog = -1;

#ifndef TWODVERSION
  if (Display)
    {
      // Generate OpenGL-formatted textures from the Windows
      // Bitmaps
      IceTexture1 = Ice1.GetGLTexture ();
      IceTexture2 = Ice2.GetGLTexture ();
      IceTexture3 = Ice3.GetGLTexture ();
      AdTexture1 = Ad1.GetGLTexture ();
      AdTexture2 = Ad2.GetGLTexture ();
      AdTexture3 = Ad3.GetGLTexture ();
      AdTexture4 = Ad4.GetGLTexture ();
      AdTexture5 = Ad5.GetGLTexture ();
      AdTexture6 = Ad6.GetGLTexture ();
      AdTexture7 = Ad7.GetGLTexture ();
      AdTexture8 = Ad8.GetGLTexture ();
      AdTexture9 = Ad9.GetGLTexture ();
      AdTexture10 = Ad10.GetGLTexture ();
    }
  // Set all textures to on
#endif
  IceTexturesOn = 1;
  PlayerTexturesOn = 1;
  //Instantiate the game object
  MrGame = new Game (HomeCoachSettings, VisitorCoachSettings);
}

GameDriver::~GameDriver ()
{
  delete MrGame;
}

#ifndef TWODVERSION
void GameDriver::
Init ()
{
  if (Display)
    {
      glShadeModel (GL_FLAT);
      glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
      // Get texture names for all ice textures to be used
      glGenTextures (1, &IceTexName1);
      glGenTextures (1, &IceTexName2);
      glGenTextures (1, &IceTexName3);
      glGenTextures (1, &AdTexName1);
      glGenTextures (1, &AdTexName2);
      glGenTextures (1, &AdTexName3);
      glGenTextures (1, &AdTexName4);
      glGenTextures (1, &AdTexName5);
      glGenTextures (1, &AdTexName6);
      glGenTextures (1, &AdTexName7);
      glGenTextures (1, &AdTexName8);
      glGenTextures (1, &AdTexName9);
      glGenTextures (1, &AdTexName10);
      MrGame->GenerateTextures ();


      //Set parameters for each texture, and download them
      //to OpenGL memory using glTexImage2D
      glBindTexture (GL_TEXTURE_2D, IceTexName1);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 256, 256 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, IceTexture1);

      glBindTexture (GL_TEXTURE_2D, IceTexName2);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 256, 256 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, IceTexture2);

      glBindTexture (GL_TEXTURE_2D, IceTexName3);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 256, 256 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, IceTexture3);

      glBindTexture (GL_TEXTURE_2D, AdTexName1);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 256, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture1);

      glBindTexture (GL_TEXTURE_2D, AdTexName2);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 256, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture2);

      glBindTexture (GL_TEXTURE_2D, AdTexName3);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 256, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture3);

      glBindTexture (GL_TEXTURE_2D, AdTexName4);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 256, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture4);

      glBindTexture (GL_TEXTURE_2D, AdTexName5);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 256, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture5);

      glBindTexture (GL_TEXTURE_2D, AdTexName6);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 256, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture6);

      glBindTexture (GL_TEXTURE_2D, AdTexName7);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 128, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture7);

      glBindTexture (GL_TEXTURE_2D, AdTexName8);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 128, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture8);

      glBindTexture (GL_TEXTURE_2D, AdTexName9);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 128, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture9);

      glBindTexture (GL_TEXTURE_2D, AdTexName10);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, 128, 64 /*width,length */ , 0, GL_RGB, GL_UNSIGNED_BYTE, AdTexture10);
    }

  //      glTexImage2D(GL_TEXTURE_2D,0,GL_RGB,32,32/*width,length*/,0,GL_RGB,GL_UNSIGNED_BYTE,IceTexture);
  // glTexImage2D(GL_TEXTURE_2D,0,GL_RGB,256,256/*width,length*/,0,GL_BGR_EXT,GL_UNSIGNED_BYTE,IceTexture);
}
#endif

#ifndef TWODVERSION
void GameDriver::
Play (KeyData * keys)
#endif
#ifdef TWODVERSION
void GameDriver::
Play (KeyData * keys, CDC &dc)
#endif
{
  Keys = keys;			// Send the most recent key statuses
  Time++;			// Increment the game time


  // Play the game for a frame

#ifndef TWODVERSION
  if (Display)
    DrawIce ();			// Render the ice
  MrGame->Play (Time, HomeCoachSettings, VisitorCoachSettings,
			HomeControl, VisitorControl, *Keys, IceTexture1, PlayerTexturesOn, Display);
#endif
#ifdef TWODVERSION
  if (Display)
    DrawIce (dc);			// Render the ice
  MrGame->Play (Time, HomeCoachSettings, VisitorCoachSettings,
			HomeControl, VisitorControl, *Keys, IceTexture1, PlayerTexturesOn, Display,dc);
#endif
}

double GameDriver::
GetPuckX ()
{
  return MrGame->GetPuckX ();
}

double GameDriver::
GetPuckY ()
{
  return MrGame->GetPuckY ();
}

double GameDriver::
GetPuckZ ()
{
  return MrGame->GetPuckZ ();
}

int GameDriver::
GetHomeStrength ()
{
  return MrGame->GetStrength (0);
}

int GameDriver::
GetVisitorStrength ()
{
  return MrGame->GetStrength (1);
}

int GameDriver::
GetHomeGoalieStrength ()
{
  return MrGame->GetGoalieStrength (0);
}

int GameDriver::
GetVisitorGoalieStrength ()
{
  return MrGame->GetGoalieStrength (1);
}


double GameDriver::
GetPuckXVelocity ()
{
  return MrGame->GetPuckXVelocity ();
}

double GameDriver::
GetPuckYVelocity ()
{
  return MrGame->GetPuckYVelocity ();
}

double GameDriver::
GetPuckZVelocity ()
{
  return MrGame->GetPuckZVelocity ();
}

Point GameDriver::
GetHomeGoalieCoordinates ()
{
  return MrGame->GetHomeGoalieCoordinates ();
}

#ifndef TWODVERSION
void GameDriver::
DrawGoal ()
// Draws a goal
{
  double theta;
  glPushMatrix ();
  glBegin (GL_LINES);
  glColor3f (.9, .9, .9);
  for (theta = pi; theta < 3 * pi / 2; theta += .5)
    {
      // One rounded corner (vertical line)
      glVertex3f (cos (theta) * 2, -goallength / 2 + sin (theta) * 2, 0);
      glVertex3f (cos (theta) * 2, -goallength / 2 + sin (theta) * 2, 14);

      for (int z = 0; z < 14; z += 2)
	{
	  // The horizontal lines for this corner
	  glVertex3f (cos (theta) * 2, -goallength / 2 + sin (theta) * 2, z);
	  glVertex3f (cos (theta - .5) * 2, -goallength / 2 + sin (theta - .5) * 2, z);
	}
    }
  for (double y = -goallength / 2; y < goallength / 2; y += .5)
    {
      // The vertical lines for the back of the goal
      glVertex3f (-2, y, 0);
      glVertex3f (-2, y, 14);
      for (int z = 0; z < 14; z += 2)
	{
	  // The horizontal lines for the back of the goal
	  glVertex3f (-2, y, z);
	  glVertex3f (-2, y + .5, z);
	}
    }
  for (theta = pi / 2; theta < pi; theta += .5)
    {
      // The other curved portion...
      glVertex3f (cos (theta) * 2, goallength / 2 + sin (theta) * 2, 0);
      glVertex3f (cos (theta) * 2, goallength / 2 + sin (theta) * 2, 14);
      for (int z = 0; z < 14; z += 2)
	{
	  glVertex3f (cos (theta) * 2, goallength / 2 + sin (theta) * 2, z);
	  glVertex3f (cos (theta - .5) * 2, goallength / 2 + sin (theta - .5) * 2, z);
	}
    }
  glEnd ();
  glColor3f (1, 0, 0);
  Box (3, goallength / 2 + 2, 14, 2, goallength / 2 + 1, 0);
  Box (3, -goallength / 2 - 2, 14, 2, goallength / 2 + 2, 11);
  Box (3, -goallength / 2 - 1, 14, 2, -goallength / 2 - 2, 0);
  glPopMatrix ();
}

void GameDriver::
DrawIce ()
// Renders the ice...
{
  if (IceTexturesOn)
    glEnable (GL_TEXTURE_2D);	// Enable Texturing

  glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
// glTexImage2D(GL_TEXTURE_2D,0,GL_RGB,32,32/*width,length*/,0,GL_RGB,GL_UNSIGNED_BYTE,IceTexture);
  glColor3f (0.9, 0.94, 1.0);
  glBindTexture (GL_TEXTURE_2D, IceTexName1);

  // Draws one third of the ice
  glBegin (GL_POLYGON);
  glTexCoord2f (1, 0);
  glVertex3f (length / 3, 0, 0);
  glTexCoord2f (1, 1);
  glVertex3f (length / 3, width, 0);
  glTexCoord2f (0, 1);
  glVertex3f (0, width, 0);
  glTexCoord2f (0, 0);
  glVertex3f (0, 0, 0);
  glEnd ();

  glBindTexture (GL_TEXTURE_2D, IceTexName2);

  // Draws the middle third of the ice
  glBegin (GL_POLYGON);
  glTexCoord2f (1, 0);
  glVertex3f (length * 2 / 3, 0, 0);
  glTexCoord2f (1, 1);
  glVertex3f (length * 2 / 3, width, 0);
  glTexCoord2f (0, 1);
  glVertex3f (length / 3, width, 0);
  glTexCoord2f (0, 0);
  glVertex3f (length / 3, 0, 0);
  glEnd ();

  glBindTexture (GL_TEXTURE_2D, IceTexName3);

  // Draws the final third of the ice
  glBegin (GL_POLYGON);
  glTexCoord2f (1, 0);
  glVertex3f (length, 0, 0);
  glTexCoord2f (1, 1);
  glVertex3f (length, width, 0);
  glTexCoord2f (0, 1);
  glVertex3f (length * 2 / 3, width, 0);
  glTexCoord2f (0, 0);
  glVertex3f (length * 2 / 3, 0, 0);
  glEnd ();


  glColor3f (0, 0, 0);		//originally used to distinguish the curved walls...

  // Draw the solid segments of the walls...
  glBindTexture (GL_TEXTURE_2D, AdTexName1);
  TRectangle (length / 2, 0, 0, -(length / 2 - 75), 12);
  glBindTexture (GL_TEXTURE_2D, AdTexName2);
  TRectangle (length - 60, 0, 0, -(length / 2 - 60), 12);

  glBindTexture (GL_TEXTURE_2D, AdTexName3);
  TRectangle (60, width, 0, length / 2 - 60, 12);
  glBindTexture (GL_TEXTURE_2D, AdTexName4);
  TRectangle (length / 2, width, 0, length / 2 - 75, 12);

  glPushMatrix ();
  glRotatef (-90, 0, 0, 1);
  glBindTexture (GL_TEXTURE_2D, AdTexName5);
  TRectangle (-(width - 60), length, 0, (width - 120), 12);
  glBindTexture (GL_TEXTURE_2D, AdTexName6);
  TRectangle (-(width / 2 - 75), 0, 0, -(width - 75), 12);
  glPopMatrix ();

//      glDisable(GL_TEXTURE_2D);

  // Draw the curved portions of the walls
  glBindTexture (GL_TEXTURE_2D, AdTexName7);
  double theta;
  for (theta = pi / 2; theta > .2; theta -= .2)
    {
      glBegin (GL_POLYGON);
      glTexCoord2f (((pi / 2 - theta) - .2) / (pi / 2 - .2), 1);
      glVertex3f (length - 75 + (75 * cos (theta)), width - 75 + (75 * sin (theta)), 12);
      glTexCoord2f (((pi / 2 - theta) - .2) / (pi / 2 - .2), 0);
      glVertex3f (length - 75 + (75 * cos (theta)), width - 75 + (75 * sin (theta)), 0);
      glTexCoord2f ((pi / 2 - theta) / (pi / 2 - .2), 0);
      glVertex3f (length - 75 + (75 * cos (theta - .2)), width - 75 + (75 * sin (theta - .2)), 0);
      glTexCoord2f ((pi / 2 - theta) / (pi / 2 - .2), 1);
      glVertex3f (length - 75 + (75 * cos (theta - .2)), width - 75 + (75 * sin (theta - .2)), 12);
      glEnd ();
    }

  glBindTexture (GL_TEXTURE_2D, AdTexName8);
  for (theta = 2 * pi; theta > 3 * pi / 2 + .2; theta -= .2)
    {
      glBegin (GL_POLYGON);
      glTexCoord2f (((2 * pi - theta) - (3 * pi / 2 + .2)) / ( /*2*pi- */ ( /*3* */ pi / 2 + .2)), 1);
      glVertex3f (length - 75 + (75 * cos (theta)), 75 + (75 * sin (theta)), 12);
      glTexCoord2f (((2 * pi - theta) - (3 * pi / 2 + .2)) / ( /*2*pi- */ ( /*3* */ pi / 2 + .2)), 0);
      glVertex3f (length - 75 + (75 * cos (theta)), 75 + (75 * sin (theta)), 0);
      glTexCoord2f (((2 * pi - theta) - (3 * pi / 2)) / ( /*2*pi- */ ( /*3* */ pi / 2 + .2)), 0);
      glVertex3f (length - 75 + (75 * cos (theta - .2)), 75 + (75 * sin (theta - .2)), 0);
      glTexCoord2f (((2 * pi - theta) - (3 * pi / 2)) / ( /*2*pi- */ ( /*3* */ pi / 2 + .2)), 1);
      glVertex3f (length - 75 + (75 * cos (theta - .2)), 75 + (75 * sin (theta - .2)), 12);
      glEnd ();
    }


  glBindTexture (GL_TEXTURE_2D, AdTexName9);
  for (theta = pi; theta > pi / 2 + .2; theta -= .2)
    {
      glBegin (GL_POLYGON);
      glTexCoord2f (((pi - theta) - (pi / 2 + .2)) / ( /*pi- */ (pi / 2 /*+.2 */ )), 1);
      glVertex3f (75 + (75 * cos (theta)), width - 75 + (75 * sin (theta)), 12);
      glTexCoord2f (((pi - theta) - (pi / 2 + .2)) / ( /*pi- */ (pi / 2 /*+.2 */ )), 0);
      glVertex3f (75 + (75 * cos (theta)), width - 75 + (75 * sin (theta)), 0);
      glTexCoord2f (((pi - theta) - (pi / 2 /*-.2*/ )) / ( /*pi- */ (pi / 2 /*+.2 */ )), 0);
      glVertex3f (75 + (75 * cos (theta - .2)), width - 75 + (75 * sin (theta - .2)), 0);
      glTexCoord2f (((pi - theta) - (pi / 2 /*-.2*/ )) / ( /*pi- */ (pi / 2 /*+.2 */ )), 1);
      glVertex3f (75 + (75 * cos (theta - .2)), width - 75 + (75 * sin (theta - .2)), 12);
      glEnd ();
    }

  glBindTexture (GL_TEXTURE_2D, AdTexName10);
  for (theta = 3 * pi / 2; theta > pi + .2; theta -= .2)
    {
      glBegin (GL_POLYGON);
      glTexCoord2f (((3 * pi / 2 - theta) - (pi + .2)) / ( /*(3*pi/2)- */ (pi / 2 + .2)), 1);
      glVertex3f (75 + (75 * cos (theta)), 75 + (75 * sin (theta)), 12);
      glTexCoord2f (((3 * pi / 2 - theta) - (pi + .2)) / ( /*(3*pi/2)- */ (pi / 2 + .2)), 0);
      glVertex3f (75 + (75 * cos (theta)), 75 + (75 * sin (theta)), 0);
      glTexCoord2f (((3 * pi / 2 - theta) - (pi)) / ( /*(3*pi/2)- */ (pi / 2 + .2)), 0);
      glVertex3f (75 + (75 * cos (theta - .2)), 75 + (75 * sin (theta - .2)), 0);
      glTexCoord2f (((3 * pi / 2 - theta) - (pi)) / ( /*(3*pi/2)- */ (pi / 2 + .2)), 1);
      glVertex3f (75 + (75 * cos (theta - .2)), 75 + (75 * sin (theta - .2)), 12);
      glEnd ();
    }


  glDisable (GL_TEXTURE_2D);


/*
   glColor3f(0.9,0.94,1.0);
   glBegin(GL_POLYGON);
   for (double theta=0;theta<pi/2;theta+=.3)
   {
   //                   glTexCoord2f((75-(75*cos(theta)))/75,(75-(75*sin(theta)))/75);
   glVertex3f(75-(75*cos(theta)),75-(75*sin(theta)),0);
   }
   glVertex3f(75,0,0);
   for (theta=pi/2;theta<pi;theta+=.3)
   glVertex3f((length-75)-(75*cos(theta)),75-(75*sin(theta)),0);
   glVertex3f(length,75,0);
   for (theta=pi;theta<3*pi/2;theta+=.3)
   glVertex3f((length-75)-(75*cos(theta)),(width-75)-(75*sin(theta)),0);
   glVertex3f(length-75,width,0);
   for (theta=3*pi/2;theta<2*pi;theta+=.3)
   glVertex3f((75)-(75*cos(theta)),(width-75)-(75*sin(theta)),0);
   glVertex3f(0,width-75,0);
   //   glEnd();
   glEnd();
 */
  if (!IceTexturesOn)
    {
      glColor3f (.5, 0, 0);
      glBegin (GL_POLYGON);
      glVertex3f (length / 2 + 1, 0, 1);
      glVertex3f (length / 2 + 1, width, 1);
      glVertex3f (length / 2 - 1, width, 1);
      glVertex3f (length / 2 - 1, 0, 1);
      glEnd ();
      glColor3f (0, 0, .5);
      glBegin (GL_POLYGON);
      glVertex3f (BlueLine[0] + 1, 0, 1);
      glVertex3f (BlueLine[0] + 1, width, 1);
      glVertex3f (BlueLine[0] - 1, width, 1);
      glVertex3f (BlueLine[0] - 1, 0, 1);
      glEnd ();
      glBegin (GL_POLYGON);
      glVertex3f (BlueLine[1] + 1, 0, 1);
      glVertex3f (BlueLine[1] + 1, width, 1);
      glVertex3f (BlueLine[1] - 1, width, 1);
      glVertex3f (BlueLine[1] - 1, 0, 1);
      glEnd ();
    }

  glColor3f (.1, .1, .1);
  glPushMatrix ();
  glTranslatef (homegoalx, width / 2, 0);
  DrawGoal ();
  glPopMatrix ();
  glPushMatrix ();
  glTranslatef (visitorgoalx, width / 2, 0);
  glRotatef (180, 0, 0, 1);
  DrawGoal ();
  glPopMatrix ();


//      glColor3f(.7,.7,.7);
  //      Box(homegoalx+goalwidth/2,width/2-goallength/2,10,homegoalx-goalwidth/2,width/2+goallength/2,0);
  //      Box(visitorgoalx-goalwidth/2,width/2-goallength/2,10,visitorgoalx+goalwidth/2,width/2+goallength/2,0);



}
#endif

#ifdef TWODVERSION
void GameDriver::DrawIce(CDC & DC)
{
 CPen BluePen(PS_SOLID,2,RGB(0,0,200));
 CPen BorderPen(PS_SOLID,1,RGB(0,0,0));
 CPen RedPen(PS_SOLID,2,RGB(150,0,0));
 CBrush WhiteBrush(RGB(255,255,255));

 CPen *pPen=DC.SelectObject(&BluePen);
 CBrush *pBrush=DC.SelectObject(&WhiteBrush);


 CRect ClientRect;
 ClientRect.top=0;
 ClientRect.bottom=480;
 ClientRect.right=640;
 ClientRect.left=0;
 //GetClientRect(ClientRect);
  
 DC.ExtTextOut(0,0,ETO_OPAQUE,ClientRect,"",0);
 DC.SelectObject(&BluePen);

	/////
/*	Point AxisStart(0,0,0);
 DC.MoveTo(AxisStart.MapX(),AxisStart.MapY());
	Point AxisEnd(640,0,0);
 DC.LineTo(AxisEnd.MapX(),AxisEnd.MapY());

	Point Axis2Start(640,0,0);
 DC.MoveTo(Axis2Start.MapX(),Axis2Start.MapY());
	Point Axis2End(640,480,0);
 DC.LineTo(Axis2End.MapX(),Axis2End.MapY());

	
*/////
	Point blueline(BlueLine[0],0,0);
	DC.MoveTo((int)blueline.MapX(),(int)blueline.MapY());
 blueline.Y=width;
	DC.LineTo((int)blueline.MapX(),(int)blueline.MapY());
	blueline.X=BlueLine[1];
	DC.MoveTo((int)blueline.MapX(),(int)blueline.MapY());
	blueline.Y=0;
	DC.LineTo((int)blueline.MapX(),(int)blueline.MapY());
 DC.SelectObject(&BorderPen);

	Point Border(0,0,0);
 DC.MoveTo(Border.MapX(),Border.MapY());
	Border.X=length;
 DC.LineTo((int)Border.MapX(),Border.MapY());
	Border.Y=width;
	DC.LineTo((int)Border.MapX(),Border.MapY());
	Border.X=0;
	DC.LineTo((int)Border.MapX(),Border.MapY());
	Border.Y=0;
	DC.LineTo((int)Border.MapX(),Border.MapY());

 CRect Corner;
 Border.X=length-150;
	Border.Y=0;
 Corner.top=Border.MapY();
 Corner.left=(int)Border.MapX();
	Border.X=length;
	Border.Y=150;
 Corner.right=(int)Border.MapX();
 Corner.bottom=(int)Border.MapY();
	Border.X=length;
	Border.Y=75;
 CPoint Start((int)Border.MapX(),Border.MapY());
	Border.X=length-75;
 Border.Y=0;
 CPoint End((int)Border.MapX(),Border.MapY());
 DC.Arc(Corner,Start,End);
 DC.MoveTo((int)length-1, 73);
 DC.LineTo((int)length-1,(int)width-74);
 Corner.top=(int)width-150;
 Corner.bottom=(int)width;
 Corner.left=(int)length-150;
 Corner.right=(int)length;
 CPoint Start2((int)length-75,(int)width);
 CPoint End2((int)length,(int)width-75);
 DC.Arc(Corner,Start2,End2);
 DC.MoveTo((int)length-75, (int)width-1);

 DC.LineTo(75,(int)width-1);
 Corner.top=(int)width-150;
 Corner.bottom=(int)width;
 Corner.left=0;
 Corner.right=150;
 CPoint Start3(0,(int)width-75);
 CPoint End3(75,(int)width);
 DC.Arc(Corner,Start3,End3);
 DC.MoveTo(0, (int)width-75);


 DC.LineTo(0,75);
 Corner.top=0;
 Corner.bottom=150;
 Corner.left=0;
 Corner.right=150;
 CPoint Start4(75,0);
 CPoint End4(0,75);
 DC.Arc(Corner,Start4,End4);

//	DC.MoveTo((int)length-1, 73);

 DC.SelectObject(&RedPen);
 Border.X=homegoalx+5;
	Border.Y=0;
 DC.MoveTo((int)Border.MapX(),(int)Border.MapY());
	Border.Y=width;
 DC.LineTo((int)Border.MapX(),(int)Border.MapY());
	Border.X=visitorgoalx-5;
	Border.Y=0;
 DC.MoveTo((int)Border.MapX(),(int)Border.MapY());
	Border.Y=width;
 DC.LineTo((int)Border.MapX(),(int)Border.MapY());


 DC.SelectObject(&WhiteBrush);
 DC.SelectObject(&RedPen);
 CRect FaceoffCircle;
 FaceoffCircle.top=(int)((3.0/80.0)*width);
 FaceoffCircle.bottom=(int)((33.0/80.0)*width);
 FaceoffCircle.left=(int)((16.0/200.0)*length);
 FaceoffCircle.right=(int)((46.0/200.0)*length);
 DC.Ellipse(FaceoffCircle);

 FaceoffCircle.top=(int)(width-(3.0/80.0)*width);
 FaceoffCircle.bottom=(int)(width-(33.0/80.0)*width);
 FaceoffCircle.left=(int)((16.0/200.0)*length);
 FaceoffCircle.right=(int)((46.0/200.0)*length);
 DC.Ellipse(FaceoffCircle);

 FaceoffCircle.top=(int)((3.0/80.0)*width);
 FaceoffCircle.bottom=(int)((33.0/80.0)*width);
 FaceoffCircle.left=(int)(length-(16.0/200.0)*length);
 FaceoffCircle.right=(int)(length-(46.0/200.0)*length);
 DC.Ellipse(FaceoffCircle);

 FaceoffCircle.top=(int)(width-(3.0/80.0)*width);
 FaceoffCircle.bottom=(int)(width-(33.0/80.0)*width);
 FaceoffCircle.left=(int)(length-(16.0/200.0)*length);
 FaceoffCircle.right=(int)(length-(46.0/200.0)*length);
 DC.Ellipse(FaceoffCircle);

 FaceoffCircle.top=(int)(width/2-(22.0/80.0)*width);
 FaceoffCircle.bottom=(int)(width/2+(22.0/80.0)*width);
 FaceoffCircle.left=(int)(length/2-(22.0/200.0)*length);
 FaceoffCircle.right=(int)(length/2+(22.0/200.0)*length);
 DC.Ellipse(FaceoffCircle);

 Border.X=length/2;
	Border.Y=0;
 DC.MoveTo((int)Border.MapX(),Border.MapY());
	Border.Y=width;
 DC.LineTo((int)Border.MapX(),Border.MapY());

 DC.SelectObject(&BorderPen);
 CRect Goal1;
 Goal1.top=(int)((width/2)-goallength/2);
 Goal1.bottom=(int)((width/2)+goallength/2);
 Goal1.left=(int)(homegoalx-goalwidth/2);
 Goal1.right=(int)(homegoalx+goalwidth/2);
 CRect Goal2;
 Goal2.top=(int)((width/2)-goallength/2);
 Goal2.bottom=(int)((width/2)+goallength/2);
 Goal2.left=(int)(visitorgoalx-goalwidth/2);
 Goal2.right=(int)(visitorgoalx+goalwidth/2);
 DC.SelectObject(&BorderPen);
 DC.Rectangle(Goal1);
 DC.Rectangle(Goal2);

 DC.SelectObject(pPen);
//  MessageBox("Big pen Trouble!");
 DC.SelectObject(pBrush);
//  MessageBox("Big brush Trouble!");
}
#endif

int GameDriver::
GetHomeScore ()
{
  return MrGame->GetScore (0);
}

int GameDriver::
GetVisitorScore ()
{
  return MrGame->GetScore (1);
}

int GameDriver::
GetHomeShots ()
{
  return MrGame->GetShots (0);
}

int GameDriver::
GetVisitorShots ()
{
  return MrGame->GetShots (1);
}


char *GameDriver::
GetStatusBarText ()
{
  return MrGame->GetStatusBarText ();
}

#ifdef USEMFC
char *GameDriver::
GetTimeText ()
{
  char buf[15];
  char buf2[15];
  ltoa (Time / TicksPerMinute, buf, 10);
  ltoa ((Time % TicksPerMinute) / TicksPerSecond, buf2, 10);
  if (Time / TicksPerMinute < 10)
    strcpy (TimeText, "0");
  else
    strcpy (TimeText, "");
  strcat (TimeText, buf);
  if ((Time % TicksPerMinute) / TicksPerSecond < 10)
    strcat (TimeText, ":0");
  else
    strcat (TimeText, ":");
  strcat (TimeText, buf2);
  return TimeText;
}
#endif

#ifndef USEMFC
GameDriver g (1);
GLfloat a, b, c;
int View;
KeyData Keys;


void
display (void)
{
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glClearColor (.3, .3, .3, 1);
  glLoadIdentity ();

  switch (View)
    {
    case 3:
      gluLookAt (g.GetPuckX (), g.GetPuckY (), g.GetPuckZ () + 3, g.GetPuckX () + g.GetPuckXVelocity (), g.GetPuckY () + g.GetPuckYVelocity (), 3, 0, 0, 1);
      break;
    case 2:
      if (g.GetPuckX () > length - length / 4)
	gluLookAt (length / 2, width / 2, 175 + c, length - length / 4, width / 2, 0, 0, 0, 1);
      else
	gluLookAt (g.GetPuckX () - length / 4, width / 2, 175 + c, g.GetPuckX (), width / 2, 0, 0, 0, 1);
      break;
    case 1:
      if (g.GetPuckX () < length / 4)
	gluLookAt (length / 2, width + 100, 125 + c, length / 4 + a, b, 0, 0, 0, 1);
      else if (g.GetPuckX () > length - length / 4)
	gluLookAt (length / 2, width + 100, 125 + c, length - length / 4 + a, b, 0, 0, 0, 1);
      else
	gluLookAt (length / 2, width + 100, 125 + c, g.GetPuckX () + a, b, 0, 0, 0, 1);
      break;
    }

  g.Play (&Keys);
//      DrawIce();
  glFlush ();
  glutSwapBuffers ();
}

void
playatick ()
{
  g.Play (&Keys);
  display ();
}


void
reshape (int w, int h)
{
  glViewport (0, 0, w, h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
//      glOrtho(0.0,length,width,0.0,-width,width);
  //glFrustum(-length/5,length/5,-2,5,1,width);
  gluPerspective (45.0, 1, 1, length);
  glMatrixMode (GL_MODELVIEW);
}

void
Rotate (unsigned char key, int x, int y)
{
  glLoadIdentity ();
  switch (key)
    {
    case 27: 
      exit(0);
    case 's':
      a += 1.0;
      break;
    case 'f':
      a -= 1.0;
      break;
    case 'e':
      b += 1.0;
      break;
    case 'd':
      b -= 1.0;
    case 'a':
      c += 1.0;
      break;
    case 'z':
      c -= 1.0;
      break;
    case '1':
      View = 1;
      break;
    case '2':
      View = 2;
      break;
    case '3':
      View = 3;
      break;
    case '0':
      g.IceTexturesOn=!g.IceTexturesOn;
      break;
    case '9':
      g.PlayerTexturesOn=!g.PlayerTexturesOn;
      break;
    }


}


int
main (int argc, char **argv)
{
  cout<<"mHockey, version .45, Copyright (C) 1998 Mike Johns.\n";
  cout<<"mHockey comes with ABSOLUTELY NO WARRANTY."<<endl;
  cout<<"This is free software, and you are welcome to "<<endl;
  cout<<"redistribute it under certain conditions.  For details, read"<<endl;
  cout<<"the file LICENCE, included in this distribution."<<endl;
  View = 1;
  a = 0;
  b = width / 2;
  c = 0;
#ifdef MESAFX
  putenv("MESA_GLX_FX=fullscreen");
#endif
  glutInit (&argc, argv);
  glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
  glutInitWindowSize (640, 480);
  glutCreateWindow ("Hockey Simulator");
  glutReshapeFunc (reshape);
  glutDisplayFunc (display);
  glutIdleFunc (playatick);
//		glutTimerFunc(500,playatick,1);
  glEnable (GL_CULL_FACE);
  glCullFace (GL_BACK);
  glEnable (GL_DEPTH_TEST);
  g.Init ();
  glutKeyboardFunc (Rotate);
  glutMainLoop ();
  return (0);
}
#endif
