// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#include "Model.h"
#include "Point.h"
#include <iostream>
#include <fstream>
#include "Utils.h"
#include <math.h>
#ifdef USEMFC
#include "stdafx.h"
#include <GL/gl.h>
#else
#include <GL/glut.h>
#endif
#include <string.h>
#include <string>

using namespace std;

Model::Model ():BodyParts ()
{
  //  Vertices = new double *[300];
  //  for (int a = 0; a < 300; a++)
  //    Vertices[a] = new double[3];
  //  for (int x = 0; x < 300; x++)
  //    for (int i = 0; i < 3; i++)
  //      Vertices[x][i] = 0;
  //  NumVertices = 0;

}

Model::~Model ()
{
  //  for (int a = 0; a < 300; a++)
  //    delete[]Vertices[a];
  //  delete[]Vertices;
}

Model::Model (char *filename):
BodyParts ()
{
//   Vertices = new double *[300];
//   for (int a = 0; a < 300; a++)
//     Vertices[a] = new double[3];
//   for (int x = 0; x < 300; x++)
//     for (int i = 0; i < 3; i++)
//       Vertices[x][i] = 0;
//   NumVertices = 0;

  Load (filename);
}

//#ifdef USEMFC
//Model::Model (CArchive & mdlfile /*char *filename */ ):BodyParts ()
//{
//   Vertices = new double *[300];
//   for (int a = 0; a < 300; a++)
//     Vertices[a] = new double[3];
//   for (int x = 0; x < 300; x++)
//     for (int i = 0; i < 3; i++)
//       Vertices[x][i] = 0;
//   NumVertices = 0;

//  LoadACFile (mdlfile);
//}
//#endif
//#ifndef USEMFC
Model:: Model (fstream & mdlfile):BodyParts ()
{
  //  Vertices = new double *[300];
  //  for (int a = 0; a < 300; a++)
  //    Vertices[a] = new double[3];
  //  for (int x = 0; x < 300; x++)
  //    for (int i = 0; i < 3; i++)
  //      Vertices[x][i] = 0;
  //  NumVertices = 0;

  LoadACFile (mdlfile);
}
//#endif


Model::Model (Model * m)
{
//   Vertices = new double *[300];
//   for (int a = 0; a < 300; a++)
//     Vertices[a] = new double[3];
//   NumVertices = m->NumVertices;
//   for (int x = 0; x < 300; x++)
//     for (int y = 0; y < 3; y++)
//       Vertices[x][y] = m->Vertices[x][y];
  BodyParts = m->BodyParts;
}


int Model::
SetPartStarts (char *part)
{
  /*
     if (strcmp(part,"HEAD_FRONT")==0)
     {
     BodyParts.Head.SetStartIndex(NumVertices);
     return 1;
     }
     if (strcmp(part,"NECK_FRONT")==0)
     {
     BodyParts.Neck.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"TORSO_FRONT")==0)
     {
     BodyParts.Torso.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"LEFT_UPPER_ARM_FRONT")==0)
     {
     BodyParts.LeftUpperArm.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"RIGHT_UPPER_ARM_FRONT")==0)
     {
     BodyParts.RightUpperArm.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"LEFT_LOWER_ARM_FRONT")==0)
     {
     BodyParts.LeftLowerArm.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"RIGHT_LOWER_ARM_FRONT")==0)
     {
     BodyParts.RightLowerArm.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"LEFT_HAND_FRONT")==0)
     {
     BodyParts.LeftHand.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"RIGHT_HAND_FRONT")==0)
     {
     BodyParts.RightHand.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"HIP_FRONT")==0)
     { 
     BodyParts.Hip.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"LEFT_THIGH_FRONT")==0)
     {
     BodyParts.LeftThigh.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"RIGHT_THIGH_FRONT")==0)
     {
     BodyParts.RightThigh.SetStartIndex(NumVertices); 
     return 1;
     }
     else
     if (strcmp(part,"LEFT_SHIN_FRONT")==0)
     {
     BodyParts.LeftShin.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"RIGHT_SHIN_FRONT")==0)
     {
     BodyParts.RightShin.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"LEFT_FOOT_FRONT")==0)
     {
     BodyParts.LeftFoot.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"RIGHT_FOOT_FRONT")==0)
     {
     BodyParts.RightFoot.SetStartIndex(NumVertices);
     return 1;
     }
     else
     if (strcmp(part,"STICK_FRONT")==0)
     {
     BodyParts.Stick.SetStartIndex(NumVertices);
     return 1;
     }
   */
  return 0;
}

void Model::
SetPartEnds (char *part)
{
  /*
     if (strcmp(part,"HEAD_RIGHT_SIDE")==0)
     BodyParts.Head.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"NECK_RIGHT_SIDE")==0)
     BodyParts.Neck.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"TORSO_RIGHT_SIDE")==0)
     BodyParts.Torso.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"LEFT_UPPER_ARM_RIGHT_SIDE")==0)
     BodyParts.LeftUpperArm.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"RIGHT_UPPER_ARM_RIGHT_SIDE")==0)
     BodyParts.RightUpperArm.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"LEFT_LOWER_ARM_RIGHT_SIDE")==0)
     BodyParts.LeftLowerArm.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"RIGHT_LOWER_ARM_RIGHT_SIDE")==0)
     BodyParts.RightLowerArm.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"LEFT_HAND_RIGHT_SIDE")==0)
     BodyParts.LeftHand.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"RIGHT_HAND_RIGHT_SIDE")==0)
     BodyParts.RightHand.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"HIP_RIGHT_SIDE")==0)
     BodyParts.Hip.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"LEFT_THIGH_RIGHT_SIDE")==0)
     BodyParts.LeftThigh.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"RIGHT_THIGH_RIGHT_SIDE")==0)
     BodyParts.RightThigh.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"LEFT_SHIN_RIGHT_SIDE")==0)
     BodyParts.LeftShin.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"RIGHT_SHIN_RIGHT_SIDE")==0)
     BodyParts.RightShin.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"LEFT_FOOT_RIGHT_SIDE")==0)
     BodyParts.LeftFoot.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"RIGHT_FOOT_RIGHT_SIDE")==0)
     BodyParts.RightFoot.SetEndIndex(NumVertices-1);
     else
     if (strcmp(part,"STICK_RIGHT_SIDE")==0)
     BodyParts.Stick.SetEndIndex(NumVertices-1);
   */
}
/*
void Model::
SetVertices (int PartNumber, int **Polygon, int numvertices[6])
{
  switch (PartNumber)
    {
    case 0:
      BodyParts.Head.SetVertices (Polygon, numvertices);
      break;
    case 1:
      BodyParts.Neck.SetVertices (Polygon, numvertices);
      break;
    case 2:
      BodyParts.Torso.SetVertices (Polygon, numvertices);
      break;
    case 3:
      BodyParts.LeftUpperArm.SetVertices (Polygon, numvertices);
      break;
    case 4:
      BodyParts.RightUpperArm.SetVertices (Polygon, numvertices);
      break;
    case 5:
      BodyParts.LeftLowerArm.SetVertices (Polygon, numvertices);
      break;
    case 6:
      BodyParts.RightLowerArm.SetVertices (Polygon, numvertices);
      break;
    case 7:
      BodyParts.LeftHand.SetVertices (Polygon, numvertices);
      break;
    case 8:
      BodyParts.RightHand.SetVertices (Polygon, numvertices);
      break;
    case 9:
      BodyParts.Hip.SetVertices (Polygon, numvertices);
      break;
    case 10:
      BodyParts.LeftThigh.SetVertices (Polygon, numvertices);
      break;
    case 11:
      BodyParts.RightThigh.SetVertices (Polygon, numvertices);
      break;
    case 12:
      BodyParts.LeftShin.SetVertices (Polygon, numvertices);
      break;
    case 13:
      BodyParts.RightShin.SetVertices (Polygon, numvertices);
      break;
    case 14:
      BodyParts.LeftFoot.SetVertices (Polygon, numvertices);
      break;
    case 15:
      BodyParts.RightFoot.SetVertices (Polygon, numvertices);
      break;
    case 16:
      BodyParts.Stick.SetVertices (Polygon, numvertices);
      break;
    }
}
*/

//#ifdef USEMFC
//void Model::
//Load (char *filename)
//{
//  CFile f (filename, CFile::modeRead | CFile::typeBinary);
//  CArchive mdlfile (&f, CArchive::load);
//  LoadACFile (mdlfile);
//}
//#else
void Model::
Load (char *filename)
{
  fstream mdlfile (filename, ios::in/* | ios::binary*/);
  if (!mdlfile.good ())
    {
      cerr << "Big problems loading the model...\n";
      cerr << "filename=" << filename << endl;
      exit (0);
    }
  //  cout<<"Loading the model..."<<endl;
  LoadACFile (mdlfile);
}
//#endif

/*
#ifdef USEMFC
void Model::
Load (CArchive & mdlfile)
// Creates the model by reading from a specially-formatted 
// file.
{
  double x, y, z;
  int m;
  mdlfile >> m;
  NumVertices = m;
  for (int i = 0; i < NumVertices; i++)
    {
      mdlfile >> x >> y >> z;
      Vertices[i][0] = x;
      Vertices[i][1] = y;
      Vertices[i][2] = z;
    }
// cout<<"Done reading vertices\n";
  int partnumber = 0;
  int numvertices2[6];
  int **polygon;
  polygon = new int *[20];
  for (int a = 0; a < 20; a++)
    polygon[a] = new int[6];
  for (partnumber = 0; partnumber < 17; partnumber++)
    {
      for (int j = 0; j < 6; j++)
	{
	  mdlfile >> m;
//                      if (partnumber==0&&j==0)
	  //                      cout<<"Number of Vertices for face "<<j<<" of part number "<<partnumber<<":  "<<(int)s<<endl;
	  numvertices2[j] = m;
	  for (int i = 0; i < numvertices2[j]; i++)
	    {
	      mdlfile >> m;
//                              if (partnumber==0&&j==0)
	      //                               cout<<"Something:  "<<s<<":  "<<Vertices[s][0]<<" "<<Vertices[s][1]<<" "<<Vertices[s][2]<<endl;
	      polygon[i][j] = m;
	    }
	}
//              cout<<"Setting vertices for "<<partnumber<<endl;
      SetVertices (partnumber, polygon, numvertices2);
      //partnumber++;
    }
  for (a = 0; a < 20; a++)
    delete[]polygon[a];
  delete[]polygon;

  // mdlfile.close();
}
#else
*/
/*
void Model::
Load (fstream & mdlfile)
// Creates the model by reading from a specially-formatted 
// file.
{
 //      mdlfile.setmode(ios::binary);
  double x, y, z;
  int m, temp;
  m = ReadInt (mdlfile);
//  char blah[80];
//  mdlfile.getline(blah,79);
//  cout<<"Blah="<<blah<<endl;
//  mdlfile>>m;
//  cout<<"m="<<m<<endl;
//  mdlfile>>temp>>temp;
  NumVertices = m;
//  cout<<"NumVertices="<<NumVertices<<endl;
  for (int i = 0; i < NumVertices; i++)
   {
      x = ReadDouble (mdlfile);
      y = ReadDouble (mdlfile);
      z = ReadDouble (mdlfile);
//      mdlfile>>x>>y>>z;
      Vertices[i][0] = x;
      Vertices[i][1] = y;
      Vertices[i][2] = z;
//      cout<<"Vertex "<<i<<"=("<<Vertices[i][0]<<", "<<Vertices[i][1]<<", "<<Vertices[i][2]<<")\n";
    }
// cout<<"Done reading vertices\n";
  int partnumber = 0;
  int numvertices2[6];
  int **polygon;
  int a;
  polygon = new int *[20];
  for (a = 0; a < 20; a++)
    polygon[a] = new int[6];
  for (partnumber = 0; partnumber < 17; partnumber++)
    {
//              double polygon[20][6][3];
      for (int j = 0; j < 6; j++)
	{
	  m = ReadInt (mdlfile);
	 // mdlfile>>m;
//                      if (partnumber==0&&j==0)
	  //	                        cout<<"Number of Vertices for face "<<j<<" of part number "<<partnumber<<":  "<<(int)s<<endl;
	  numvertices2[j] = m;
	  for (int i = 0; i < numvertices2[j]; i++)
	    {
	      m = ReadInt (mdlfile);
	  //    mdlfile>>m;
//                              if (partnumber==0&&j==0)
	      //	                                     cout<<"Something:  "<<s<<":  "<<Vertices[s][0]<<" "<<Vertices[s][1]<<" "<<Vertices[s][2]<<endl;
	      polygon[i][j] = m;
	    }
	}
            //  cout<<"Setting vertices for "<<partnumber<<endl;
      SetVertices (partnumber, polygon, numvertices2);
      //partnumber++;
    }
  
  for (a = 0; a < 20; a++)
    delete[]polygon[a];
  delete[]polygon;

  mdlfile.close ();
}
#endif
*/

void Model::LoadACFile(fstream & acfile)
{
 string token = "Snork!";
 int numbodyparts, partnumber;
 while (token != "world")
  acfile>>token;
 acfile>>token; //absorb "kids"
 acfile>>numbodyparts;
 for (int x = 0; x < numbodyparts; x++)
 {
  acfile>>token;
  if (token != "OBJECT")
   cout<<"I'm lost..."<<endl;
  acfile>>token;  // poly
  acfile>>token;  // name
  acfile>>token;
  LoadPart(acfile, token);  
 }  
 // cout<<"Done loading the model!"<<endl;
}

void Model::LoadPart(fstream &acfile, string partname)
{
 partname.erase(0,1);
 partname.erase(partname.length()-1,partname.length());
 // cout<<"string is "<<partname<<endl;
 if (partname == "head")
  BodyParts.Head.Load(acfile);
 else if (partname == "neck") 
  BodyParts.Neck.Load(acfile);
 else if (partname == "torso")
  BodyParts.Torso.Load(acfile);
 else if (partname == "leftupperarm")
  BodyParts.LeftUpperArm.Load(acfile);
 else if (partname == "rightupperarm")
  BodyParts.RightUpperArm.Load(acfile);
 else if (partname == "leftlowerarm") 
  BodyParts.LeftLowerArm.Load(acfile);
 else if (partname == "rightlowerarm") 
  BodyParts.RightLowerArm.Load(acfile);
 else if (partname == "lefthand") 
  BodyParts.LeftHand.Load(acfile);
 else if (partname == "righthand")
  BodyParts.RightHand.Load(acfile);
 else if (partname == "hip")
  BodyParts.Hip.Load(acfile);
 else if (partname == "leftthigh")
  BodyParts.LeftThigh.Load(acfile);
 else if (partname == "rightthigh")
  BodyParts.RightThigh.Load(acfile);
 else if (partname == "leftshin")
  BodyParts.LeftShin.Load(acfile);
 else if (partname == "rightshin")
  BodyParts.RightShin.Load(acfile);
 else if (partname == "leftfoot")
  BodyParts.LeftFoot.Load(acfile);
 else if (partname == "rightfoot")
 {
   //   cout<<"I'm not as dumb as I look"<<endl;  
  BodyParts.RightFoot.Load(acfile);
 }
 else if (strcmp(partname.c_str(), "stick") == 0)
  BodyParts.Stick.Load(acfile);
} 

void Model::
SetScale (double scale)
{
  // Sets the scale of the model (height, width, and depth)
  // and creates display lists for each body part
  Scale = scale;
/*      for (int x=0;x<NumVertices;x++)
   if (Vertices[x][0]!=999&&Vertices[x][1]!=999&&Vertices[x][2]!=999)
   {
   Vertices[x][0]*=scale;
   Vertices[x][1]*=scale;
   Vertices[x][2]*=scale;
   }
 */
  //  cout<<"Setting extreme z's...pretty dangerous, if you ask me."<<endl;
  BodyParts.SetExtremeZs (/*Vertices, */Scale);
  //  cout<<"Got through it, though."<<endl;
  GLuint start = glGenLists (17);
  //  cout<<"Generating display lists..."<<endl;
  BodyParts.Head.CreateDisplayList (start, /*Vertices,*/ Scale);
  BodyParts.Hip.CreateDisplayList (start + 1, /*Vertices,*/ Scale);
  BodyParts.LeftFoot.CreateDisplayList (start + 2, /*Vertices,*/ Scale);
  BodyParts.LeftHand.CreateDisplayList (start + 3, /*Vertices,*/ Scale);
  BodyParts.LeftLowerArm.CreateDisplayList (start + 4, /*Vertices,*/ Scale);
  BodyParts.LeftShin.CreateDisplayList (start + 5, /*Vertices,*/ Scale);
  BodyParts.LeftThigh.CreateDisplayList (start + 6, /*Vertices,*/ Scale);
  BodyParts.LeftUpperArm.CreateDisplayList (start + 7, /*Vertices,*/ Scale);
  BodyParts.Neck.CreateDisplayList (start + 8, /*Vertices,*/ Scale);
  BodyParts.RightFoot.CreateDisplayList (start + 9, /*Vertices,*/ Scale);
  BodyParts.RightHand.CreateDisplayList (start + 10, /*Vertices,*/ Scale);
  BodyParts.RightLowerArm.CreateDisplayList (start + 11, /*Vertices,*/ Scale);
  BodyParts.RightShin.CreateDisplayList (start + 12, /*Vertices,*/ Scale);
  BodyParts.RightThigh.CreateDisplayList (start + 13, /*Vertices,*/ Scale);
  BodyParts.RightUpperArm.CreateDisplayList (start + 14, /*Vertices,*/ Scale);
  BodyParts.Torso.CreateDisplayList (start + 15, /*Vertices,*/ Scale);
  BodyParts.Stick.CreateDisplayList (start + 16, /*Vertices,*/ Scale);
  //  cout<<"Done with display lists...everything should be cool now"<<endl;
}

/*#ifdef USEMFC
void Model::
Save (CArchive & out)		//char *filename)
 {
  //fstream out(filename,ios::out);
  out << NumVertices;		//<<endl;

  for (int x = 0; x < NumVertices; x++)
    {
      for (int i = 0; i < 3; i++)
	out << Vertices[x][i];	//<<" ";
      //              out<<endl;

    }
  BodyParts.Head.Save (out);
  BodyParts.Neck.Save (out);
  BodyParts.Torso.Save (out);
  BodyParts.LeftUpperArm.Save (out);
  BodyParts.RightUpperArm.Save (out);
  BodyParts.LeftLowerArm.Save (out);
  BodyParts.RightLowerArm.Save (out);
  BodyParts.LeftHand.Save (out);
  BodyParts.RightHand.Save (out);
  BodyParts.Hip.Save (out);
  BodyParts.LeftThigh.Save (out);
  BodyParts.RightThigh.Save (out);
  BodyParts.LeftShin.Save (out);
  BodyParts.RightShin.Save (out);
  BodyParts.LeftFoot.Save (out);
  BodyParts.RightFoot.Save (out);
  BodyParts.Stick.Save (out);

//      out.close();
}
#else
/*
void Model::
Save (fstream & out)		//char *filename)
 {
  //fstream out(filename,ios::out);
  out << NumVertices;		//<<endl;

  for (int x = 0; x < NumVertices; x++)
    {
      for (int i = 0; i < 3; i++)
	out << Vertices[x][i];	//<<" ";
      //              out<<endl;

    }
  BodyParts.Head.Save (out);
  BodyParts.Neck.Save (out);
  BodyParts.Torso.Save (out);
  BodyParts.LeftUpperArm.Save (out);
  BodyParts.RightUpperArm.Save (out);
  BodyParts.LeftLowerArm.Save (out);
  BodyParts.RightLowerArm.Save (out);
  BodyParts.LeftHand.Save (out);
  BodyParts.RightHand.Save (out);
  BodyParts.Hip.Save (out);
  BodyParts.LeftThigh.Save (out);
  BodyParts.RightThigh.Save (out);
  BodyParts.LeftShin.Save (out);
  BodyParts.RightShin.Save (out);
  BodyParts.LeftFoot.Save (out);
  BodyParts.RightFoot.Save (out);
  BodyParts.Stick.Save (out);

//      out.close();
}

#endif
*/

/*#ifdef USEMFC
void Model::
Draw2d (CDC & MemoryDC, int ZoomFactor, int XOffset, int YOffset, int Dimension1, int Dimension2, int SelectedVertices[2], int NumVerticesSelected)
{
  for (int x = 0; x < NumVertices; x++)
    {
      //CBrush br(RGB(10*(Vertices[x][0]+50), 10*(Vertices[x][1]+20), 3*Vertices[x][2]));
      CBrush br (RGB (0, 200 * ((NumVerticesSelected > 0 && SelectedVertices[0] == x) ||
		     (NumVerticesSelected > 1 && SelectedVertices[1] == x)),
	     200 * ((NumVerticesSelected > 0 && SelectedVertices[0] == x) ||
		    (NumVerticesSelected > 1 && SelectedVertices[1] == x))));
//              CBrush br(RGB(200*NumVerticesSelected,0,0));
      CBrush *old = MemoryDC.SelectObject (&br);
      CRect b;
      b.top = YOffset - (ZoomFactor * (Vertices[x][Dimension2]) + 3);
      b.bottom = YOffset - (ZoomFactor * (Vertices[x][Dimension2]) - 3);
      b.left = ZoomFactor * (Vertices[x][Dimension1]) - 3 + XOffset;
      b.right = ZoomFactor * (Vertices[x][Dimension1]) + 3 + XOffset;
      MemoryDC.Ellipse (b);
      MemoryDC.SelectObject (old);
    }
  BodyParts.Head.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.Hip.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.LeftFoot.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.LeftHand.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.LeftLowerArm.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.LeftShin.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.LeftThigh.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.LeftUpperArm.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.Neck.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.RightFoot.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.RightHand.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.RightLowerArm.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.RightShin.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.RightThigh.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.RightUpperArm.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.Stick.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
  BodyParts.Torso.Draw2d (MemoryDC, ZoomFactor, XOffset, YOffset, Dimension1, Dimension2, Vertices);
}
#endif
*/
void Model::
Display (Skeleton s, double red, double green, double blue)
{
  // Displays the model using the specified skeleton for
  // joint angles.


  // weirdness...reversed.  Oh well...
  BodyParts.Head.Angles = s.Joints.Head;
  BodyParts.Neck.Angles = s.Joints.Neck;
  BodyParts.Torso.Angles = s.Joints.Torso;
  BodyParts.LeftUpperArm.Angles = s.Joints.RightUpperArm;
  BodyParts.LeftLowerArm.Angles = s.Joints.RightLowerArm;
  BodyParts.LeftHand.Angles = s.Joints.LeftHand;
  BodyParts.RightUpperArm.Angles = s.Joints.LeftUpperArm;
  BodyParts.RightLowerArm.Angles = s.Joints.LeftLowerArm;
  BodyParts.RightHand.Angles = s.Joints.RightHand;
  BodyParts.Hip.Angles = s.Joints.Hip;
  BodyParts.LeftThigh.Angles = s.Joints.RightThigh;
  BodyParts.LeftShin.Angles = s.Joints.RightShin;
  BodyParts.LeftFoot.Angles = s.Joints.RightFoot;
  BodyParts.RightThigh.Angles = s.Joints.LeftThigh;
  BodyParts.RightShin.Angles = s.Joints.LeftShin;
  BodyParts.RightFoot.Angles = s.Joints.LeftFoot;
  BodyParts.Stick.Angles = s.Joints.Stick;

  BodyParts.Hip.Display ();
}

void Model::
Draw (Skeleton s, int DrawMode)
{
  // Displays the model using the specified skeleton for
  // joint angles.

  BodyParts.Head.Angles = s.Joints.Head;
  BodyParts.Neck.Angles = s.Joints.Neck;
  BodyParts.Torso.Angles = s.Joints.Torso;
  BodyParts.LeftUpperArm.Angles = s.Joints.LeftUpperArm;
  BodyParts.LeftLowerArm.Angles = s.Joints.LeftLowerArm;
  BodyParts.LeftHand.Angles = s.Joints.LeftHand;
  BodyParts.RightUpperArm.Angles = s.Joints.RightUpperArm;
  BodyParts.RightLowerArm.Angles = s.Joints.RightLowerArm;
  BodyParts.RightHand.Angles = s.Joints.RightHand;
  BodyParts.Hip.Angles = s.Joints.Hip;
  BodyParts.LeftThigh.Angles = s.Joints.LeftThigh;
  BodyParts.LeftShin.Angles = s.Joints.LeftShin;
  BodyParts.LeftFoot.Angles = s.Joints.LeftFoot;
  BodyParts.RightThigh.Angles = s.Joints.RightThigh;
  BodyParts.RightShin.Angles = s.Joints.RightShin;
  BodyParts.RightFoot.Angles = s.Joints.RightFoot;
  BodyParts.Stick.Angles = s.Joints.Stick;

  BodyParts.Hip.Draw (/*Vertices,*/ DrawMode);
}


/*
   void Model::Display(Skeleton s, double red, double green, double blue)
   {
   Box(-7,-7,7,7,15,0);
   //   glBegin(GL_LINE_STRIP);
   //    glVertex3f(s.LeftFoot.X,s.LeftFoot.Y,s.LeftFoot.Z);
   //           glVertex3f(s.LeftKnee.X,s.LeftKnee.Y,s.LeftKnee.Z);
   //           glVertex3f(0,0,s.Hip.Z);
   //           glVertex3f(s.RightKnee.X,s.RightKnee.X,s.RightKnee.Z);
   //           glVertex3f(s.RightFoot.X,s.RightFoot.Y,s.RightFoot.Z);
   glEnd();
   }
 */

/*
void Model::
AddVertex (int Vertex1, int Vertex2)
{
  Vertices[NumVertices][0] = (Vertices[Vertex1][0] + Vertices[Vertex2][0]) / 2;
  Vertices[NumVertices][1] = (Vertices[Vertex1][1] + Vertices[Vertex2][1]) / 2;
  Vertices[NumVertices][2] = (Vertices[Vertex1][2] + Vertices[Vertex2][2]) / 2;
  BodyParts.Head.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.Hip.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.LeftFoot.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.LeftHand.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.LeftLowerArm.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.LeftShin.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.LeftThigh.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.LeftUpperArm.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.Neck.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.RightFoot.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.RightHand.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.RightLowerArm.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.RightShin.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.RightThigh.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.RightUpperArm.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.Stick.AddVertex (Vertex1, Vertex2, NumVertices);
  BodyParts.Torso.AddVertex (Vertex1, Vertex2, NumVertices);
  NumVertices++;
}
*/
