// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#ifndef _____MODELH_
#define _____MODELH_


#ifdef USEMFC
#include "stdafx.h"
#endif
#include "Constants.h"
#include "Body.h"
#include "BodyPart.h"
#include "Skeleton.h"
#include <string>

const int HEAD = 0;
const int NECK = 1;
const int TORSO = 2;
const int LEFTUPPERARM = 3;
const int RIGHTUPPERARM = 4;
const int LEFTLOWERARM = 5;
const int RIGHTLOWERARM = 6;
const int LEFTHAND = 7;
const int RIGHTHAND = 8;
const int HIP = 9;
const int LEFTTHIGH = 10;
const int RIGHTTHIGH = 11;
const int LEFTSHIN = 12;
const int RIGHTSHIN = 13;
const int LEFTFOOT = 14;
const int RIGHTFOOT = 15;
const int MAXZ = 0;
const int MINZ = 1;
const int STARTINDEX = 2;
const int ENDINDEX = 3;

class Model
{
  public:
  Model ();
  ~Model ();
  Model (char *filename);
//#ifdef USEMFC
//    Model (CArchive & mdlfile /*char *filename */ );
//#else
    Model (fstream & mdlfile);
//#endif
    Model (Model * m);
  void SetScale (double scale);
//#ifdef USEMFC
//  void Load (CArchive & mdlfile /*char *filename */ );
//#else
  void Load (fstream & mdlfile);
//#endif				/* USEMFC */
  void Load (char *filename);
  void LoadACFile (fstream & acfile);
//#ifdef USEMFC
//  void Save (CArchive & out);	//char *filename);
//#else
  //  void Save (fstream & mdlfile);
//#endif
  //  void AddVertex (int Vertex1, int Vertex2);
  void Display (Skeleton s, double red, double green, double blue);
  void Draw (Skeleton s, int DrawMode);
  void LoadPart(fstream &acfile, string partname);
//#ifdef USEMFC
//  void Draw2d (CDC & MemoryDC, int ZoomFactor, int XOffset, int YOffset, int Dimension1, int Dimension2, int SelectedVertices[2], int NumVerticesSelected);
//#endif
  Body BodyParts;
  //  double **Vertices;
//      double Vertices[300][3];
  //  int NumVertices;
    private:
  double Scale;
  //double SignificantPoints[16][4];o
  int currentpartstart;
  int currentpartend;
  double Red, Green, Blue;
  double ORed, OGreen, OBlue;
  double highz, lowz;
  Point topwarppoint;
  Point bottomwarppoint;
  double topwarpz;
  int SetPartStarts (char *part);
  void SetPartEnds (char *part);
  double HighZ (int start, int end);
  double LowZ (int start, int end);
  void FillCurrentPartData (int index);
  void ConnectParts ();
  void SetVertices (int PartNumber, int **Polygon, int numvertices[6]);
};

#endif
