// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#include <iostream>
#include <fstream>
#define GLUT
#include <GL/glut.h>
#include "Model.h"
#include <stdio.h>
#include <sys/timeb.h>

using namespace std;

Skeleton s;
Model m;
double Theta[3];
Point Hip;
int Shooting;
fstream animfile;

void Init()
{
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	int base=glGenLists(128);
	for (int i=0;i<128;i++)
	{
		glNewList(base+i,GL_COMPILE);
		glutBitmapCharacter(GLUT_BITMAP_9_BY_15,i);
		glEndList();
	}
	glListBase(base);
}


void Display()
{
 double maxdistance=s.GetMaxDistance(&m.BodyParts);
 double x=maxdistance;	//s.DoPhysics(&m.BodyParts);
		
 glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glLoadIdentity();
	char buf[20];
	sprintf(buf,"x=%f",x);
	glRasterPos2i(40,0);
// glCallLists(strlen(buf),GL_BYTE,buf);
	glFlush();
	glPopAttrib();
	glTranslatef(0,-15,-30-maxdistance);
	glRotatef(Theta[0],1.0,0.0,0.0);
	glRotatef(Theta[1],0.0,1.0,0.0);
	glRotatef(Theta[2],0.0,0.0,1.0);
 m.Display(s,1,0,0);
/*	glBegin(GL_LINES);
		glVertex3f(-1,-1,0);
	 glVertex3f(-1,1,0);
 glEnd();
	*/
	glFlush();
	glutSwapBuffers();
}

void Mouse(int btn, int state, int x, int y)
{
 if (btn==GLUT_RIGHT_BUTTON&&state==GLUT_DOWN)
	{
		Theta[0]++;
	}
	Display();
}


void Idle(/*int blah*/)
{
        s.Animate(Hip, &m.BodyParts,Shooting);
	Hip.Move();
	s.Move();
	Display();

	if (Shooting>0)
		Shooting--;
}
 

void Keyboard(unsigned char key, int x, int y)
{ 
	switch (key)
	{
	case 'q': s.Joints.LeftThigh.X+=5; break;
	case 'a': s.Joints.LeftThigh.X-=5; break;
	case 'w': s.Joints.LeftShin.X+=5; break;
	case 's': s.Joints.LeftShin.X-=5; break;
	case 'e': s.Joints.RightThigh.X+=5; break;
	case 'd': s.Joints.RightThigh.X-=5; break;
	case 'r': s.Joints.RightShin.X+=5; break;
	case 'f': s.Joints.RightShin.X-=5; break;

	case 'u': s.Joints.LeftUpperArm.X+=5; break;
	case 'j': s.Joints.LeftUpperArm.X-=5; break;
	case 'i': s.Joints.LeftLowerArm.X+=5; break;
	case 'k': s.Joints.LeftLowerArm.X-=5; break;
	case 'o': s.Joints.RightUpperArm.X+=5; break;
	case 'l': s.Joints.RightUpperArm.X-=5; break;
	case 'p': s.Joints.RightLowerArm.X+=5; break;
	case ';': s.Joints.RightLowerArm.X-=5; break;

	case 'n': s.Joints.LeftUpperArm.Y+=5; break;
	case 'm': s.Joints.LeftUpperArm.Y-=5; break;
	case ',': s.Joints.RightUpperArm.Y+=5; break;
	case '.': s.Joints.RightUpperArm.Y-=5; break;

	case 'z': s.Joints.LeftThigh.Y+=5; break;
	case 'x': s.Joints.LeftThigh.Y-=5; break;
	case 'c': s.Joints.RightThigh.Y+=5; break;
	case 'v': s.Joints.RightThigh.Y-=5; break;

	case 'U': s.Joints.LeftUpperArm.Y+=5; break;
	case 'J': s.Joints.LeftUpperArm.Y-=5; break;
	case 'I': s.Joints.LeftLowerArm.Y+=5; break;
	case 'K': s.Joints.LeftLowerArm.Y-=5; break;
	case 'O': s.Joints.RightUpperArm.Y+=5; break;
	case 'L': s.Joints.RightUpperArm.Y-=5; break;
	case 'P': s.Joints.RightLowerArm.Y+=5; break;
	case ':': s.Joints.RightLowerArm.Y-=5; break;

	case 't': s.Joints.Hip.X+=5; break;
	case 'g': s.Joints.Hip.X-=5; break;
	case 'T': s.Joints.Hip.Z+=5; break;
	case 'G': s.Joints.Hip.Z-=5; break;

	case '[': s.Joints.RightHand.X+=5; break;
	case ']': s.Joints.RightHand.X-=5; break;
	case '{': s.Joints.RightHand.Z+=5; break;
	case '}': s.Joints.RightHand.Z-=5; break;


	case 'y': s.Joints.Hip.Y+=5; break;
	case 'h': s.Joints.Hip.Y-=5; break;

	case 'Q': s.Joints.Torso.X+=5; break;
	case 'A': s.Joints.Torso.X-=5; break;
	case 'W': s.Joints.Torso.Z+=5; break;
        case 'S': s.Joints.Torso.Z-=5; break;

	case '8': Theta[2]+=5; break;
	case '2': Theta[2]-=5; break;
	case '6': Theta[1]+=5; break;
	case '4': Theta[1]-=5; break;	
 
	case '`': Shooting=12;
	case 13: if (animfile.good())
            	  animfile<<s; break;

 case ' ': 
		if (Hip.XVelocity==0)
		{
			Hip.XVelocity=2; 
       			glutIdleFunc(Idle);
			//glutTimerFunc(25,Idle,1);
		}
		else
		{
			Hip.XVelocity=0; 
			//glutIdleFunc(NULL);
		}
		break;
//	case '!':
//			fstream debug("debug.txt",ios::app);
			//double a=s.LeftLegDistanceFromGround(&m.BodyParts);
			//double b=s.RightLegDistanceFromGround(&m.BodyParts);
//			debug<<"Left Leg:  "<<a<< 
//				      "   Right Leg:  "<<b<<endl;
//			debug.close();
//  break;

	}
	s.EnforceRigidity();
	Display();
}

void Reshape(int w, int h) 
{
 glViewport(0,0,w,h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0,1,50,-50);
	gluLookAt(75,75,0,0,0,0,0,0,1);
	glMatrixMode(GL_MODELVIEW);
}

void main(int argc, char **argv)
{
	glutInit(&argc,argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(400,400);
	glutCreateWindow("Model Viewer");
	Init();
	if (argc > 1)
         animfile.open(argv[1], ios::out);
	glutReshapeFunc(Reshape);
	glutDisplayFunc(Display);
	//glutIdleFunc(Display);
	//	glutTimerFunc(500,Display,1);
	glClearColor(1,1,1,0);
	glutMouseFunc(Mouse);
	glutKeyboardFunc(Keyboard);
	glEnable(GL_DEPTH_TEST);
	m.Load("skater.ac");
	m.SetScale(5);
	glColor3f(0,0,0);
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);
	glutMainLoop();

}
