// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#include <stdlib.h>
#include "TeamEmployee.h"
#include "PlayerAttributes.h"

PlayerAttributes::PlayerAttributes ()
{
  UniformNumber = 0;
  CaptainStatus = 0;
  HallOfFamePoints = 0;
  Age = 0;
  Height = 0;
  Weight = 0;
  YearsInContract = 0;
  JuniorLeagueID = 0;
  DraftPickNumber = 0;

  Position = 0;

  Intelligence = 0;
  Attitude = 0;
  Ego = 0;
  Discipline = 0;
  Aggressiveness = 0;
  SkatingSpeed = 0;
  Quickness = 0;
  StickHandling = 0;
  Passing = 0;
  PuckControl = 0;
  Stamina = 0;
  Durability = 0;
  FightingAbility = 0;
  InjuryType = 0;
  InjuryLength = 0;
  InjuryVulnerability = 0;
  ShotPower = 0;
  ShotAccuracy = 0;
}

/*ostream& operator<<(ostream &o, PlayerAttributes x)
   {
   o<<x.UniformNumber<<"\n";
   o<<x.CaptainStatus<<"\n";
   o<<x.HallOfFamePoints<<"\n";
   o<<x.Age<<"\n";
   o<<x.Height<<"\n";
   o<<x.Weight<<"\n";
   o<<x.YearsInContract<<"\n";
   o<<x.JuniorLeagueID<<"\n";
   o<<x.DraftPickNumber<<"\n";

   o<<x.Position<<"\n";

   o<<x.Intelligence<<"\n";
   o<<x.Attitude<<"\n";
   o<<x.Ego<<"\n";
   o<<x.Discipline<<"\n";
   o<<x.Aggressiveness<<"\n";
   o<<x.SkatingSpeed<<"\n";
   o<<x.Quickness<<"\n";
   o<<x.StickHandling<<"\n";
   o<<x.Passing<<"\n";
   o<<x.PuckControl<<"\n";
   o<<x.Stamina<<"\n";
   o<<x.Durability<<"\n";
   o<<x.FightingAbility<<"\n";
   o<<x.InjuryType<<"\n";
   o<<x.InjuryLength<<"\n";
   o<<x.InjuryVulnerability<<"\n";
   o<<x.ShotPower<<"\n";
   o<<x.ShotAccuracy<<"\n";

   return o;
   }

   fstream& operator>>(fstream &i, PlayerAttributes&x)
   {
   char temp[20];
   i.getline(temp,20);;
   x.UniformNumber=atoi(temp);
   i.getline(temp,20);;
   x.CaptainStatus=atoi(temp);
   i.getline(temp,20);;
   x.HallOfFamePoints=atoi(temp);
   i.getline(temp,20);;
   x.Age=atoi(temp);
   i.getline(temp,20);;
   x.Height=atoi(temp);
   i.getline(temp,20);;
   x.Weight=atoi(temp);
   i.getline(temp,20);;
   x.YearsInContract=atoi(temp);
   i.getline(temp,20);;
   x.JuniorLeagueID=atoi(temp);
   i.getline(temp,20);;
   x.DraftPickNumber=atoi(temp);

   i.getline(temp,20);;
   x.Position=atoi(temp);

   i.getline(temp,20);;
   x.Intelligence=atoi(temp);
   i.getline(temp,20);;
   x.Attitude=atoi(temp);
   i.getline(temp,20);;
   x.Ego=atoi(temp);
   i.getline(temp,20);;
   x.Discipline=atoi(temp);
   i.getline(temp,20);;
   x.Aggressiveness=atoi(temp);
   i.getline(temp,20);;
   x.SkatingSpeed=atoi(temp);
   i.getline(temp,20);;
   x.Quickness=atoi(temp);
   i.getline(temp,20);;
   x.StickHandling=atoi(temp);
   i.getline(temp,20);;
   x.Passing=atoi(temp);
   i.getline(temp,20);;
   x.PuckControl=atoi(temp);
   i.getline(temp,20);;
   x.Stamina=atoi(temp);
   i.getline(temp,20);;
   x.Durability=atoi(temp);
   i.getline(temp,20);;
   x.FightingAbility=atoi(temp);
   i.getline(temp,20);;
   x.InjuryType=atoi(temp);
   i.getline(temp,20);;
   x.InjuryLength=atoi(temp);
   i.getline(temp,20);;
   x.InjuryVulnerability=atoi(temp);
   i.getline(temp,20);
   x.ShotPower=atoi(temp);
   i.getline(temp,20);
   x.ShotAccuracy=atoi(temp);

   return i;
   }
 */

PlayerAttributes::PlayerAttributes(const PlayerAttributes & temp)
{
  UniformNumber = temp.UniformNumber;
  CaptainStatus = temp.CaptainStatus;
  HallOfFamePoints = temp.HallOfFamePoints;

  ID = temp.ID;
  Age = temp.Age;
  YearsExperience = temp.YearsExperience;
  Height = temp.Height;
  Weight = temp.Weight;
  YearsInContract = temp.YearsInContract;
  JuniorLeagueID = temp.JuniorLeagueID;
  DraftPickNumber = temp.DraftPickNumber;

  Position = temp.Position;
  Dressed = temp.Dressed;
  Intelligence = temp.Intelligence;
  Attitude = temp.Attitude;
  Ego = temp.Ego;
  Discipline = temp.Discipline;
  Aggressiveness = temp.Aggressiveness;
  SkatingSpeed = temp.SkatingSpeed;
  Quickness = temp.Quickness;
  StickHandling = temp.StickHandling;
  Passing = temp.Passing;
  PuckControl = temp.PuckControl;
  Stamina = temp.Stamina;
  Durability = temp.Durability;
  FightingAbility = temp.FightingAbility;
  InjuryType = temp.InjuryType;
  InjuryLength = temp.InjuryLength;
  InjuryVulnerability = temp.InjuryVulnerability;
  ShotPower = temp.ShotPower;
  ShotAccuracy = temp.ShotAccuracy;
} 

void PlayerAttributes::
Duplicate (PlayerAttributes & temp)
{
  temp.UniformNumber = UniformNumber;
  temp.CaptainStatus = CaptainStatus;
  temp.HallOfFamePoints = HallOfFamePoints;

  temp.Age = Age;
  temp.YearsExperience = YearsExperience;
  temp.Height = Height;
  temp.Weight = Weight;
  temp.YearsInContract = YearsInContract;
  temp.JuniorLeagueID = JuniorLeagueID;
  temp.DraftPickNumber = DraftPickNumber;

  temp.Position = Position;
  temp.Dressed = Dressed;
  temp.Intelligence = Intelligence;
  temp.Attitude = Attitude;
  temp.Ego = Ego;
  temp.Discipline = Discipline;
  temp.Aggressiveness = Aggressiveness;
  temp.SkatingSpeed = SkatingSpeed;
  temp.Quickness = Quickness;
  temp.StickHandling = StickHandling;
  temp.Passing = Passing;
  temp.PuckControl = PuckControl;
  temp.Stamina = Stamina;
  temp.Durability = Durability;
  temp.FightingAbility = FightingAbility;
  temp.InjuryType = InjuryType;
  temp.InjuryLength = InjuryLength;
  temp.InjuryVulnerability = InjuryVulnerability;
  temp.ShotPower = ShotPower;
  temp.ShotAccuracy = ShotAccuracy;
}

PlayerAttributes &PlayerAttributes::operator=(const PlayerAttributes &temp)
{
  UniformNumber = temp.UniformNumber;
  CaptainStatus = temp.CaptainStatus;
  HallOfFamePoints = temp.HallOfFamePoints;

  ID = temp.ID;
  Age = temp.Age;
  YearsExperience = temp.YearsExperience;
  Height = temp.Height;
  Weight = temp.Weight;
  YearsInContract = temp.YearsInContract;
  JuniorLeagueID = temp.JuniorLeagueID;
  DraftPickNumber = temp.DraftPickNumber;

  Position = temp.Position;
  Dressed = temp.Dressed;
  Intelligence = temp.Intelligence;
  Attitude = temp.Attitude;
  Ego = temp.Ego;
  Discipline = temp.Discipline;
  Aggressiveness = temp.Aggressiveness;
  SkatingSpeed = temp.SkatingSpeed;
  Quickness = temp.Quickness;
  StickHandling = temp.StickHandling;
  Passing = temp.Passing;
  PuckControl = temp.PuckControl;
  Stamina = temp.Stamina;
  Durability = temp.Durability;
  FightingAbility = temp.FightingAbility;
  InjuryType = temp.InjuryType;
  InjuryLength = temp.InjuryLength;
  InjuryVulnerability = temp.InjuryVulnerability;
  ShotPower = temp.ShotPower;
  ShotAccuracy = temp.ShotAccuracy;
  return *this;
}
void PlayerAttributes::
Generate ( /*int position */ )
{
// Position=position;
  // UniformNumber=0;
  CaptainStatus = 0;
  HallOfFamePoints = 75;
  Age = 20;
  Height = rand () % 8 + 72 - rand () % 8;
  Weight = rand () % 50 + 175;
  YearsInContract = 4;
  JuniorLeagueID = 1;
  DraftPickNumber = 1;


  Intelligence = rand () % 25 + 75;
  Attitude = rand () % 25 + 75;
  Ego = rand () % 25 + 75;
  Discipline = rand () % 25 + 75;
  Aggressiveness = rand () % 25 + 75;
  SkatingSpeed = rand () % 20 + 80;
  Quickness = rand () % 25 + 75;
  StickHandling = rand () % 25 + 75;
  Passing = rand () % 25 + 75;
  PuckControl = rand () % 25 + 75;
  Stamina = rand () % 25 + 75;
  Durability = rand () % 25 + 75;
  FightingAbility = rand () % 25 + 75;
  InjuryType = rand () % 25 + 75;
  InjuryLength = rand () % 25 + 75;
  InjuryVulnerability = rand () % 25 + 75;
  ShotPower = rand () % 25 + 75;
  ShotAccuracy = rand () % 25 + 75;

}

void PlayerAttributes::Load(PLAYER_TYPE attr)
{
    ID=attr.ID;
    UniformNumber=attr.UniformNumber;
    Position=attr.Position;
    CaptainStatus = attr.CaptainStatus;
    HallOfFamePoints = attr.HallOfFamePoints;
    Age = attr.Age;
    Height = attr.Height;
    Weight = attr.Weight;
    YearsInContract = attr.YearsInContract;
    JuniorLeagueID = attr.JuniorLeagueID;
    DraftPickNumber = attr.DraftPickNumber;
    Intelligence = attr.DraftPickNumber;
    Attitude = attr.Attitude;
    Ego = attr.Ego;
    Discipline = attr.Discipline;
    Aggressiveness = attr.Aggressiveness;
    SkatingSpeed = attr.SkatingSpeed;
    Quickness = attr.Quickness;
    StickHandling = attr.StickHandling;
    Passing = attr.Passing;
    PuckControl = attr.PuckControl;
    Stamina = attr.Stamina;
    Durability = attr.Durability;
    FightingAbility = attr.FightingAbility;
    InjuryType = attr.InjuryType;
    InjuryLength = attr.InjuryLength;
    InjuryVulnerability = attr.InjuryVulnerability;
    ShotPower = attr.ShotPower;
    ShotAccuracy = attr.ShotAccuracy;
}
    


int PlayerAttributes::SpeedFactor()
{ 
  //  cout<<"Returning "<<(2 * SkatingSpeed) + (2 * Quickness) + Passing + StickHandling<<endl;
  return (2 * SkatingSpeed) + (2 * Quickness) + Passing + StickHandling;
}

int PlayerAttributes::PowerFactor()
{
 return Weight + SkatingSpeed;
}

