// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#include "Constants.h"

#ifndef PA
#define PA
class PlayerAttributes 
{
  
  //friend ostream& operator<<(ostream &o, PlayerAttributes x);
  //friend fstream& operator>>(fstream &i, PlayerAttributes&x);
public:
    PlayerAttributes ();
    PlayerAttributes(const PlayerAttributes &temp);
	virtual PlayerAttributes &operator=(const PlayerAttributes &temp);
    void Duplicate (PlayerAttributes & temp);
  
    void Generate ( /*int position */ );
    
    void Load(PLAYER_TYPE attr);
	int SpeedFactor();
	int PowerFactor();
  
// protected:
    int ID;

    int UniformNumber;
  
    int CaptainStatus;
  
    int HallOfFamePoints;
  
    
    int Age;
  
    int YearsExperience;
  
    int Height;
  
    int Weight;
  
    int YearsInContract;
  
    int JuniorLeagueID;
  
    int DraftPickNumber;
  
    
    int Position;
  
    int Dressed;
  
    
    int Intelligence;
  
    int Attitude;
  
    int Ego;
  
    int Discipline;
  
    int Aggressiveness;
  
    int SkatingSpeed;
  
    int Quickness;
  
    int StickHandling;
  
    int Passing;
  
    int PuckControl;
  
    int Stamina;
  
    int Durability;
  
    int FightingAbility;
  
    int InjuryType;
  
    int InjuryLength;
  
    int InjuryVulnerability;
  
    int ShotPower;
  
    int ShotAccuracy;
      
};

#endif /* */
