// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#include "Constants.h"
#include "Point.h"
#include <math.h>
#include "Utils.h"
#include <fstream>
using namespace std;

Point::Point ()
{
  X = 0;
  Y = 0;
  Z = 0;
  XVelocity = 0;
  YVelocity = 0;
  ZVelocity = 0;
}

Point::Point (const Point & rhs)
{
  X = rhs.X;
  Y = rhs.Y;
  Z = rhs.Z;
  XVelocity = rhs.XVelocity;
  YVelocity = rhs.YVelocity;
  ZVelocity = rhs.ZVelocity;
}

const Point & Point::operator = (const Point & rhs)
{
  X = rhs.X;
  Y = rhs.Y;
  Z = rhs.Z;
  XVelocity = rhs.XVelocity;
  YVelocity = rhs.YVelocity;
  ZVelocity = rhs.ZVelocity;
  return *this;
}

bool Point::operator==(Point &rhs)
{
 return (abs(X - rhs.X)<1 &&
         abs(Y - rhs.Y)<1 &&
         abs(Z - rhs.Z)<1);
}

Point::Point (double x, double y, double z)
  {
  X = x;
  Y = y;
  Z = z;
  XVelocity = 0;
  YVelocity = 0;
  ZVelocity = 0;
  }

ostream &operator<<(ostream &o, Point &p)
{
  o<<p.X<<" "<<p.Y<<" "<<p.Z<<" "<<endl;
  return o;
}

istream &operator>>(istream &i, Point &p)
{
  i>>p.X>>p.Y>>p.Z;
  return i;
}

void Point::MoveTowardsUnlimited(Point &p)
{
 Point temp = p;
 // temp.X += 180;
 // temp.Y += 180;
 // temp.Z += 180;
 double x = temp.X - X;
 double y = temp.Y - Y;
 double z = temp.Z - Z;
 // if (x > 180)
 //  x -= 360;
 // if (y > 180)
 //  y -= 360;
 // if (z > 180)
 //  z -= 360;

 XVelocity = x / 3;
 YVelocity = y / 3;
 ZVelocity = z / 3;
 // cout<<"Moving from "<<*this<<" towards "<<p<<" by going "<<XVelocity<<", "<<YVelocity<<", "<<ZVelocity<<endl;
}

void Point::SetComponents (double xrel, double yrel, double totalspeed)
  {
  /*
     if (abs(xrel)<1)
     {
     XVelocity=0;
     YVelocity=totalspeed;
     if (yrel<0)
     YVelocity=-YVelocity;
     return;
     }

     XVelocity=totalspeed*cos(angle((xrel),(yrel)));
     YVelocity=totalspeed*sin(angle((xrel),(yrel)));
   */
  double xsign = 1;
  if (xrel < 0)
  xsign = -1;
  double ysign = 1;
  if (yrel < 0)
  ysign = -1;
  double scaledxrel = (abs (xrel) / (abs (xrel) + abs (yrel))) * totalspeed;
  double scaledyrel = (abs (yrel) / (abs (yrel) + abs (xrel))) * totalspeed;
  XVelocity = sqrt (sqr (totalspeed) - sqr (scaledyrel)) * xsign;
  YVelocity = sqrt (sqr (totalspeed) - sqr (scaledxrel)) * ysign;

  }

void Point::SetComponents (Point PointToCopy, double factor)
  {
  XVelocity = factor * PointToCopy.XVelocity;
  YVelocity = factor * PointToCopy.YVelocity;
  ZVelocity = factor * PointToCopy.ZVelocity;
  }

void Point::CheckRange (double max)
  {
  if (sqr (X) + sqr (Y) > sqr (max))
  {
  int xsign = -1;
  int ysign = -1;
  XVelocity = -XVelocity;
  YVelocity = -YVelocity;
  if (X > 0)
  xsign = 1;
  if (Y > 0)
  ysign = 1;
  double oldx = X;
    /*if (abs(X)>50||abs(Y)>50)
       {
       fstream debug("Blah.txt",ios::app);
       debug.precision(3);
       debug<<"X="<<X<<"xsign="<<xsign<<"XVelocity="<<XVelocity<<endl;
       debug.close();
       } */
  if (abs (Y) > max)
  {
//                      X=0;
      //                      XVelocity=0;
  Y = max * ysign;
  return;
  }
  else
  if (abs (X) > max)
  {
      //              Y=0;
      //              YVelocity=0;
  X = max * xsign;
  return;
  }
  X = sqrt (sqr (max) - sqr (Y)) * xsign;
  Y = sqrt (sqr (max) - sqr (oldx)) * ysign;
  if (X < 0)
  X = 0;
  if (Y < 0)
  Y = 0;
  }
  }

void Point::Move ()
  {
  X += XVelocity;
  Y += YVelocity;
  Z += ZVelocity;
  }

void Point::SetPosition (double x, double y, double z)
  {
  X = x;
  Y = y;
  Z = z;
  }

double Point::XZCrossProduct (Point middle, Point destination)
  {
  double mappedx1 = X - middle.X;
  double mappedx2 = destination.X - middle.X;
  double mappedz1 = Z - middle.Z;
  double mappedz2 = destination.Z - middle.Z;
  return (mappedx2 * mappedz1) - (mappedx1 * mappedz2);
  }

double Point::YZCrossProduct (Point middle, Point destination)
  {
  double mappedy1 = Y - middle.Y;
  double mappedy2 = destination.Y - middle.Y;
  double mappedz1 = Z - middle.Z;
  double mappedz2 = destination.Z - middle.Z;
  return (mappedy2 * mappedz1) - (mappedy1 * mappedz2);
  }


double Point::XYCrossProduct (Point middle, Point destination)
  {
  double mappedx1 = X - middle.X;
  double mappedx2 = destination.X - middle.X;
  double mappedy1 = Y - middle.Y;
  double mappedy2 = destination.Y - middle.Y;
  return (mappedx1 * mappedy2) - (mappedx2 * mappedy1);
  }

double Point::MapX ()
  {
  double d = .5;
  //double d=(1-Distance(X,Y,length/2,width*3)/Distance(length/2,width*3,length/2,0));
		return X;
//  return ((.85 + d / 2) * .8 * X) + ((.8 + d / 4) * .2 * Y) + (d * 0 * (6 - Z));
  }

double Point::MapY ()
  {
  //double d=(1-Distance(X,Y,length/2,width*3)/Distance(length/2,width*3,length/2,0));
  double d = .5;
  //d+=1;
		return Y;
//  return ((.85 + d / 2) * .1 * X) + ((.8 + d / 4) * .7 * Y) + (2 * sqrt ((sqrt (d))) * (10 - Z));
  }

double Point::BoundR (double length)
  {
  Z = sqrt (sqr (length) - sqr (length - X));
  if (Z < 0)
  Z = 0;
  return Z;
  }

void Point::ModAll(int div)  //ack, misnamed...
{
 while (X > 0 && X>abs(div))
  X -= div;
 while (Y > 0 && Y>abs(div))
  Y -= div;
 while (Z > 0 && Z>abs(div)) 
  Z -= div;

 while (X < 0 && X<-abs(div))
  X += div;
 while (Y < 0 && Y<-abs(div))
  Y += div;
 while (Z < 0 && Z<-abs(div)) 
  Z += div;
}
