// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.

#include <iostream>
using namespace std;

#ifndef ___POINT_H___
#define ___POINT_H___
class Point
{

public:
 Point();
 Point(const Point &rhs);
 friend ostream &operator<<(ostream &o, Point &p);
 friend istream &operator>>(istream &i, Point &p);

 const Point& operator=(const Point& rhs);
 bool operator==(Point &rhs);

 Point(double x, double y, double z);
 void SetComponents(double xrel, double yrel, double totalspeed);
 void SetComponents(Point PointToCopy, double factor);
 void Move();
 void MoveTowardsUnlimited(Point &p);
 void CheckRange(double max);
 void SetPosition(double x, double y, double z=0);
 double XZCrossProduct(Point middle, Point destination);
 double XYCrossProduct(Point middle, Point destination);
 double YZCrossProduct(Point middle, Point destination);
 double MapX();
 double MapY();
 double BoundR(double length);
 void ModAll(int div);
	//protected:
 double X, Y, Z;
//protected:
 double XVelocity, YVelocity, ZVelocity;
};

#endif
