// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


//puck.cpp

//member functions for the puck class
#include "Puck.h"
#include <math.h>
#include "Constants.h"
#include "Utils.h"
#include "Point.h"

Puck::Puck ()
//initializes a puck
{
  Reset (0);
  QuadObj = gluNewQuadric ();
  QuadObj2 = gluNewQuadric ();
}

void Puck::
Reset (int position)
//reinitializes a puck, usually used for faceoffs
{
  switch (position)
    {
    case 0:
      X = length / 2;
      Y = width / 2;
      break;
    case 1:
      X = length / 3;
      Y = width / 5;
      break;
    case 2:
      X = length - length / 3;
      Y = width / 5;
      break;
    case 3:
      X = length / 3;
      Y = width - width / 5;
      break;
    case 4:
      X = length - length / 7;
      Y = width - width / 5;
      break;
    case 5:
      X = length / 6;
      Y = width / 5;
      break;
    case 6:
      X = length - length / 7;
      Y = width / 5;
      break;
    case 7:
      X = length / 7;
      Y = width - width / 5;
      break;
    case 8:
      X = length - length / 7;
      Y = width - width / 5;
      break;
    }

// X=length-length/6;
  // Y=width-width/4;

  Z = 10;
  XVelocity = 0;
  YVelocity = 0;
  ZVelocity = 0;
  PlayerInControl = -1;
  TrackingTime = 0;
}

int Puck::
FindFaceOffPosition ()
{
  if (X <= length / 3)
    if (Y <= width / 2)
      return 5;
    else
      return 7;
  else if (X > length - length / 3)
    if (Y <= width / 2)
      return 6;
    else
      return 8;
  else if (X <= length / 2)
    if (Y <= width / 2)
      return 1;
    else
      return 3;
  else if (Y >= width / 2)
    return 2;
  else
    return 4;
}

#ifdef TWODVERSION
void Puck::Paint(CDC &dc)
{
   CPen PuckPen(PS_SOLID,1,RGB(0,0,0));
   CBrush PuckBrush(RGB(0,0,0));
   CPen *pPen=dc.SelectObject(&PuckPen);
   CBrush *pBrush=dc.SelectObject(&PuckBrush);
   Point p(X,Y,Z);
   CRect CircleBound;
   CircleBound.right=(int)(p.MapX()-3);
   CircleBound.left=(int)(p.MapX()+3);
   // CircleBound.top=Z-3;
   // CircleBound.bottom=Z+3;
   CircleBound.top=(int)(p.MapY()-3);
   CircleBound.bottom=(int)(p.MapY()+3);
   dc.Ellipse(CircleBound);
   CRect ZMapBound;
   ZMapBound.right=(int)(X-3);
   ZMapBound.left=(int)(X+3);
   ZMapBound.top=(int)((470-(Z-3)));
   ZMapBound.bottom=(int)((470-(Z+3)));
   dc.Ellipse(ZMapBound);
   dc.SelectObject(pPen);
   dc.SelectObject(pBrush);
}
#endif

#ifndef TWODVERSION
void Puck::
Paint ()
//draws the puck
{
  glColor3f (0, 0, 0);
  glPushMatrix ();
  glTranslatef (X, Y, Z);
  gluQuadricDrawStyle (QuadObj, (GLenum)GLU_FILL);
// gluQuadricOrientation(QuadObj,GLU_INSIDE);
  gluCylinder (QuadObj, 1.5, 1.5, 1, 12, 3);
  glTranslatef (0, 0, 1);
  gluDisk (QuadObj, 0, 1.5, 12, 1);
/*      glBegin(GL_POLYGON);
   for (double theta=0;theta<2*pi;theta+=.5)
   glVertex3f(1.5*cos(theta),1.5*sin(theta),1.5);
   glEnd();
   glBegin(GL_POLYGON);
   for (theta=2*pi;theta>0;theta-=.5)
   glVertex3f(1.5*cos(theta),1.5*sin(theta),0);
   glEnd();
   glBegin(GL_POLYGON);
   for (theta=2*pi;theta>0;theta-=.5)
   {
   glVertex3f(1.5*cos(theta),1.5*sin(theta),0);
   glVertex3f(1.5*cos(theta-.5),1.5*sin(theta),0);
   glVertex3f(1.5*cos(theta-.5),1.5*sin(theta),1.5);
   glVertex3f(1.5*cos(theta),1.5*sin(theta),1.5);
   }
   glEnd();
 */
  glPopMatrix ();
//      Box(X+2,Y+2,Z+1.2,X-2,Y-2,Z);
}
#endif

void Puck::
SetComponents (double totalspeed, double DestX, double DestY, double DestZ)
//sets the component vectors given the puck's destination and the
//total amount of speed to be allocated
{
  /*
     if (abs(DestX-X)<1)
     {
     XVelocity=0;
     YVelocity=totalspeed;
     if (DestY-Y<0)
     YVelocity=-YVelocity;
     return;
     }
     XVelocity=totalspeed*cos(angle((DestX-X),(DestY-Y)));
     YVelocity=totalspeed*sin(angle((DestX-X),(DestY-Y)));
   */

  double predictedx = X + (0 * XVelocity);
  double predictedy = Y + (0 * YVelocity);
  double predictedz = Z + (0 * ZVelocity);
  double x = 0;
  double z = 0;
// numerator=abs(DestX-predictedx);
  // denominator=numerator+abs(DestY-predictedy);

  double numerator = sqr (DestZ - predictedz);
  double denominator = numerator + sqr (Distance (DestX, DestY, X, Y));

  if (denominator > 0)
    z = sqrt (sqr (totalspeed) * (numerator / denominator));
  ZVelocity = z;
  totalspeed -= ZVelocity;

  numerator = sqr (DestX - predictedx);
  denominator = numerator + sqr (DestY - predictedy);

  if (denominator > 0)
    x = sqrt (sqr (totalspeed) * (numerator / denominator));	//pythagorean theorem *
  //proportion

  if (DestX < predictedx)	//negate vector if moving in a negative direction

    x = -x;
// if (abs(DestX-predictedx)<10)//eliminate slight errors in vertical movement
  //  x=0;
  XVelocity = x;
  double y = sqrt (sqr (totalspeed) * (1 - numerator / denominator));	//take what's left
  //of the speed

  if (DestY < predictedy)	//negate if moving negatively

    y = -y;
// if (abs(DestY-predictedy)<10) //straighten (see above)
  //  y=0;
  YVelocity = y;

}

void Puck::
SetPosition (double x, double y, double z)
//puts the puck at a given point on the ice
{
  X = x;
  Y = y;
  Z = z;
}

int Puck::
ClearPath (double destx, double desty, PlayerView state[PlayersPerTeam * 2 + 4],
	   int homeorvisitor)
//determines whether the puck can be moved through an area without risk
//of running into an enemy player
{
  double d = Distance (X, Y, destx, desty) / 2;
  for (int i = PlayersPerTeam * !homeorvisitor; i < PlayersPerTeam + PlayersPerTeam * !homeorvisitor; i++)	//if any enemy player is

    {
      if (state[i].OnIce == 1 &&
	  abs (angle ((state[i].X - X), (state[i].Y - Y)) -
	       angle ((destx - X), (desty - Y))) < 3.1415926 / 8 &&
       ((((destx > X && state[i].X <= destx + 20 && state[i].X >= X - 20) ||
	(destx <= X && state[i].X >= destx - 20 && state[i].X <= X + 20)) &&
	 ((desty > Y && state[i].Y <= desty + 20 && state[i].Y >= Y - 20) ||
      (desty <= Y && state[i].Y >= desty - 20 && state[i].Y <= Y + 20)))) ||
	  Distance (destx, desty, state[i].X, state[i].Y) <
	  Distance (destx, desty, X, Y) / 3 ||
	  (Distance (state[i].X, state[i].Y, X, Y) < playerdiameter * 2 &&
	   abs (angle ((state[i].X - X), (state[i].Y - Y)) -
		angle ((destx - X), (desty - Y))) < 3.1415926))

/*                                                                              ((destx>X&&state[i].X<destx+d&&state[i].X>X-d)||
   (destx<=X&&state[i].X>destx-d&&state[i].X<X+d))&&
   ((desty>Y&&state[i].Y<desty+d&&state[i].Y>Y-d)||
   (desty<=Y&&state[i].Y>desty-d&&state[i].Y<Y+d)))
 */ return 0;
    }
  return 1;
}



/*      double denominator=destx-X;
   if (denominator==0)
   denominator=.0000000000001;
   double slope=(desty-Y)/(destx-X);
   for (int i=PlayersPerTeam*!homeorvisitor;i<PlayersPerTeam+PlayersPerTeam*!homeorvisitor;i++) //if any enemy player is
   {
   if (((slope*((state[i].X-X)/(state[i].Y-Y))<1.5)&&
   (slope*((state[i].X-X)/(state[i].Y-Y))>.5))&&
   ((destx>=X&&state[i].X<=destx&&state[i].X>=X)||
   (destx<X&&state[i].X>destx&&state[i].X<X))&&
   ((desty>=Y&&state[i].Y<=desty&&state[i].Y>=Y)||
   (desty<Y&&state[i].Y>desty&&state[i].Y<Y)))
   /*||
   Distance(destx,desty,state[i].X,state[i].Y)<Distance(X,Y,destx,desty)/10 */
/*               return 0;
   } */
// if (/*Distance(destx,desty,state[i].X,state[i].Y)<Distance(X,Y,destx,desty)/10||*/
//       //within a radius of the destination spot
//     (abs(state[i].X-X)<20&&Y>=desty&&state[i].Y<=Y&&state[i].Y>=desty)||
//     (abs(state[i].X-X)<20&&Y<=desty&&state[i].Y>=Y&&state[i].Y<=desty)||
//     (abs(state[i].Y-Y)<20&&X>=destx&&state[i].X<=X&&state[i].X>=destx)||
//     (abs(state[i].Y-Y)<20&&X<=destx&&state[i].X>=X&&state[i].X<=destx))
		//or somewhere along the path
//    return 0;
/*  if (Distance(X,Y,state[PlayersPerTeam*2].X,state[PlayersPerTeam*2].Y)<30&&  //home goalie
   Distance(X,Y,state[PlayersPerTeam*2].X,state[PlayersPerTeam*2].Y)>3)
   return 0;
   if (Distance(X,Y,state[PlayersPerTeam*2+2].X,state[PlayersPerTeam*2+4].Y)<30&& //visitor goalie
   Distance(X,Y,state[PlayersPerTeam*2+2].X,state[PlayersPerTeam*2+4].Y)>3)
   return 0;
 */
//return 1;

//}



void Puck::
SetVelocity (double xvel, double yvel, double zvel)
//manually sets the puck's velocity
//used when a player controls it
{
  XVelocity = xvel;
  YVelocity = yvel;
  ZVelocity = zvel;
}

int Puck::
InGoal (double GoalX, double GoalY)
//determines if the puck is in a goal
{
  if (abs (X - GoalX) < goalwidth / 2 && abs (Y - GoalY) < goallength / 2 && Z < 10 && PlayerInControl < PlayersPerTeam * 2)
    return 1;
  return 0;
}

int Puck::
Act ()
//updates the velocity and position of the puck for a given frame
{
  int Result = PUCK_HIT_NOTHING;
  TrackingTime++;
  if (abs (XVelocity) < .5)	//stop moving eventually

    XVelocity = 0;
  if (abs (YVelocity) < .5)
    YVelocity = 0;

  if (X + XVelocity / FrameRate < homegoalx - goalwidth / 2 && X > homegoalx + goalwidth / 2 && abs (width / 2 - Y) < goallength && Z < 20)
    X = homegoalx;
  else if (X + XVelocity / FrameRate > visitorgoalx + goalwidth / 2 && X < visitorgoalx + goalwidth / 2 && abs (width / 2 - Y) < goallength && Z < 20)
    X = visitorgoalx;
  else
    X += XVelocity / FrameRate;	//physically move the puck

  Y += YVelocity / FrameRate;
  Z += ZVelocity / FrameRate;

  XVelocity /= (1.02);		//apply friction

  YVelocity /= (1.02);

  if (Z > 0)
//  ZVelocity-=.006061/FrameRate;       //apply gravity
    ZVelocity -= 6.1 / FrameRate;	//apply gravity

  if (Z < .1)
    {
      Z = 0;
      if (ZVelocity < -1)	//bounce

	ZVelocity = -ZVelocity / 2;
      else
	ZVelocity = 0;
    }

  double AngleWithTopPost = 0;
  double AngleWithBottomPost = 0;
  if (InGoal (homegoalx, width / 2))
    {
      double goalx = homegoalx;
      double goaly = width / 2;
      AngleWithTopPost = /*angle (*/((goalx + goalwidth / 2) - (X-XVelocity))/ ((goaly - goallength / 2) - (Y-YVelocity));//);
      AngleWithBottomPost = /*angle (*/((goalx + goalwidth / 2) - (X-XVelocity))/ ((goaly + goallength / 2) - (Y-YVelocity));//);
      double PuckEntryAngle = /*angle (*/XVelocity/ YVelocity;//);
      if (abs(PuckEntryAngle) > abs(AngleWithTopPost) || abs(PuckEntryAngle) < abs(AngleWithBottomPost) || XVelocity > 0)
	{
	 // cout<<"Rejected from home goal.  Entry Angle="<<PuckEntryAngle<<", Top Post="<<AngleWithTopPost<<", Bottom Post="<<AngleWithBottomPost<<endl;
	  X -= XVelocity;
	  Y -= YVelocity;
	  XVelocity = -XVelocity / 8;
	  YVelocity = -YVelocity / 8;
	}
    }
  else if (InGoal (visitorgoalx, width / 2))
    {
      double goalx = visitorgoalx;
      double goaly = width / 2;
      AngleWithTopPost = /*angle (*/((goalx + goalwidth / 2) - (X-XVelocity))/ ((goaly - goallength / 2) - (Y-YVelocity));//);
      AngleWithBottomPost = /*angle (*/((goalx + goalwidth / 2) - (X-XVelocity))/ ((goaly + goallength / 2) - (Y-YVelocity));//);
      double PuckEntryAngle = /*angle (*/XVelocity/ YVelocity;//);
      if (abs(PuckEntryAngle) > abs(AngleWithTopPost) || abs(PuckEntryAngle) < abs(AngleWithBottomPost) || XVelocity < 0)
	{
	//  cout<<"Rejected from visitor goal.  Entry Angle="<<PuckEntryAngle<<", Top Post="<<AngleWithTopPost<<", Bottom Post="<<AngleWithBottomPost<<endl;
	  X -= XVelocity;
	  Y -= YVelocity;
	  XVelocity = -XVelocity / 8;
	  YVelocity = -YVelocity / 8;
	}
    }
  //if (((atan(YVelocity/XVelocity)>3.1415926/2&&
  //                               atan(YVelocity/XVelocity)<3*3.1415926/2)&&InGoal(homegoalx,width/2))||
  //    ((atan(YVelocity/XVelocity)<3.1415926/2||
  //                               atan(YVelocity/XVelocity)>3*3.1415926/2)&&InGoal(visitorgoalx,width/2)))
  /*      if ((InGoal(homegoalx,width/2)&&X+XVelocity>homegoalx+goalwidth/2&&((Y+YVelocity>width/2+goallength/2||Y+YVelocity>width/2-goallength/2)||X+XVelocity<visitorgoalx+goalwidth/2))||
     (InGoal(visitorgoalx,width/2)&&X+XVelocity>visitorgoalx-goalwidth/2&&((Y+YVelocity>width/2+goallength/2||Y+YVelocity<width/2-goallength/2)||X+XVelocity>visitorgoalx+goalwidth/2)))
     //if entered the net from the wrong end, bounce off
     {
     if (X>=visitorgoalx)
     X=length-(49-goalwidth/2);
     else
     X=49-goalwidth/2;
     XVelocity=-XVelocity/10;
     YVelocity=-YVelocity/10;
     if (ZVelocity>0)
     ZVelocity=0;
     }
   */

  if (X > length && (Y > 75 || Y < width - 75))		//if out of bounds, bounce off the wall

    {
      Result = PUCK_HIT_BACKBOARD;
      X = length;
      XVelocity = -XVelocity / 8;
      if (ZVelocity > 0)
	ZVelocity = 0;
    }
  if (Y > width && (X > 75 || X < length - 75))
    {
      Result = PUCK_HIT_SIDEBOARD;
      Y = width;
      YVelocity = -YVelocity / 8;
      if (ZVelocity > 0)
	ZVelocity = 0;
    }
  if (Y < 0 && (X > 75 || X < width - 75))
    {
      Result = PUCK_HIT_SIDEBOARD;
      Y = 0;
      YVelocity = -YVelocity / 8;
      if (ZVelocity > 0)
	ZVelocity = 0;
    }
  if (X < 0 && (Y > 75 || Y < width - 75))
    {
      Result = PUCK_HIT_BACKBOARD;
      X = 0;
      XVelocity = -XVelocity / 8;
      if (ZVelocity > 0)
	ZVelocity = 0;
    }
  if (X <= 75 && Y <= 75 && Distance (75, 75, X, Y) > 75)	//corners.  Need to be fixed, badly :(

    {
     if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
      Result = PUCK_HIT_CORNER;
      if (ZVelocity > 0)
	ZVelocity = 0;

      if (XVelocity != 0 && YVelocity != 0)
	if (abs (XVelocity / (abs (YVelocity) + 1)) > 1)
	  {
	    XVelocity = -avg (abs (XVelocity), abs (YVelocity));
	    YVelocity = 0;
	  }
	else if (abs (XVelocity / (abs (YVelocity) + 1)) < 1)
	  {
	    YVelocity = -avg (abs (XVelocity), abs (YVelocity));
	    XVelocity = 0;
	  }
	else
	  {
	    XVelocity = abs (XVelocity / 5);
	    YVelocity = abs (YVelocity / 5);
	  }

      XVelocity /= 1.01;
      YVelocity /= 1.01;

    }
  if (X <= 75 && Y >= width - 75 && Distance (75, 75, X, width - Y) > 75)
    {
      if (ZVelocity > 0)
	ZVelocity = 0;
      if (XVelocity != 0 && YVelocity != 0)
	if (abs (XVelocity / (abs (YVelocity) + 1)) > 1)
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
	   XVelocity = -avg (abs (XVelocity), abs (YVelocity));
	   YVelocity = 0;
	  }
	else if (abs (XVelocity / (abs (YVelocity) + 1)) < 1)
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
           YVelocity = avg (abs (XVelocity), abs (YVelocity));
           XVelocity = 0;
	  }
	else
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
           XVelocity = abs (XVelocity / 5);
	   YVelocity = -abs (YVelocity / 5);
	  }

      XVelocity /= 1.01;
      YVelocity /= 1.01;
    }
  if (X >= length - 75 && Y <= 75 && Distance (75, 75, length - X, Y) > 75)
    {
      if (ZVelocity > 0)
	ZVelocity = 0;
      if (XVelocity != 0 && YVelocity != 0)
	if (abs (XVelocity / (abs (YVelocity) + 1)) > 1)
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
           XVelocity = avg (abs (XVelocity), abs (YVelocity));
           YVelocity = 0;
	  }
	else if (abs (XVelocity / (abs (YVelocity) + 1)) < 1)
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
           YVelocity = -avg (abs (XVelocity), abs (YVelocity));
           XVelocity = 0;
	  }
	else if (abs (YVelocity / (abs (XVelocity) + 1)) < 1)
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
           XVelocity = -avg (abs (XVelocity), abs (YVelocity));
           YVelocity = 0;
	  }
	else
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
           XVelocity = -abs (XVelocity / 5);
           YVelocity = abs (YVelocity / 5);
	  }
      XVelocity /= 1.01;
      YVelocity /= 1.01;
    }
  if (X >= length - 75 && Y >= width - 75 && Distance (75, 75, length - X, width - Y) > 75)
    {
      if (ZVelocity > 0)
	ZVelocity = 0;
      if (XVelocity != 0 && YVelocity != 0)
	if (abs (XVelocity / (abs (YVelocity) + 1)) > 1)
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
           XVelocity = avg (abs (XVelocity), abs (YVelocity));
           YVelocity = 0;
	  }
	else if (abs (XVelocity / (abs (YVelocity) + 1)) < 1)
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
           YVelocity = avg (abs (XVelocity), abs (YVelocity));
           XVelocity = 0;
	  }
	else
	  {
           if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
            Result = PUCK_HIT_CORNER;
           XVelocity = -abs (XVelocity / 5);
           YVelocity = -abs (YVelocity / 5);
	  }
    }
//

  if (XVelocity <= 0 && X <= 75 && Y <= 75 && Distance (75, 75, X, Y) >= 75)
    {
      Y = 75 - (sqrt (sqr (75) - sqr (75 - X)));
      XVelocity /= cornerdecel;
      if (X < 3)
	{
         if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
          Result = PUCK_HIT_CORNER;
         YVelocity = -XVelocity * cornerexitaccel;
         XVelocity = 0;
	}
    }
  else if (X <= 75 && Y >= width - 75 && Distance (75, 75, X, width - Y) > 75 && XVelocity <= 0)
    {
      Y = width - (75 - (sqrt (sqr (75) - sqr (75 - X))));
      XVelocity /= cornerdecel;
      if (X < 3)
 	{
         if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
          Result = PUCK_HIT_CORNER;
         YVelocity = XVelocity * cornerexitaccel;
         XVelocity = 0;
	}
    }
  else if (X >= length - 75 && Y <= 75 && Distance (75, 75, length - X, Y) > 75 && Y < width / 2 && XVelocity >= 0)
    {
     if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
      Result = PUCK_HIT_CORNER;
     Y = 75 - (sqrt (sqr (75) - sqr (75 - (length - X))));
     XVelocity /= cornerdecel;
     if (length - X < 3)
     {
      YVelocity = XVelocity * cornerexitaccel;
      XVelocity = 0;
     }
    }
  else if (X >= length - 75 && Y >= width - 75 && Distance (75, 75, length - X, width - Y) > 75 && XVelocity >= 0)
    {
     if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
      Result = PUCK_HIT_CORNER;
     Y = width - (75 - (sqrt (sqr (75) - sqr (75 - (length - X)))));
     XVelocity /= cornerdecel;
     if (length - X < 3)
     {
      YVelocity = -XVelocity * cornerexitaccel;
      XVelocity = 0;
     }
    }

  if (X <= 75 && Y <= 75 && Distance (75, 75, X, Y) > 75 && YVelocity <= 0)
    {
     if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
      Result = PUCK_HIT_CORNER;
     X = 75 - (sqrt (sqr (75) - sqr (75 - Y)));
     YVelocity /= cornerdecel;
     if (Y < 3)
     {
      XVelocity = -YVelocity * cornerexitaccel;
      YVelocity = 0;
     }
    }
  else if (X <= 75 && Y >= width - 75 && Distance (75, 75, X, width - Y) > 75 && YVelocity >= 0)
    {
     if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
      Result = PUCK_HIT_CORNER;
     X = 75 - (sqrt (sqr (75) - sqr (75 - (width - Y))));
     YVelocity /= cornerdecel;
     if (width - Y < 3)
     {
      XVelocity = YVelocity * cornerexitaccel;
      YVelocity = 0;
     }
    }
  else if (X >= length - 75 && Y <= 75 && Distance (75, 75, length - X, Y) > 75 && YVelocity <= 0 /*&&X<length/2 */ )
    {
     if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
      Result = PUCK_HIT_CORNER;
     X = length - (75 - (sqrt (sqr (75) - sqr (75 - Y))));
     YVelocity /= cornerdecel;
     if (Y < 3)
     {
      XVelocity = YVelocity * cornerexitaccel;
      YVelocity = 0;
     }
    }
  else if (X >= length - 75 && Y >= width - 75 && Distance (75, 75, length - X, width - Y) > 75 && YVelocity >= 0)
    {
     if (sqrt(sqr(XVelocity)+sqr(YVelocity))>30)
      Result = PUCK_HIT_CORNER;
     X = length - (75 - (sqrt (sqr (75) - sqr (75 - (width - Y)))));
     YVelocity /= cornerdecel;
     if (width - Y < 3)
     {
      XVelocity = -YVelocity * cornerexitaccel;
      YVelocity = 0;
     }
    }
  ///


return Result;


}

double Puck::
GetX ()
{
  return X;
}

double Puck::
GetY ()
{
  return Y;
}

double Puck::
GetZ ()
{
  return Z;
}

double Puck::
GetXVelocity ()
{
  return XVelocity;
}

double Puck::
GetYVelocity ()
{
  return YVelocity;
}

double Puck::
GetZVelocity ()
{
  return ZVelocity;
}


int Puck::
InAttackZone (int HomeorVisitor, double BlueLine)
//determines if the puck is in a team's attack zone based on
//the team's BlueLine
{
  if (HomeorVisitor == 0 && X > BlueLine)
    return 1;
  if (HomeorVisitor == 1 && X < BlueLine)
    return 1;
  return 0;
}

void Puck::
ResetTrackingTime ()
{
  TrackingTime = 0;
}

int Puck::
GetTrackingTime ()
{
  return TrackingTime;
}
