// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#ifndef PUCK
#define PUCK
#ifdef USEMFC
#include "stdafx.h"
#include <GL/gl.h>
#include <GL/glu.h>
#else	/* 
 */
#include <GL/glut.h>
#endif	/* 
 */
#include "Constants.h"

class Puck 
{
  
public:
    Puck ();			//initializes

  void Reset (int position = 0);	//reinitializes

  int FindFaceOffPosition ();
  
#ifndef TWODVERSION
  void Paint ();		//draws the puck
#endif
#ifdef TWODVERSION
  void Paint (CDC &dc);
#endif

  void SetPosition (double x, double y, double z = 0);	//puts the puck at (x,y)

  int InGoal (double GoalX, double GoalY);	//determines if the puck is in a
  //goal

  void SetComponents (double totalspeed, double DestX, double DestY, double DestZ = 0);
  
  //sets the component vectors
    void SetVelocity (double xvel, double yvel, double zvel);	//manually sets the
  //velocity

  int ClearPath (double destx, double desty, PlayerView state[PlayersPerTeam * 2 + 4], 
		 int homeorvisitor);	//determines if the puck can move
  //to (destx, desty) without contacting
  //an enemy player

  int Act ();			//moves and applys friction and gravity

  double GetX ();
  
    double GetY ();
  
    double GetZ ();
  
    double GetXVelocity ();
  
    double GetYVelocity ();
  
    double GetZVelocity ();
  
    int InAttackZone (int HomeorVisitor, double BlueLine);	//determines if the
  //puck is in the given
  //attack zone

  int PlayerInControl;		//the id of the player in control of the puck

  int GetTrackingTime ();
  
    void ResetTrackingTime ();
  
protected:
    double X, Y, Z;		//coordinates

  double XVelocity;		//velocity components

  double YVelocity;
  
    double ZVelocity;
  
    int TrackingTime;
  
    GLUquadricObj * QuadObj;
  
    GLUquadricObj * QuadObj2;
  
};

#endif
