#include "RigidObject.h"
#include <GL/glut.h>
#include "Tiff.h"

RigidObject::RigidObject()
{
 NumFaces = 0;
 DisplayListID = 0;
 TextureID = 0;
}

RigidObject::RigidObject(fstream &acfile)
{
 TextureID = 0;
 Load(acfile);
}

bool RigidObject::Load(fstream &acfile)
{
 DisplayListID = glGenLists(1);
 string ignore;
 int numvertices;
 acfile>>ignore>>ignore>>ignore>>ignore>>ignore; // OBJECT x name y loc
 acfile>>Location;
 acfile>>ignore;
// cout<<"Ignore is "<<ignore<<endl;
 if (ignore == "texture")
 {
  string texfile;
  acfile>>texfile;
  Tiff texturetiff(texfile.c_str());
  uint32* texture = texturetiff.GetGLTexture();
  glPixelStorei(GL_UNPACK_ALIGNMENT,1);
  glGenTextures(1,&TextureID);
//  cout<<"id is "<<TextureID<<endl;
  glBindTexture(GL_TEXTURE_2D,TextureID);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,GL_CLAMP);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,GL_CLAMP);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,256, 256/*width,length*/,0,GL_RGBA,GL_UNSIGNED_BYTE,texture);
  glEnable(GL_TEXTURE_2D);
//  cout<<"Continuing to read..."<<endl;
  acfile>>ignore>>numvertices;
 }
 else
  acfile>>numvertices;
// cout<<"numvertices is "<<numvertices<<endl;
 Vector* vertices = new Vector[numvertices];
 for (int i = 0; i < numvertices; i++)
  acfile>>vertices[i];
 acfile>>ignore>>NumFaces;
 glNewList(DisplayListID, GL_COMPILE);
 glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
// glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
 for (int x = 0; x < NumFaces; x++)
 {
  int numrefs;
  acfile>>ignore>>ignore>>ignore>>ignore>>ignore;
  acfile>>numrefs;
  glBegin(GL_TRIANGLE_FAN);
//  glBegin(GL_LINE_LOOP);
  if (TextureID != 0)
   glBindTexture(GL_TEXTURE_2D,TextureID);

  for (int y = 0; y < numrefs; y++)
  {
   double texx, texy;
   int curref;
   if (TextureID == 0)
    acfile>>curref>>ignore>>ignore;
   else
   {
    acfile>>curref>>texx>>texy;
    glTexCoord2f(texx, texy);
   }

//			int previous = curref - 1;
//			if (previous < 0)
//				previous = numrefs - 1;
//			int next = x + 1;
//			if (next > numrefs - 1)
//				next = 0;

//   Vector normal;
//   normal.Normal(vertices[previous], vertices[curref], vertices[next]);
//   glNormal3f(normal.GetX(), normal.GetY(), normal.GetZ());

   glVertex3f(/*10**/(vertices[curref].GetX() + Location.GetX()),
              /*10**/(vertices[curref].GetY() + Location.GetY()),
              /*10**/(vertices[curref].GetZ() + Location.GetZ()));
  }
  glEnd();
 }
 acfile>>ignore>>ignore; // kids x
 glEndList();
	return true;
}

void RigidObject::Display()
{
 if (TextureID != 0)
  glBindTexture(GL_TEXTURE_2D,TextureID);
 glCallList(DisplayListID);
}
