// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#include "Skeleton.h"
#include "Utils.h"
#include "Constants.h"
#include <fstream>
#include <math.h>
using namespace std;

// This is, however, one of the more interesting files...
// It contains the walking algorthim and the physics 
// model for walking...

Skeleton::Skeleton ():Joints(), StopAnimation(), ShootAnimation(), StandAnimation(), OldHip()
{
  //  Joints.RightHand.Z = 90;
  StopAnimation.Load("stop.ani");
  ShootAnimation.Load("shoot.ani");
  StandAnimation.Load("stand.ani");
}

ostream &operator<<(ostream &o, Skeleton &s)
{
 o<<s.Joints;
 return o;
}

istream &operator>>(istream &i, Skeleton &s)
{
 i>>s.Joints;
 return i;
}

void Skeleton::MoveTowards(Skeleton &s)
{
 Joints.MoveTowards(s.Joints);
}


void Skeleton::
EnforceRigidity ()
{
 Joints.EnforceRigidity(AppendageOnGround);
}

int Skeleton::
FallingForward ()
{
  return Joints.Hip.XVelocity < -1;
}

int Skeleton::
FallingBackward ()
{
  return Joints.Hip.XVelocity > 1;
}

int Skeleton::
FallingLeft ()
{
  return Joints.Hip.YVelocity < -1;
}

int Skeleton::
FallingRight ()
{
  return Joints.Hip.YVelocity > 1;
}

int Skeleton::
LeaningForward ()
{
  return Joints.Hip.X > 1;
}

int Skeleton::
LeaningBackward ()
{
  return Joints.Hip.X < -1;
}

int Skeleton::
LeaningLeft ()
{
  return Joints.Hip.Y < -1;
}

int Skeleton::
LeaningRight ()
{
  return Joints.Hip.Y > 1;
}

int Skeleton::
LeftFootOnGround ()
{
  return AppendageOnGround == 0;
}

int Skeleton::
RightFootOnGround ()
{
  return AppendageOnGround == 1;
}

int Skeleton::
LeftHandOnGround ()
{
  return AppendageOnGround == 2;
}

int Skeleton::
RightHandOnGround ()
{
  return AppendageOnGround == 3;
}

void Skeleton::
StartWalking ()
{
  // Start Walking if not already started
  Joints.LeftThigh.XVelocity = 5;
  Joints.RightThigh.XVelocity = -5;
  Joints.Torso.X = -20;
  Joints.Torso.ZVelocity = 5;
  Joints.Neck.X = 20;
}

void Skeleton::
CheckLeadThighAngle (Body * b)
{
  if (Joints.LeftThigh.X<0&&Joints.RightThigh.X<0)
  {
   StartWalking();
  }  
  // if (LeftThigh.X<0&&RightThigh.X<0)
  // {
  //  LeftShin.X-=25;
  //  LeftThigh.X=30;
  // }

  if (LeftFootOnGround ())
    // if the left leg is on the ground (AppendageOnGround==0?)
    {
//                      if (LeftThigh.X<-50&&LeftThigh.XVelocity<0)
      if (Joints.LeftThigh.X > 50 && Joints.LeftThigh.XVelocity > 0)
	// if the thigh is too far out
	{
  	  //	  LeftThigh.XVelocity = -5;	// stop it
  	  	  Joints.LeftThigh.XVelocity = -5;	// stop it
	  //                       RightThigh.XVelocity=15; // and start to bring the other one forward

	  Joints.RightThigh.XVelocity = 30;	// and start to bring the other one forward
      	  Joints.RightShin.XVelocity=20;
	  Joints.LeftShin.XVelocity = 0;
	}
    }
  else				/*if (RightFootOnGround()) */
    //  if the right leg is on the ground
    {
//                      if (RightThigh.X<-50&&RightThigh.XVelocity<0)
      if (Joints.RightThigh.X > 50 && Joints.RightThigh.XVelocity > 0)
	// if the thigh is too far out
	{
	  //	  RightThigh.XVelocity = -5;	// stop it
	  Joints.RightThigh.XVelocity = -5 ;	// stop it
	  //                       LeftThigh.XVelocity=15; // and bring the other one forward

	  Joints.LeftThigh.XVelocity = 30;	// and bring the other one forward
	  Joints.LeftShin.XVelocity=20;
	  Joints.RightShin.XVelocity = 0;
	}
    }
}

void Skeleton::
CheckTrailThighAngle (Body * b)
{
  if (LeftFootOnGround ())
    {
//        RightThigh.XVelocity=13; //Left Leg On Ground
      //        LeftThigh.XVelocity=-10;
      //               LeftShin.XVelocity=10;
      //               RightShin.XVelocity=-10;

      Joints.RightThigh.XVelocity = 26;	//Left Leg On Ground

      Joints.LeftThigh.XVelocity = -20;
      Joints.LeftShin.XVelocity = 20;
      Joints.RightShin.XVelocity = -25;
    }
  else
    {
//               LeftThigh.XVelocity=13;  //Right Leg On Ground
      //               RightThigh.XVelocity=-10;
      //               RightShin.XVelocity=10;
      //       LeftShin.XVelocity=-10;

      Joints.LeftThigh.XVelocity = 26;	//Right Leg On Ground

      Joints.RightThigh.XVelocity = -20;
      Joints.RightShin.XVelocity = 20;
      Joints.LeftShin.XVelocity = -25;

    }
}

void Skeleton::
MoveArms ()
{
  Joints.LeftHand.ZVelocity = (2 * (Joints.LeftHand.Z < 0) - 1) * 2;
  Joints.LeftLowerArm.Y = 0;
  Joints.LeftLowerArm.YVelocity = 0;
  Joints.RightLowerArm.Y = 0;
  Joints.RightLowerArm.YVelocity = 0;
  if (Joints.Hip.X < -45 /*&&FallingForward() */ )
    {
      if (-Joints.Hip.X < Joints.RightUpperArm.X)
	Joints.RightUpperArm.XVelocity = -10;
      else if (-Joints.Hip.X > Joints.RightUpperArm.X)
	Joints.RightUpperArm.XVelocity = 10;
      else
	Joints.RightUpperArm.XVelocity = 0;
      if (-Joints.Hip.X < Joints.LeftUpperArm.X)
	Joints.LeftUpperArm.XVelocity = -10;
      else if (-Joints.Hip.X > Joints.LeftUpperArm.X)
	Joints.LeftUpperArm.XVelocity = 10;
      else
	Joints.LeftUpperArm.XVelocity = 0;
    }
  else if (Joints.Hip.X > 45 /*&&FallingBackward() */ )
    {
      if (Joints.Hip.X < Joints.RightUpperArm.X)
	Joints.RightUpperArm.XVelocity = 10;
      else if (Joints.Hip.X > Joints.RightUpperArm.X)
	Joints.RightUpperArm.XVelocity = -10;
      else
	Joints.RightUpperArm.XVelocity = 0;
      if (Joints.Hip.X < Joints.LeftUpperArm.X)
	Joints.LeftUpperArm.XVelocity = 10;
      else if (Joints.Hip.X > Joints.LeftUpperArm.X)
	Joints.LeftUpperArm.XVelocity = -10;
      else
	Joints.LeftUpperArm.XVelocity = 0;
    }
  else
    {
      if (!RightHandOnGround ())
	{
	  Joints.RightUpperArm.X = Joints.LeftThigh.X / 3;
	  Joints.RightLowerArm.X = -Joints.LeftShin.X / 3;
	}
      if (!LeftHandOnGround ())
	{
	  Joints.LeftUpperArm.X = Joints.RightThigh.X / 3;
	  Joints.LeftLowerArm.X = -Joints.RightShin.X / 3;
	}
    }
  if (abs (Joints.RightUpperArm.X + Joints.Hip.X) < 21)
    Joints.RightUpperArm.XVelocity = 0;
  if (abs (Joints.LeftUpperArm.X + Joints.Hip.X) < 21)
    Joints.LeftUpperArm.XVelocity = 0;

}

void Skeleton::
BalanceLaterally ()
{
  if (LeaningLeft () && Joints.RightThigh.Y < 45)
    Joints.RightThigh.YVelocity = 5;
  else if (Joints.RightThigh.Y > 0)
    Joints.RightThigh.YVelocity = -5;

  if (Joints.RightThigh.Y > 45)
    Joints.RightThigh.YVelocity = -5;
  if (Joints.RightThigh.Y == 0 && Joints.RightThigh.YVelocity < 0)
    Joints.RightThigh.YVelocity = 0;
  if (Joints.Hip.YVelocity > 0)
    Joints.Hip.YVelocity += -.5;

  if (Joints.Hip.Y < -45 && Joints.RightUpperArm.Y < 90)
    Joints.RightUpperArm.YVelocity = 5;
  if (Joints.RightUpperArm.Y > 90)
    Joints.RightUpperArm.YVelocity = -5;
  if (Joints.RightUpperArm.Y <= 0 && Joints.RightUpperArm.YVelocity < 0)
    Joints.RightUpperArm.YVelocity = 0;

  if (Joints.Hip.Y > 45 && Joints.LeftUpperArm.Y > -90)
    Joints.LeftUpperArm.YVelocity = -5;
  if (Joints.LeftUpperArm.Y < -90)
    Joints.LeftUpperArm.YVelocity = 5;
  if (Joints.LeftUpperArm.Y >= 0 && Joints.LeftUpperArm.YVelocity > 0)
    Joints.LeftUpperArm.YVelocity = 0;


  if (LeftFootOnGround ())	//left leg

    {
      if (LeaningLeft () && !FallingLeft () && abs (Joints.Hip.Y) <= 10)
	{
	  Joints.Hip.Y = 0;
	  Joints.Hip.YVelocity = 0;
//              RightThigh.YVelocity=0;
	}
      if (LeaningLeft () && Joints.Hip.YVelocity > -35)
	Joints.Hip.YVelocity = 5;
      else if (Joints.Hip.YVelocity > 0)
	Joints.Hip.YVelocity -= .5;
      if (FallingRight () && Joints.RightThigh.Y < 45)
	{
	  Joints.RightThigh.YVelocity = 5;
	}
      else if (Joints.RightThigh.Y > 0)
	Joints.RightThigh.YVelocity = -5;
      if (Joints.RightThigh.Y > 45)
	Joints.RightThigh.YVelocity = -5;
      if (Joints.RightThigh.Y < 0 && Joints.RightThigh.YVelocity <= 0)
	{
	  Joints.RightThigh.YVelocity = 0;
	  Joints.RightThigh.Y = 0;
	}
    }
  else if (RightFootOnGround ())	//right leg

    {
      if (LeaningRight () && !FallingRight () && abs (Joints.Hip.Y) <= 10)
	{
	  Joints.Hip.Y = 0;
	  Joints.Hip.YVelocity = 0;
//                              LeftThigh.Y=0;
	  //                              LeftThigh.YVelocity=0;
	}
      if (LeaningRight () && Joints.Hip.YVelocity < 35)
	Joints.Hip.YVelocity = -5;
      else if (FallingRight ())
	Joints.Hip.YVelocity -= .5;
      if (FallingLeft () && Joints.LeftThigh.Y > -45)
	{
	  Joints.LeftThigh.YVelocity = -5;
	}
      else if (Joints.LeftThigh.Y < 0)
	Joints.LeftThigh.YVelocity = 5;
      if (Joints.LeftThigh.Y < -45)
	Joints.LeftThigh.YVelocity = 5;
      if (Joints.LeftThigh.Y > 0 && Joints.LeftThigh.YVelocity >= 0)
	{
	  Joints.LeftThigh.YVelocity = 0;
	  Joints.LeftThigh.Y = 0;
	}
    }
}

void Skeleton::
Flatten ()
{
  Joints.LeftThigh.XVelocity = (2 * (Joints.LeftThigh.X < 0) - 1) * 5;
  Joints.LeftShin.XVelocity = (2 * (Joints.LeftShin.X < 0) - 1) * 5;
  Joints.RightThigh.XVelocity = (2 * (Joints.RightThigh.X < 0) - 1) * 5;
  Joints.RightShin.XVelocity = (2 * (Joints.RightShin.X < 0) - 1) * 5;
}

void Skeleton::
PushOffGround ()
{
  if (Joints.Hip.X > 0 /*&&Hip.XVelocity>0 */ )
    {
      if (Joints.Hip.XVelocity > 0)
	{
	  Joints.Hip.XVelocity-=5;
	  if (Joints.Hip.XVelocity<0)
	    Joints.Hip.XVelocity=0;
	  //	  Hip.XVelocity -= 10;
	  if (Joints.LeftLowerArm.X<50)
	    {
	     Joints.LeftLowerArm.XVelocity = 10;
       	     Joints.RightLowerArm.XVelocity = 10;
	    }
	  else
	    {
	     Joints.LeftLowerArm.XVelocity = -5;
       	     Joints.RightLowerArm.XVelocity = -5;
	    }
	}
       else if (Joints.Hip.XVelocity<=0)
      	{
	  if (Joints.LeftLowerArm.X<=0)
	   Joints.Hip.XVelocity = -20;  // -30 is too fast..
	  Joints.LeftLowerArm.XVelocity = -15;
	  Joints.RightLowerArm.XVelocity = -15;
	}
    }
  else if (Joints.Hip.X < 0 /*&&Hip.XVelocity<0 */ )
    if (Joints.Hip.XVelocity < 0)
      {
	Joints.Hip.XVelocity += 5;
	if (Joints.Hip.XVelocity>0)
	    Joints.Hip.XVelocity=0;
	  //	  Hip.XVelocity -= 10;
	if (Joints.LeftLowerArm.X<50)
	  {
	    Joints.LeftLowerArm.XVelocity = 10;
	    Joints.RightLowerArm.XVelocity = 10;
	  }
	else
	  {
	     Joints.LeftLowerArm.XVelocity = -5;
       	     Joints.RightLowerArm.XVelocity = -5;
	  }
      }
    else if (Joints.Hip.XVelocity>=0)
      {
	if (Joints.LeftLowerArm.X<=0)
          Joints.Hip.XVelocity = 20;  // 30 is too fast...
       //	Hip.XVelocity += 10;
	Joints.LeftLowerArm.XVelocity = -15;
	Joints.RightLowerArm.XVelocity = -15;
      }

  if (Joints.Hip.Y > 0 /*&&Hip.YVelocity>0 */ )
    {
      Joints.Hip.YVelocity = -20; //-30
      //                         LeftLowerArm.XVelocity=-5;
      Joints.RightLowerArm.XVelocity = 5;
    }
  else if (Joints.Hip.Y < 0 /*&&Hip.YVelocity<0 */ )
    {
      Joints.Hip.YVelocity = 20; //30
      Joints.LeftLowerArm.XVelocity = 5;
//                      RightLowerArm.XVelocity=-5;
    }


}


void Skeleton::
Stop ()
{
  StopAnimation.Animate(Joints);
  /*
  Joints.Torso.ZVelocity = 0;
  Joints.Torso.Z = 0;
  Joints.Neck.ZVelocity = 0;
  Joints.Neck.Z = 0;

//   if (Hip.Z < 90)
//     {
//       Hip.ZVelocity = 10;
//     }
//   else
  Joints.Hip.ZVelocity = 0;
/* if (AppendageOnGround!=0)
   {
   LeftThigh.XVelocity=((2*(LeftThigh.X<0))-1)*10;
   if (abs(LeftThigh.X)<10)
   {
   LeftThigh.X=0;
   LeftThigh.XVelocity=0;
   }
   LeftShin.XVelocity=-5;
   if (abs(Hip.XVelocity)<10)
   {
   Hip.XVelocity=0;
   if (abs(Hip.X)<15)
   Hip.X=0;
   //                   Torso.X=0;
   //                   Neck.X=0;
   }
   }
   else
   if (AppendageOnGround!=1)
   {
   RightThigh.XVelocity=((2*(RightThigh.X<0))-1)*10;
   if (abs(RightThigh.X)<10)
   {
   RightThigh.X=0;
   RightThigh.XVelocity=0;
   }
   RightShin.XVelocity=-5;
   if (abs(Hip.XVelocity)<10)
   {
   Hip.XVelocity=0;
   if (Hip.X>15)
   Hip.X=0;
   else if (Hip.X<15)
   Hip.X=0;
   else if (Hip.X<-15)
   Hip.XVelocity=5;
   else if (Hip.X>15)
   Hip.XVelocity=-5;
   //                   Torso.X=0;
   //                   Neck.X=0;
   }
   }
   //???
   //   LeftUpperArm.XVelocity=((2*(LeftUpperArm.X>-20))-1)*10;
   // RightUpperArm.XVelocity=((2*(RightUpperArm.X>-20))-1)*10;
   if (abs(RightThigh.X)<10)
   {
   RightThigh.X=0;
   RightShin.XVelocity=5;
   RightThigh.XVelocity=0;
   }
   if (abs(LeftThigh.X)<10)
   {
   LeftThigh.X=0;
   LeftShin.XVelocity=5;
   LeftThigh.XVelocity=0;
   }
 */
  /*  Joints.RightShin.XVelocity=10;
  Joints.LeftShin.XVelocity=10;
  if (Joints.LeftThigh.X > 0)
    Joints.LeftThigh.XVelocity = -8;
  else if (Joints.LeftThigh.X < 0)
    {
      Joints.LeftThigh.XVelocity = 5;
//              LeftShin.XVelocity=-10;
    }
  else
    Joints.LeftThigh.XVelocity = 0;

  if (Joints.RightThigh.X > 0)
    Joints.RightThigh.XVelocity = -8;
  else if (Joints.RightThigh.X < 0)
    {
      Joints.RightThigh.XVelocity = 5;
      //             RightShin.XVelocity=-10;
    }
  else
    Joints.RightThigh.XVelocity = 0;

  if (abs (Joints.LeftThigh.X) < 10)
    {
      Joints.LeftThigh.XVelocity = 0;
      Joints.LeftThigh.X = 0;
      Joints.LeftShin.XVelocity = 20;
    }
  if (abs (Joints.RightThigh.X) < 10)
    {
      Joints.RightThigh.XVelocity = 0;
      Joints.RightThigh.X = 0;
      Joints.RightShin.XVelocity = 20;
    }
  if (abs (Joints.Hip.X) < 10)
    {
      Joints.Hip.XVelocity = 0;
      Joints.Hip.X = 0;
    }
*/
}


void Skeleton::
Shoot (/*int Extent*/)
{
 ShootAnimation.Animate(Joints);
  /*  if (Extent > 5 && Joints.RightUpperArm.X > -180)
    {
      Joints.RightUpperArm.XVelocity = -10;
      Joints.RightLowerArm.XVelocity = 10;
      Joints.RightLowerArm.YVelocity = 10;
      Joints.RightHand.ZVelocity = 20;
      Joints.LeftUpperArm.X = 20;
      Joints.LeftLowerArm.XVelocity = 10;
      Joints.LeftLowerArm.YVelocity = 10;
    }
  else if ((Extent > 1 && Joints.RightUpperArm.X < 0) || (Joints.RightUpperArm.X < -180))
    {
      Joints.RightUpperArm.XVelocity = 10;
      Joints.RightLowerArm.XVelocity = -10;
      Joints.RightLowerArm.YVelocity = 10;
      Joints.RightHand.ZVelocity = -20;
      Joints.LeftUpperArm.X = 0;
      Joints.LeftLowerArm.XVelocity = -10;
      Joints.LeftLowerArm.YVelocity = -10;
    }
  else
    {
      Joints.RightUpperArm.XVelocity = 0;
      Joints.RightHand.ZVelocity = 0;
      Joints.RightHand.Z = 90;
    }
  */
}


void Skeleton::
Walk (Point hip, Body * b/*, int Shooting*/)
{

  double ThighAngle = Joints.LeftThigh.X;
  double ShinAngle = Joints.LeftShin.X;

  if (Joints.Hip.Z > 0)
    Joints.Hip.ZVelocity = -15;
  else
    Joints.Hip.ZVelocity = 0;


  AppendageOnGround = DoPhysics (b);

  // If not walking already, but moving, start the legs in motion
  if (abs (Joints.LeftThigh.XVelocity) < 5 && abs (Joints.RightThigh.XVelocity) < 5 && (sqrt (sqr (hip.XVelocity) + sqr (hip.YVelocity)) > 0 || abs (Joints.Hip.X) >= 15 || abs (Joints.Hip.Y) >= 15))
    StartWalking ();

  // Determine the leg which is currently carrying the weight
  if (DistanceFromGround (Joints.LeftThigh.X, Joints.LeftShin.X, b, Joints.LeftThigh.Y) <
      DistanceFromGround (Joints.RightThigh.X, Joints.RightShin.X, b, Joints.RightThigh.Y))
    {
      ThighAngle = Joints.RightThigh.X;
      ShinAngle = Joints.RightShin.X;
    }

  // Determine the distance covered in the x and y directions
  // by the leg which is carring weight.
  double realthighangle = (Joints.Hip.X * pi / 180) + (ThighAngle * pi / 180);
  double y1 = (b->LeftThigh.GetLength () / (b->LeftShin.GetLength () + b->LeftThigh.GetLength ()) * 180) * cos (realthighangle);
  double y2 = (b->LeftShin.GetLength () / (b->LeftShin.GetLength () + b->LeftThigh.GetLength ()) * 180) * cos ((-ShinAngle * pi / 180) - (realthighangle));
  double y = (y1 + y2);

  double x1 = (b->LeftThigh.GetLength () / (b->LeftShin.GetLength () + b->LeftThigh.GetLength ()) * 180) * sin (realthighangle);
  double x2 = (b->LeftShin.GetLength () / (b->LeftShin.GetLength () + b->LeftThigh.GetLength ()) * 180) * sin ((-ShinAngle * pi / 180) - (realthighangle));
  double x = -x1 + x2;

  // Place the legs depending on the positions of the others
  if (x > 0)			//The leg on the ground is behind the center of gravity

    {
      if (Joints.Hip.X < -10 && Joints.Hip.XVelocity < 0 && Joints.Hip.X > -45)
	Joints.Hip.XVelocity += 5;	// compensate for forward drifting

      if (Joints.Hip.X > 5 && Joints.Hip.XVelocity > 0 && Joints.Hip.XVelocity < 35)
	Joints.Hip.XVelocity = 0;	// Use muscles to stop any momentum from a light hit

      CheckLeadThighAngle (b);	// Move the legs depending on the thigh in front's angle

    }
  else if (x < 0)
    // the leg on the ground is in front of the center of gravity
    {
      if (Joints.Hip.X > -5 && Joints.Hip.XVelocity > -5 && Joints.Hip.X < 45)
	Joints.Hip.XVelocity += -5;	// Compensate (with muscles) for backward drifting if necessary

      if (Joints.Hip.X < -5 && Joints.Hip.XVelocity < 0 && Joints.Hip.XVelocity > -35)
	Joints.Hip.XVelocity = 0;	// use muscles to sustain light hits

      CheckTrailThighAngle (b);	// Move the legs depending on the thigh in back's angle

    }
  Joints.ConstrainUpperPointX (Joints.LeftThigh, 90);
  Joints.ConstrainUpperPointX (Joints.RightThigh, 90);
  Joints.ConstrainLowerPointX (Joints.LeftShin, -110);
  Joints.ConstrainLowerPointX (Joints.RightShin, -110);

  if (Joints.LeftThigh.X > 80)
    Joints.LeftShin.XVelocity = 10;
  if (Joints.RightThigh.X > 80)
    Joints.RightShin.XVelocity = 10;

  //  if (!Shooting)
    MoveArms ();
    //  else
    //    Shoot (Shooting);
  if (Joints.Torso.Z > 10)
    Joints.Torso.ZVelocity = -5;
  else if (Joints.Torso.Z < -10)
    Joints.Torso.ZVelocity = 5;
// Torso.ZVelocity=LeftThigh.XVelocity/4;
  Joints.Neck.ZVelocity = -Joints.Torso.ZVelocity;

  if (AppendageOnGround > 1)
    PushOffGround ();

  BalanceLaterally ();

// if (Hip.X>90||Hip.X<-90)
  //      Flatten();

  Joints.LeftHand.X = Joints.LeftLowerArm.X;	// Keeps the stick somewhat flat

  EnforceRigidity ();

}

void Skeleton::
Move ()
{
 Joints.Move();  
}

int Skeleton::
DoPhysics (Body * b)
{
  // Perform physics as specified in the paper...
  double ThighAngle = Joints.LeftThigh.X;
  double ShinAngle = Joints.LeftShin.X;
  double ThighYAngle = Joints.LeftShin.Y;
  int AppendageOnGround = 0;
  if (DistanceFromGround (Joints.LeftThigh.X, Joints.LeftShin.X, b, Joints.LeftThigh.Y) <
      DistanceFromGround (Joints.RightThigh.X, Joints.RightShin.X, b, Joints.RightThigh.Y))
    {
      ThighAngle = Joints.RightThigh.X;
      ShinAngle = Joints.RightShin.X;
      ThighYAngle = Joints.RightShin.Y;
      AppendageOnGround = 1;
    }
  double realthighangle = (Joints.Hip.X * pi / 180) + (ThighAngle * pi / 180);
  double y1 = (b->LeftThigh.GetLength () / (b->LeftShin.GetLength () + b->LeftThigh.GetLength ()) * 180) * cos (realthighangle);
  double y2 = (b->LeftShin.GetLength () / (b->LeftShin.GetLength () + b->LeftThigh.GetLength ()) * 180) * cos ((-ShinAngle * pi / 180) - (realthighangle));
  double y = (y1 + y2);
  double x1 = (b->LeftThigh.GetLength () / (b->LeftShin.GetLength () + b->LeftThigh.GetLength ()) * 180) * sin (realthighangle);
  double x2 = (b->LeftShin.GetLength () / (b->LeftShin.GetLength () + b->LeftThigh.GetLength ()) * 180) * sin ((-ShinAngle * pi / 180) - (realthighangle));
  double x = -x1 + x2;

//      if (realthighangle<0)
  //              x=-x;

  double LegY = /*(b->LeftThigh.GetLength()+b->LeftShin.GetLength())- */ DistanceFromGround (ThighAngle, ShinAngle, b, ThighYAngle);
// double ShoulderY=LegY+(b->Torso.GetLength()*cos(abs(Hip.X)*pi/180));

  double ShoulderY = ((b->Torso.GetLength () + b->Hip.GetLength ()) * cos (abs (Joints.Hip.X) * pi / 180) * cos (abs (Joints.Hip.Y) * pi / 180));

  double temp = DistanceFromGround (Joints.LeftUpperArm.X, Joints.LeftLowerArm.X, b, Joints.LeftUpperArm.Y);
  double temp2 = DistanceFromGround (Joints.RightUpperArm.X, Joints.RightLowerArm.X, b, Joints.RightUpperArm.Y);
  double ArmY = temp;
  if (temp2 > temp)
    ArmY = temp2;

//      double ArmY=DistanceFromGround(LeftUpperArm.X,LeftLowerArm.X,b->UpperArm.GetLength(),b->LowerArm.GetLength(),LeftThigh.Y);//@@@
  ArmY = /*(b->Torso.GetLength()+HipLength+LegY) */ ShoulderY - (ArmY);

  if (-ArmY < LegY)		//A leg is on the ground

    {
      if (x > 0)
//              Hip.XVelocity+=-.1;//.08;
	Joints.Hip.XVelocity += -2;	//.08; //.2

      else if (x < 0)
//      Hip.XVelocity+=.1;//.08;
	Joints.Hip.XVelocity += 2;	//.08; //.2

      else
	Joints.Hip.XVelocity = 0;
    }
  else if (-ArmY > LegY)	//An arm is on the ground

    {
      if (ArmY == ShoulderY - temp)
	AppendageOnGround = 2;
      else
	AppendageOnGround = 3;
      if (Joints.Hip.X > 0)
	Joints.Hip.XVelocity+=-2;
	//	Hip.XVelocity += -.2;
      else if (Joints.Hip.X < 0)
	Joints.Hip.XVelocity+=2;
	//	Hip.XVelocity += .2;
//              if (Hip.XVelocity<0)
      //                      Hip.XVelocity=-4*Hip.XVelocity;

    }

//Hip Y movement
  if (-Joints.Hip.Y + ThighYAngle < 0 && -Joints.Hip.Y + ThighAngle > -90)
//              Hip.YVelocity+=.1;
    Joints.Hip.YVelocity += 2;
  else if (-Joints.Hip.Y + ThighYAngle > 0 && -Joints.Hip.Y + ThighAngle < 90)
//              Hip.YVelocity+=-.1;
    Joints.Hip.YVelocity += -2;
  else
    Joints.Hip.YVelocity = 0;

  // if (LeftThigh.X+abs(Hip.X)>180)
  //              LeftThigh.XVelocity=-10;

// if (RightThigh.X+abs(Hip.X)>180)
  //       RightThigh.XVelocity=-10;


//      if (y<0)                
  return AppendageOnGround;	//ArmY;//ArmY-((b->LeftThigh.GetLength()+b->LeftShin.GetLength())-LegY);//(b->LeftThigh.GetLength()+b->LeftShin.GetLength())-LegY;

}

double Skeleton::
DistanceFromGround (double ThighAngle, double ShinAngle,
		    Body * b,
		    double ThighYAngle)
{
  double realthighangle = (Joints.Hip.X * pi / 180) + (ThighAngle * pi / 180);
  double realthighyangle = (Joints.Hip.Y * pi / 180) + (ThighYAngle * pi / 180);
  double y1 = b->LeftThigh.GetLength () * cos (realthighangle);
  double y2 = b->LeftShin.GetLength () * cos ((-ShinAngle * pi / 180) - (realthighangle));
  if (y2 < 0)
    y2 = 0;
  double y = (y1 + y2) * cos (realthighyangle);
  if (y < 0)
    y = 0;
  return y;
}

double Skeleton::
LeftLegDistanceFromGround (Body * b)
{
  return DistanceFromGround (Joints.LeftThigh.X, Joints.LeftShin.X, b, Joints.LeftThigh.Y);
}

double Skeleton::
RightLegDistanceFromGround (Body * b)
{
  return DistanceFromGround (Joints.RightThigh.X, Joints.RightShin.X, b, Joints.RightThigh.Y);
}

double Skeleton::
GetMaxDistance (Body * b)
{
  double maxdistance = LeftLegDistanceFromGround (b);
  double temp = RightLegDistanceFromGround (b);
  if (temp > maxdistance)
    maxdistance = temp;
  double LegY = maxdistance;
  maxdistance = (b->LeftThigh.GetLength () + b->LeftShin.GetLength ()) - maxdistance;

  temp = DistanceFromGround (Joints.LeftUpperArm.X, Joints.LeftLowerArm.X, b, Joints.LeftUpperArm.Y);
  double temp2 = DistanceFromGround (Joints.RightUpperArm.X, Joints.RightLowerArm.X, b, Joints.RightUpperArm.Y);
  double ArmY = temp;
  if (temp2 > temp)
    ArmY = temp2;
  double ShoulderY = /*LegY+ */ ((b->Torso.GetLength () + b->Hip.GetLength ()) * cos (abs (Joints.Hip.X) * pi / 180) * cos (abs (Joints.Hip.Y * pi / 180)));
// double ArmY=DistanceFromGround(LeftUpperArm.X,LeftLowerArm.X,b->LeftUpperArm.GetLength(),b->LeftLowerArm.GetLength(),LeftThigh.Y);//@@@
  ArmY = ShoulderY - ArmY;
  if (-ArmY > LegY)
    {
      maxdistance = b->LeftUpperArm.GetLength () + b->RightUpperArm.GetLength () + ArmY;
    }

  double TorsoY = ((b->Torso.GetLength () + b->Neck.GetLength () + b->Head.GetLength ()) * cos (Joints.Hip.X * pi / 180) * cos (Joints.Hip.Y * pi / 180));
  if (LegY < 0)
    LegY = 0;

  if ((b->Hip.GetLength () + b->Torso.GetLength () +
       b->Neck.GetLength () + b->Head.GetLength ()) -
      abs (TorsoY) < maxdistance)
    maxdistance = (b->Hip.GetLength () + b->Torso.GetLength () +
		   b->Neck.GetLength () + b->Head.GetLength ()) -
      abs (TorsoY);
  return maxdistance;
}

bool Skeleton::Stopped(Point hip)
{
  if (abs(hip.X/*Velocity*/ - OldHip.X/*Velocity*/) < 1 &&
      abs(hip.Y/*Velocity*/ - OldHip.Y/*Velocity*/) < 1 &&
     abs(Joints.Hip.X) <=10 &&
     abs(Joints.Hip.Y) <=10)
  return true;
 return false;
  //  return ((sqrt (sqr (hip.XVelocity) + sqr (hip.YVelocity)) < 1 || sqrt (sqr (hip.XVelocity) + sqr (hip.YVelocity)) < OldHipSpeed - 1) && abs (Joints.Hip.X) < 10 && abs (Joints.Hip.Y) < 10);
}

bool Skeleton::Stopping(Point hip)
{
  if (abs(sqrt (sqr (hip.XVelocity) + sqr (hip.YVelocity)) - sqrt (sqr (OldHip.XVelocity) + sqr (OldHip.YVelocity)))>3)
  return true;
 return false;
  //  return ((sqrt (sqr (hip.XVelocity) + sqr (hip.YVelocity)) < 1 || sqrt (sqr (hip.XVelocity) + sqr (hip.YVelocity)) < OldHipSpeed - 1) && abs (Joints.Hip.X) < 10 && abs (Joints.Hip.Y) < 10);
}

void Skeleton::Stand()
{
 StandAnimation.Animate(Joints);
 /* Joints.EnforceRigidity(1);
 Joints.ConstrainUpperPointX (Joints.LeftThigh, 90);
 Joints.ConstrainUpperPointX (Joints.RightThigh, 90);
 Joints.ConstrainLowerPointX (Joints.LeftShin, -110);
 Joints.ConstrainLowerPointX (Joints.RightShin, -110);
 */
} 

void Skeleton::Animate(Point hip, Body *b, int Shooting)
{
 if (Shooting)
 {
  StopAnimation.Reset();
  StandAnimation.Reset();
  Shoot();
  //  cout<<"Shooting"<<endl;
 }
 else if (Stopping(hip))
 {  
  ShootAnimation.Reset();
  StandAnimation.Reset();
  Stop();
  //  cout<<"Stopping"<<endl;
 }
 else if (Stopped(hip))
 {  
  ShootAnimation.Reset();
  StopAnimation.Reset();
  Stand();
  //  cout<<"Stopped"<<endl;
 }
 else
 {
  ShootAnimation.Reset();
  StopAnimation.Reset();
  StandAnimation.Reset();
  Joints.Torso.XVelocity = 0;
  Joints.Neck.XVelocity = 0;
  Joints.Head.XVelocity = 0;
  Joints.LeftUpperArm.YVelocity = 0;
  Joints.RightUpperArm.YVelocity = 0;
  //  Joints.Stick.ZVelocity = 0;
  Joints.Torso.X = -20;
  Joints.Torso.ZVelocity = 5;
  Joints.Neck.X = 20;
  Walk(hip, b);
  if (Joints.Hip.Z > 5)
   Joints.Hip.ZVelocity = -(Joints.Hip.Z / 2);
  else if (Joints.Hip.Z < -5)
   Joints.Hip.ZVelocity = -(Joints.Hip.Z / 2);
  else
  {
   Joints.Hip.Z = 0;
   Joints.Hip.ZVelocity = 0;
  }
  //  cout<<"Walking"<<endl;
 }
 OldHip = hip;
 // OldHipSpeed = sqrt (sqr (hip.XVelocity) + sqr (hip.YVelocity));
}
