// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#ifndef SKELETON
#define SKELETON

#include "Point.h"
#include "BodyPart.h"
#include "Body.h"
#include "JointAngles.h"
#include "KeyFrameAnimation.h"

class Skeleton
{
  public:
  Skeleton ();
  friend ostream &operator<<(ostream &o, Skeleton &s);
  friend ostream &operator>>(ostream &o, Skeleton &s);
  void Move ();
  void MoveTowards(Skeleton &s);
  void Animate (Point hip, Body * b, int Shooting);
  void Walk (Point hip, Body * b);
  void EnforceRigidity ();
  double GetMaxDistance (Body * b);
  int DoPhysics (Body * b);
  JointAngles Joints;
  private:
  Point OldHip;
  KeyFrameAnimation StandAnimation, StopAnimation, ShootAnimation;
  void Shoot (/*int Extent*/);
  int AppendageOnGround;
  int FallingForward ();
  int FallingBackward ();
  int FallingLeft ();
  int FallingRight ();
  int LeaningForward ();
  int LeaningBackward ();
  int LeaningLeft ();
  int LeaningRight ();
  int LeftFootOnGround ();
  int RightFootOnGround ();
  int LeftHandOnGround ();
  int RightHandOnGround ();

  double LeftLegDistanceFromGround (Body * b);
  double RightLegDistanceFromGround (Body * b);
  double DistanceFromGround (double ThighAngle, double ShinAngle, Body * b, double ThighYAngle);

  void StartWalking ();
  void CheckLeadThighAngle (Body * b);
  void CheckTrailThighAngle (Body * b);
  void MoveArms ();
  void BalanceLaterally ();
  void Flatten ();
  void PushOffGround ();
  void Stop ();
  bool Stopped(Point hip);
  bool Stopping(Point hip);
  void Stand();
};

#endif
