#include <iostream>
#include "SoundEffect.h"

#ifndef USEMFC
#include <sys/ioctl.h>
#include <sys/soundcard.h>
#include <unistd.h>
#include <sys/fcntl.h>
#endif

using namespace std;

SoundEffect::SoundEffect()
{
 Data = NULL; 
 CurrentLocation = 0;
 Looped = false;
 Done = false;
}

SoundEffect::SoundEffect(const char *filename, bool looped)
{
 Load(filename);
 CurrentLocation = 0;
 Looped = looped;
 Done = false;
}

bool SoundEffect::Load(const char *filename)
{
#ifndef USEMFC
  // cout<<"Loading "<<filename<<endl;
 if ((FileHandle = open(filename, O_RDONLY))== -1)
   cout<<"Sound freakout!  Can't open "<<filename<<"..."<<endl;
 unsigned char temp[4096];
 int cur = read(FileHandle, temp, 4096);
 int total = cur;
 while (cur != 0)
 {
  cur = read(FileHandle, temp, 4096);
  total += cur;
 }
 close(FileHandle);
 Data = new unsigned char[total - 50];
 if ((FileHandle = open(filename, O_RDONLY))== -1)
   cout<<"Sound freakout!  Can't open "<<filename<<"..."<<endl;
 read(FileHandle, Data, 50);
 read(FileHandle, Data, total - 50);
 close(FileHandle);
 DataSize = total - 50;
 CurrentLocation = 0;
 Done = false;
#endif
 return true;
}

int SoundEffect::GetNextChunk(int numbytes, unsigned char *&buf)
{
 if (Done)
  return -1;
 else 
  buf = &Data[CurrentLocation];
 if (CurrentLocation + numbytes < DataSize)
 {
  CurrentLocation += numbytes;
  return numbytes;
 }
 else
 {
  int temp = DataSize - CurrentLocation;
  CurrentLocation = 0;
  if (!Looped) 
   Done = true;
  return temp;
 }
 return 0; 
}

void SoundEffect::Reset()
{
 CurrentLocation = 0;
 Done = false;
}
