#ifndef SOUNDEFFECT_H
#define SOUNDEFFECT_H

class SoundEffect
{
 public:
  SoundEffect(); 
  SoundEffect(const char *filename, bool looped);
  bool Load(const char *filename);
  int SetLooped(bool looped);
  int GetNextChunk(int numbytes, unsigned char *&buf);
  void Reset();
 protected:
  bool Looped;
  bool Done;
  unsigned char* Data;
  int CurrentLocation;
  int DataSize;
  int FileHandle;
};
#endif
