// Hockey Simulator
// Copyright (C) 1998-1999  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.

#include "SoundEffectsManager.h"
#include "SoundEffect.h"
#ifndef USEMFC

SoundEffectsManager::SoundEffectsManager()
{
 Speed = 22025; //11025;  // 22025
 BufferLength = 0;
 CurrentID = -1;
 for (int x = 0; x < BUFFER_SIZE; x++)
  Buffer[x] = 0;
 if ((DeviceHandle = open("/dev/dsp", O_WRONLY, 0))==-1)
 {
  cout<<"Couldn't open /dev/dsp! :( "<<endl;
  exit(1);
 }
 cout<<"Done."<<endl;
 if (ioctl(DeviceHandle, SNDCTL_DSP_SPEED, &Speed)== -1)
 {
  cout<<"22 khz sounds not supported (?) ! :(";
  exit(1);
 }
 // int bufferparam = 0x7fff0007;
 int bufferparam = 0x00100008;
 if (ioctl(DeviceHandle, SNDCTL_DSP_SETFRAGMENT, &bufferparam)==-1)
   cout<<"Error setting fragment size :( "<<endl; //set fragment size
 for (int x=0; x<BUFFER_SIZE; x++)
  ZeroBuffer[x] = 0;
}

bool SoundEffectsManager::LoadSound(const char *filename, int ID, bool looped)
{
 Effects[ID] = new SoundEffect(filename, looped);
}

bool SoundEffectsManager::PlaySound(int ID)
{
 for (int x=0; x<ActiveEffects.size();x++)
  if (ActiveEffects[x] == ID)
   return false;
 ActiveEffects.push_back(ID);
 return true;
}

bool SoundEffectsManager::StopSound(int ID)
{
 Effects[ActiveEffects[ID]]->Reset();
 ActiveEffects.erase(&ActiveEffects[ID]);
}

void SoundEffectsManager::Tick()
{
 if (PowerIsOn == 0)
  return;
 memcpy(Buffer, ZeroBuffer, BUFFER_SIZE);
 BufferLength = 0; //BUFFER_SIZE;
 audio_buf_info info;
 ioctl(DeviceHandle, SNDCTL_DSP_GETOSPACE, &info);
 int bytestowrite = BUFFER_SIZE;
 if (info.bytes < BUFFER_SIZE)
  bytestowrite = info.bytes;
 int numeffects = ActiveEffects.size();
 int i = 0;
 while (i < ActiveEffects.size() && ActiveEffects.size() == numeffects)
 {
  unsigned char *effectdata;
  int numbytes = Effects[ActiveEffects[i]]->GetNextChunk(bytestowrite, effectdata);
  if (numbytes != -1)
  {
   if (numbytes > BufferLength)
    BufferLength = numbytes;
   for (int x = 0; x < numbytes; x++)
   {
     Buffer[x] = effectdata[x]; /// ActiveEffects.size();
   }
  }
  else
  {
   Effects[ActiveEffects[i]]->Reset();
   ActiveEffects.erase(&ActiveEffects[i]);
  }
  i++;
 } 
 
 // if (numeffects == 2 && ActiveEffects.size() == 1)
 // {
     //     cout<<"-----------------------------"<<endl;
//  int value = Buffer[0];
//  int counter = 0; 
 //   for (int x = 1; x<BufferLength; x++)   
//  {
//   if (Buffer[x] == value)
//    counter++;
//   else
//   {
//    value = Buffer[x];
//    counter = 0;
//   }
//   if (counter > 10)
//   {
//     cout<<"Pop! value = "<<value<<endl;
//     for (int y = x - counter; y<x; y++)
//      Buffer[x]+=rand()%10;
//   }
//  } 
  //   if (Buffer[x] == Buffer[x-1] || Buffer[x] == Buffer[x-2])
   //   cout<<Buffer[x];
  //     cout<<"-----------------------------"<<endl;
 //   }    
 //+=rand()%5+1;
 // for (int x = BufferLength - 50; x < BufferLength; x++)
 //  Buffer[x] = 100;
 // cout<<"Buffer[0]="<<(int)Buffer[0]<<endl;
 // cout<<"Buffer[size]="<<(int)Buffer[BufferLength-1]<<endl;
 if (BufferLength != 0)
 {
   write(DeviceHandle, Buffer, BufferLength);
  //  cout<<"Writing "<<BufferLength<<" bytes"<<endl;
 }
}

void SoundEffectsManager::SetPowerSwitch(int OnOff)
{
 PowerIsOn = OnOff;
}
#endif