#include <map>
#include <vector>
#include "SoundEffect.h"
#ifndef USEMFC
#include <sys/ioctl.h>
#include <sys/soundcard.h>
#include <unistd.h>
#include <sys/fcntl.h>
#endif

using namespace std;

#ifndef SOUNDEFFECTSMANAGER_H
#define SOUNDEFFECTSMANAGER_H

const int BUFFER_SIZE=4096;

class SoundEffectsManager
{
 public: 
  SoundEffectsManager();
  bool LoadSound(const char *filename, int ID, bool looped);
  bool PlaySound(int ID);
  bool StopSound(int ID);
  void Tick();
  void SetPowerSwitch(int OnOff);
 protected:
  int PowerIsOn;
  int DeviceHandle;
  int Speed;
  unsigned char Buffer[BUFFER_SIZE];
  unsigned char ZeroBuffer[BUFFER_SIZE];
  int BufferLength;
  int CurrentID;
//  map<int, SoundEffect*> Effects;
//  vector<int> ActiveEffects;
};

#endif
