#include "SprayParticle.h"
#include <stdlib.h>
#include <iostream>
#include <math.h>
using namespace std;

SprayParticle::SprayParticle()
{
}

SprayParticle::SprayParticle(Point &InitialPoint)
{
 Location=InitialPoint;
 Location.Z=.5;
 Location.XVelocity=InitialPoint.XVelocity/5+(((rand()%3-rand()%3))/2);
 Location.YVelocity=InitialPoint.YVelocity/5+(((rand()%3-rand()%3))/2);
 Location.ZVelocity=rand()%3+1;
}

void SprayParticle::Act()
{
  // cerr<<"Particle is acting..."<<endl;
 Location.Move();
 Location.ZVelocity-=1;
 // cerr<<"Done acting..."<<endl;
}

void SprayParticle::Draw()
{
 glColor3f(.8,.8,.8);
 glBegin(GL_TRIANGLES);
  glVertex3f(Location.X-2, Location.Y-2, Location.Z-2);  
  glVertex3f(Location.X-2, Location.Y+2, Location.Z+2);
  glVertex3f(Location.X+2, Location.Y, Location.Z-2);
  glVertex3f(Location.X+2, Location.Y, Location.Z-2);
  glVertex3f(Location.X-2, Location.Y+2, Location.Z+2);
  glVertex3f(Location.X-2, Location.Y-2, Location.Z-2);  
 glEnd();
}

bool SprayParticle::IsDead()
{
 if (Location.Z<0)
  return true;
 return false;
}

bool SprayParticle::operator==(const SprayParticle &rhs)
{
 return (fabs(Location.X-rhs.Location.X)<.001&&
	     fabs(Location.Y-rhs.Location.Y)<.001&&
		 fabs(Location.Z-rhs.Location.Z)<.001);
}

bool SprayParticle::operator!=(const SprayParticle &rhs)
{
 return (fabs(Location.X-rhs.Location.X)>=.001||
	     fabs(Location.Y-rhs.Location.Y)>=.001||
		 fabs(Location.Z-rhs.Location.Z)>=.001);
}
