#include "Tiff.h"
#include <fstream>
#include <math.h>
#include <stdlib.h>
#include <iostream>

using namespace std;
// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


// The bulk of this code is dictated by the 
// Windows bitmap standard...

Tiff::Tiff ()
{
  Init ();
}

Tiff::Tiff (const char *filename)
{
  Init ();
  Load (filename);
}

Tiff::~Tiff ()
{
//  delete[]Raster;
//  delete[]Texture;
}

void Tiff::
Init ()
{
  Width = 0;
  Height = 0;
  Raster = NULL;
  Texture = NULL;
  Image = NULL;
}

void Tiff::
Load (const char *filename)
{
  // cout<<"Loading "<<filename<<endl;
 Handle = TIFFOpen(filename, "r");
 Image = new TIFFRGBAImage;
 tsize_t size;
 if (Handle == NULL) 
 {
  cout<<"Big problems loading "<<filename<<endl;
  exit(1);
 }
 char error[1024];
 if (TIFFRGBAImageBegin(Image, Handle, 0, error))
 {
  size = (tsize_t) (Image->width * Image->height);
  Raster = (uint32*) _TIFFmalloc(size * (tsize_t) sizeof(uint32));
  if (Raster != NULL)
  {
   if (TIFFRGBAImageGet(Image, Raster, Image->width, Image->height) == 0)
   {
    TIFFError(filename, error);
    exit(1);
   }
  }
  TIFFRGBAImageEnd(Image);
 }
 else
 {
  TIFFError(filename, error);
  exit(1);
 }
 // cout<<"Got ABGR image"<<endl;
 /* for (int i = 0; i < size; i++) 
 {
  register unsigned char *cp = (unsigned char *) &Raster[i];
  int t;

  t = cp[3];
  cp[3] = cp[0];
  cp[0] = t;
  t = cp[2];
  cp[2] = cp[1];
  cp[1] = t;
  }*/
 // cout<<"Made it into an RGBA..."<<endl;
 glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

 Width = 1 << (int) ceil(log(Image->width) / log(2.0));
 Height = 1 << (int) ceil(log(Image->height) / log(2.0));
 if (Width > 512)
   Width = 512;
 if (Height > 512)
   Height = 512;
 Texture = new uint32[Width*Height];
 // cout<<"Visiting raster..."<<endl;
 for (int x = 0; x < Image->width * Image->height; x++)
  Texture[x] = Raster[x];

 // if (Image->width != Width || Image->height != Height) 
 // { 
 //  cout<<"Scaling to "<<Width<<" x "<<Height<<endl;
 //  gluScaleImage(GL_RGBA,
 //    (GLsizei) Image->width, (GLsizei) Image->height, GL_UNSIGNED_BYTE, Raster,
 //     Width, Height, GL_UNSIGNED_BYTE, Texture);
  // }
 // cout<<"Done.  Freeing raster..."<<endl;
  _TIFFfree(Raster);
  //  cout<<"Done."<<endl;
}

uint32 *Tiff::
GetGLTexture ()
{
  // cout<<"Sending back the texture"<<endl;
 uint32* t = new uint32[Width * Height];
 for (int x = 0; x < Width * Height; x ++)
 {
  t[x] = Texture[x];
 }
 return t;
}

void Tiff::
CopyBits (Tiff & b, int tops, int lefts, int topd, int leftd, int length, int width, int reverse)
{
 return;
 /*  int factor = 1;
  if (reverse)
    factor = -1;
  int ld = leftd;		//0;

  if (reverse)
    ld = leftd + width;
  int td = Height - topd;
  int ls = lefts;
  int ts = b.Height - tops;

//      debug<<"Colors="<<b.Colors<<endl;
  // debug<<endl;
  // debug.close();
  for (int y = 0; y < width; y++)
    for (int x = 0; x < length; x++)
      Data[(ld + (factor * x)) + (Width * (td - y))] = b.Data[(ls + x) + (b.Width * (ts - y))];
 */
}
