// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#include <math.h>
#include "Utils.h"
#include <fstream>
using namespace std;


double 
angle (double x, double y)
{
  double pi = 3.1415926;
  //fstream debug("debug.txt",ios::app);
  if (x == 0 && y == 0)
    return 3.1415926 / 2;
  if (x == 0 && y > 0)
    return 0;
  else if (x == 0 && y < 0)
    return 3 * 3.1415926 / 2;
  double a = atan (abs (y) / abs (x));
  if (y < 0 && x > 0)
    a = 2 * pi - a;
  if (y > 0 && x < 0)
    a = pi - a;
  if (y < 0 && x < 0)
    a = a + pi;


//      if (y<0)
  //              a+=3.1415926;
  //      if ((y<0&&x>0)||
  //                 (y>0&&x<0))
  //              a+=3.1415926/2;
  //debug<<"x="<<x<<"  y="<<y<<"  a="<<a<<endl;
  //debug.close();
  return a;
}

double 
abs (double x)
{
  if (x >= 0)
    return x;
  else
    return 0 - x;
}


double 
sqr (double n)
{
  return n * n;
}

double 
Distance (double X1, double Y1, double X2, double Y2)
//Cartesian distance between two points
{
  return sqrt (sqr (X1 - X2) + sqr (Y1 - Y2));
}

double 
avg (double a, double b)
//totally misnamed.  Actually returns the max
{
  if (a > b)
    return a;
  return b;
// return (a+b)/2;
}

int 
Normalize (int &var)
{
  if (var < 0)
    var = 0;
  else if (var > 100)
    var = 100;
  return var;
}


void 
Box (double left, double top, double height, double right, double bottom, double min)
{
  glBegin (GL_QUADS);
  glVertex3f (left, top, height);	//front

  glVertex3f (right, top, height);
  glVertex3f (right, top, min);
  glVertex3f (left, top, min);

  glVertex3f (left, bottom, min);
  glVertex3f (right, bottom, min);
  glVertex3f (right, bottom, height);
  glVertex3f (left, bottom, height);	//back

  glVertex3f (left, bottom, height);	//left side

  glVertex3f (left, bottom, min);
  glVertex3f (left, top, min);
  glVertex3f (left, top, height);

  glVertex3f (right, bottom, min);
  glVertex3f (right, top, min);
  glVertex3f (right, top, height);
  glVertex3f (right, bottom, height);	//right side

  glVertex3f (left, bottom, height);
  glVertex3f (right, bottom, height);
  glVertex3f (right, top, height);
  glVertex3f (left, top, height);	//top


  glVertex3f (left, top, min);	//bottom

  glVertex3f (right, top, min);
  glVertex3f (right, bottom, min);
  glVertex3f (left, bottom, min);


  glEnd ();
}

void 
TRectangle (double x, double y, double z, double length, double width)
{
  glBegin (GL_QUADS);
  glTexCoord2f (0, 0);
  glVertex3f (x, y, z);		//front

  glTexCoord2f (1, 0);
  glVertex3f (x + length, y, z);
  glTexCoord2f (1, 1);
  glVertex3f (x + length, y, z + width);
  glTexCoord2f (0, 1);
  glVertex3f (x, y, z + width);
  glEnd ();
}

int 
ReadInt (fstream & f)
{
  char bytes[4];
  for (int x = 0; x < 4; x++)
    f.get (bytes[x]);
  int value = *(int *) bytes;
  return value;
}

double 
ReadDouble (fstream & f)
{
  char bytes[8];
  for (int x = 0; x < 8; x++)
    f.get (bytes[x]);
  double *dblptr = (double *) bytes;
  double value = *dblptr;
  return value;
}
