#include "Vector.h"
#include "Point.h"
#include <math.h>
#include "Utility.h"

Vector::Vector()
{
 X=0;
 Y=0;
 Z=0;
}

Vector::Vector(double x, double y, double z)
{
 X=x;
 Y=y;
 Z=z;
}

Vector::Vector(const Vector &v)
{
 X=v.X;
 Y=v.Y;
 Z=v.Z;
}

const Vector& Vector::operator=(const Vector &rhs)
{
 X=rhs.X;
 Y=rhs.Y;
 Z=rhs.Z;
 return *this;
}

ostream &operator<<(ostream &o, const Vector &v)
{
 o<<"("<<v.X<<", "<<v.Y<<", "<<v.Z<<")";
 return o;
}

istream &operator>>(istream &i, Vector &v)
{
 i>>v.X>>v.Y>>v.Z;
 return i;
}

bool Vector::operator==(const Vector &rhs)
{
 if (X==rhs.X && Y==rhs.Y && Z==rhs.Z)
  return true;
 return false;
}

const Vector& Vector::operator+=(const Vector &rhs)
{
 X+=rhs.X;
 Y+=rhs.Y;
 Z+=rhs.Z;
 return *this;
}

const Vector& Vector::operator-=(const Vector &rhs)
{
 X-=rhs.X;
 Y-=rhs.Y;
 Z-=rhs.Z;
 return *this;
}

const Vector& Vector::operator*=(const Vector &rhs)
{
 X=(Y*rhs.Z)-(Z*rhs.Y);
 Y+=(Z*rhs.X)-(X*rhs.Z);
 Z+=(X*rhs.Y)-(Y*rhs.X);
 return *this;
}

Vector operator+(const Vector &lhs, const Vector &rhs)
{
 Vector answer;
 answer.X=lhs.X + rhs.X;
 answer.Y=lhs.Y + rhs.Y;
 answer.Z=lhs.Z + rhs.Z;
 return answer;
}

Vector operator-(const Vector &lhs, const Vector &rhs)
{
 Vector answer;
 answer.X=lhs.X - rhs.X;
 answer.Y=lhs.Y - rhs.Y;
 answer.Z=lhs.Z - rhs.Z;
 return answer;
}

Vector operator*(const Vector &lhs, const Vector &rhs)
{
 Vector answer;
 answer.X=(lhs.Y*rhs.Z)-(lhs.Z*rhs.Y);
 answer.Y=(lhs.Z*rhs.X)-(lhs.X*rhs.Z);
 answer.Z=(lhs.X*rhs.Y)-(lhs.Y*rhs.X);
 return answer;
}

const Vector& Vector::operator+=(const double &rhs)
{
 X+=rhs;
 Y+=rhs;
 Z+=rhs;
 return *this;
}

const Vector& Vector::operator-=(const double &rhs)
{
 X-=rhs;
 Y-=rhs;
 Z-=rhs;
 return *this;
}

const Vector& Vector::operator*=(const double &rhs)
{
 X*=rhs;
 Y*=rhs;
 Z*=rhs;
 return *this;
}

const Vector& Vector::operator/=(const double &rhs)
{
 X/=rhs;
 Y/=rhs;
 Z/=rhs;
 return *this;
}

Vector operator+(const double &rhs, const Vector &lhs)
{
 Vector answer;
 answer.X=lhs.X + rhs;
 answer.Y=lhs.Y + rhs;
 answer.Z=lhs.Z + rhs;
 return answer;
}

Vector operator-(const Vector &lhs, const double &rhs)
{
 Vector answer;
 answer.X=lhs.X - rhs;
 answer.Y=lhs.Y - rhs;
 answer.Z=lhs.Z - rhs;
 return answer;
}

Vector operator-(const double &rhs, const Vector &lhs)
{
 Vector answer;
 answer.X=lhs.X - rhs;
 answer.Y=lhs.Y - rhs;
 answer.Z=lhs.Z - rhs;
 return answer;
}

Vector operator*(const Vector &lhs, const double &rhs)
{
 Vector answer;
 answer.X=lhs.X * rhs;
 answer.Y=lhs.Y * rhs;
 answer.Z=lhs.Z * rhs;
 return answer;
}

Vector operator*(const double &rhs, const Vector &lhs)
{
 Vector answer;
 answer.X=lhs.X * rhs;
 answer.Y=lhs.Y * rhs;
 answer.Z=lhs.Z * rhs;
 return answer;
}

Vector operator/(const Vector &lhs, const double &rhs)
{
 Vector answer;
 answer.X=lhs.X / rhs;
 answer.Y=lhs.Y / rhs;
 answer.Z=lhs.Z / rhs;
 return answer;
}

Vector operator/(const double &rhs, const Vector &lhs)
{
 Vector answer;
 answer.X=lhs.X / rhs;
 answer.Y=lhs.Y / rhs;
 answer.Z=lhs.Z / rhs;
 return answer;
}

double Vector::GetX()
{
 return X;
}

double Vector::GetY()
{
 return Y;
}

double Vector::GetZ()
{
 return Z;
}

void Vector::Reduce(double destlength)
{
 double total = (GetLength() / destlength);
  // double total = X + Y + Z;
 if (fabs(total) < .00001)
  return;
 X /= total;
 Y /= total;
 Z /= total;
}

void Vector::ReduceY(double destlength)
{
 double total = (fabs(Y) / destlength);
  // double total = X + Y + Z;
 if (fabs(total) < .00001)
  return;
 X /= total;
 Y /= total;
 Z /= total;
}

double Vector::GetLength()
{
 return sqrt(X * X + Y * Y + Z * Z);
}

void Vector::RemoveRedundancy(Vector v)
{
 if (SameSign(X, v.X))
  X -= v.X;
 if (SameSign(Y, v.Y))
  Y -= v.Y;
 if (SameSign(Z, v.Z))
  Z -= v.Z;
}

void Vector::Normal(Vector p, Vector q, Vector r)
{
 X = (q.Y - p.Y) * (r.Z - p.Z) - (q.Z - p.Z) * (r.Y - p.Y); 
 Y = (q.Z - p.Z) * (r.X - p.X) - (q.X - p.X) * (r.Z - p.Z);
 Z = (q.X - p.X) * (r.Z - p.Z) - (q.Z - p.Z) * (r.X - p.X);
}

bool Vector::IsBetween(Vector a, Vector b)
{
 if ((a.X > b.X && (X > a.X || X < b.X)) ||
     (a.X < b.X && (X < a.X || X > b.X)))
  return false;
 if ((a.Y > b.Y && (Y > a.Y || Y < b.Y)) ||
     (a.Y < b.Y && (Y < a.Y || Y > b.Y)))
  return false;
 if ((a.Z > b.Z && (Z > a.Z || Z < b.Z)) ||
     (a.Z < b.Z && (Z < a.Z || Z > b.Z)))
  return false;
 return true;
}

bool Vector::IsCollinear(Vector before, Vector after)
{
 Vector direction = after - before;
 Vector temp = after - *this; 
 direction.Reduce();
 temp.Reduce();
 if (direction == temp) 
  return true;
 return false;
}
