#include <iostream>

using namespace std;

#ifndef VECTOR_H
#define VECTOR_H

class Vector
{
 public:
  Vector();
  Vector(double x, double y, double z);
  Vector(const Vector &v);
  const Vector &operator=(const Vector &rhs);
  friend ostream &operator<<(ostream &o, const Vector &v); 
  friend istream &operator>>(istream &i, Vector &v);
  bool operator==(const Vector &rhs);

  //Vector op Vector
  const Vector& operator+=(const Vector &rhs);
  const Vector& operator-=(const Vector &rhs);
  const Vector& operator*=(const Vector &rhs);
  friend Vector operator+(const Vector &lhs, const Vector &rhs);
  friend Vector operator-(const Vector &lhs, const Vector &rhs);
  friend Vector operator*(const Vector &lhs, const Vector &rhs);

  //Vector op Scalar
  const Vector& operator+=(const double &rhs);
  const Vector& operator-=(const double &rhs);
  const Vector& operator*=(const double &rhs);
  const Vector& operator/=(const double &rhs);
  friend Vector operator+(const Vector &lhs, const double &rhs);
  friend Vector operator+(const double &rhs, const Vector &lhs);
  friend Vector operator-(const Vector &lhs, const double &rhs);
  friend Vector operator-(const double &rhs, const Vector &lhs);
  friend Vector operator*(const Vector &lhs, const double &rhs);
  friend Vector operator*(const double &rhs, const Vector &lhs);
  friend Vector operator/(const Vector &lhs, const double &rhs);
  friend Vector operator/(const double &rhs, const Vector &lhs);

  //Other functions
  double GetX();
  double GetY();
  double GetZ();
  void Reduce(double destlength = 1); // Make the length of the vector destlength
  void ReduceY(double destlength = 1); // Make Y destlength
  double GetLength();
  void RemoveRedundancy(Vector v);
  void Normal(Vector p, Vector q, Vector r);
  bool IsBetween(Vector a, Vector b);
  bool IsCollinear(Vector before, Vector after);
  // protected:
  double X, Y, Z;
};

#endif
