// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


// WinGLView.cpp : implementation of the CWinGLView class
//

#include "stdafx.h"
#include "WinGL.h"
#include <fstream>
//#include <glut.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "mainfrm.h"
#include <math.h>

#include "point.h"
#include "coachdialog.h"
#include "controldialog.h"

#include "WinGLDoc.h"
#include "WinGLView.h"

using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinGLView

IMPLEMENT_DYNCREATE(CWinGLView, CView)

BEGIN_MESSAGE_MAP(CWinGLView, CView)
	//{{AFX_MSG_MAP(CWinGLView)
	ON_WM_TIMER()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_COMMAND(ID_VIEW_PRESSBOX, OnPressbox)
	ON_COMMAND(ID_VIEW_34OVERHEAD, On34Overhead)
	ON_COMMAND(ID_VIEW_DIRECTOVERHEAD, OnDirectOverhead)
	ON_COMMAND(ID_VIEW_PUCKMODE, OnPuckMode)
	ON_COMMAND(ID_VIEW_HOMEGOALIECAM, OnHomeGoalieCam)
	ON_COMMAND(ID_HOMECOACH, OnHomecoach)
	ON_COMMAND(ID_VISITORCOACH, OnVisitorcoach)
	ON_COMMAND(ID_HOMECONTROL, OnHomeControl)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_WM_DESTROY()
	ON_COMMAND(ID_HELP, OnHelp)
 ON_COMMAND(ID_ICETEXTURES, OnIceTextures)
	ON_COMMAND(ID_PLAYERTEXTURES, OnPlayerTextures)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_COMMAND(ID_VIEW_ZOOMEDOVERHEAD, OnZoomedOverhead)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinGLView construction/destruction

CWinGLView::CWinGLView()
{
 Keys.down=0;
	Keys.up=0;
	Keys.left=0;
	Keys.right=0;
	Keys.shoot=0;
	Keys.pass=0;
	Keys.linechange=0;
	Keys.dump=0;
	Keys.nextplayer=0;
 Camera=0;
	ViewAngle=35;
	ScreenShotNumber = 0;
 WindowWidth=512;
 WindowHeight=480;
}

CWinGLView::~CWinGLView()
{
}

BOOL CWinGLView::PreCreateWindow(CREATESTRUCT& cs)
{

 cs.style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN;


	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CWinGLView drawing

void CWinGLView::OnDraw(CDC* pDC)
{
//	CWinGLDoc* pDoc = GetDocument();
//	ASSERT_VALID(pDoc);
 DrawScene();
}

/////////////////////////////////////////////////////////////////////////////
// CWinGLView printing

BOOL CWinGLView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CWinGLView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CWinGLView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CWinGLView diagnostics

#ifdef _DEBUG
void CWinGLView::AssertValid() const
{
	CView::AssertValid();
}

void CWinGLView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CWinGLDoc* CWinGLView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWinGLDoc)));
	return (CWinGLDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinGLView message handlers

void CWinGLView::DrawScene()
{
	CWinGLDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	glClearColor(.3f,.3f,.3f,1.0f);
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
 glLoadIdentity();
	Point g=pDoc->MrGame->GetHomeGoalieCoordinates();
	switch (Camera)
	{
  case 5:
   if (pDoc->MrGame->GetPuckX()<length/4)
    gluLookAt(length/4,width/2+1,400,length/4,width/2,0,0,0,1);
   else if (pDoc->MrGame->GetPuckX()>length-length/4)
    gluLookAt(length-length/4,width/2+1,400,length-length/4,width/2,0,0,0,1);
   else
    gluLookAt(pDoc->MrGame->GetPuckX(),width/2+1,400,pDoc->MrGame->GetPuckX(),width/2,0,0,0,1);
   break;
 	case 4:
   gluLookAt(g.X,g.Y,25,pDoc->MrGame->GetPuckX(),pDoc->MrGame->GetPuckY(),pDoc->MrGame->GetPuckZ(),0,0,1);
			break;
 	case 3:
   gluLookAt(length/2,width/2+1,550,length/2,width/2,0,0,0,1);
			break;
	 case 2:
   gluLookAt(pDoc->MrGame->GetPuckX(),pDoc->MrGame->GetPuckY(),pDoc->MrGame->GetPuckZ()+8,pDoc->MrGame->GetPuckX()+(pDoc->MrGame->GetPuckXVelocity()*5),pDoc->MrGame->GetPuckY()+(pDoc->MrGame->GetPuckYVelocity()*5),pDoc->MrGame->GetPuckZ(),0,0,1);
			break;
  case 1:

   if (pDoc->MrGame->GetPuckX()>length-length/4)
   	gluLookAt(length/2,width/2,175,length-length/4,width/2,0,0,0,1);
   else
   if (pDoc->MrGame->GetPuckX()<length/8)
   	gluLookAt(-length/8,width/2,175,length/8,width/2,0,0,0,1);
			else
   	gluLookAt(pDoc->MrGame->GetPuckX()-length/4,width/2,175,pDoc->MrGame->GetPuckX(),width/2,0,0,0,1);
   break;
  case 0:
			 int v=sqrt(sqr(pDoc->MrGame->GetPuckXVelocity()/2)+
					          sqr(pDoc->MrGame->GetPuckYVelocity()/2));
				if (35+v>ViewAngle)
					ViewAngle++;
				else if (35+v<ViewAngle)
					ViewAngle--;
//				glMatrixMode(GL_PROJECTION);
//   	glLoadIdentity();
//	   gluPerspective(ViewAngle,(GLdouble)512.0/480.0f,1,length);
//    glMatrixMode(GL_MODELVIEW);
  	if (pDoc->MrGame->GetPuckX()<length/4)
   	gluLookAt(length/2,width+75,125,length/4,width*3/5,0,0,0,1);
   else if (pDoc->MrGame->GetPuckX()>length-length/4)
   	gluLookAt(length/2,width+75,125,length-length/4,width*3/5,0,0,0,1);
   else
   	gluLookAt(length/2,width+75,125,pDoc->MrGame->GetPuckX(),width*3/5,0,0,0,1);
   break;
	}


	/*	if (pDoc->MrGame->GetPuckX()<length/4)
 	gluLookAt(length/2,width+200,150,length/4,0,0,0,0,1);
 else if (pDoc->MrGame->GetPuckX()>length-length/4)
 	gluLookAt(length/2,width+200,150,length-length/4,0,0,0,0,1);
 else
 	gluLookAt(length/2,width+200,150,pDoc->MrGame->GetPuckX(),0,0,0,0,1);
*/
 pDoc->MrGame->Play(&Keys);

	SwapBuffers(wglGetCurrentDC());
}

void CWinGLView::OnTimer(UINT nIDEvent) 
{
	DrawScene();
 CMainFrame *parent=(CMainFrame*)GetParent();
	CWinGLDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
//	char buf1[10];
//	char buf2[30];
//	m_pDC->SetBkMode(TRANSPARENT);
// itoa(pDoc->MrGame->GetHomeScore(),buf1,10);
//	strcpy(buf2,"Home ");
//	strcat(buf2,buf1);
//	m_pDC->TextOut(0,0,"blah",strlen("blah"));
// itoa(pDoc->MrGame->GetVisitorScore(),buf1,10);
//	strcat(buf2,", Visitor ");
//	strcat(buf2,buf1);
//	m_pDC->TextOut(100,0,"blah",strlen("blah"));
 parent->m_wndStatusBar.SetWindowText(pDoc->MrGame->GetStatusBarText());
 parent->m_wndStatusBar.SetPaneText(2,pDoc->MrGame->GetTimeText());
 
	CView::OnTimer(nIDEvent);
}


BOOL CWinGLView::bSetupPixelFormat()
{
    static PIXELFORMATDESCRIPTOR pfd =
    {
        sizeof(PIXELFORMATDESCRIPTOR),  // size of this pfd
        1,                              // version number
        PFD_DRAW_TO_WINDOW |            // support window
          PFD_SUPPORT_OPENGL |          // support OpenGL
          PFD_DOUBLEBUFFER,             // double buffered
        PFD_TYPE_RGBA,                  // RGBA type
        16,                             // 24-bit color depth
        0, 0, 0, 0, 0, 0,               // color bits ignored
        0,                              // no alpha buffer
        0,                              // shift bit ignored
        0,                              // no accumulation buffer
        0, 0, 0, 0,                     // accum bits ignored
        16,                             // 16-bit z-buffer
        0,                              // no stencil buffer
        0,                              // no auxiliary buffer
        PFD_MAIN_PLANE,                 // main layer
        0,                              // reserved
        0, 0, 0                         // layer masks ignored
    };

    int     pixelformat;

    if ( (pixelformat = ChoosePixelFormat(m_pDC->GetSafeHdc(), &pfd)) == 0 )
    {
        MessageBox("ChoosePixelFormat failed");
        return FALSE;
    }

    if (SetPixelFormat(m_pDC->GetSafeHdc(), pixelformat, &pfd) == FALSE)
    {
        MessageBox("SetPixelFormat failed");
        return FALSE;
    }

    return TRUE;
}

void CWinGLView::OnDestroy() 
{
    HGLRC   hrc;

//    if (m_nTimerID)
//        KillTimer(m_nTimerID);

	hrc	 = ::wglGetCurrentContext();

    ::wglMakeCurrent(NULL,  NULL);

    if (hrc)
        ::wglDeleteContext(hrc);

    CPalette    palDefault;


    if (m_pDC)
        delete m_pDC;

    CView::OnDestroy();
}



int CWinGLView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;

	Init();
	return 0;
}

void CWinGLView::Init()
{
 PIXELFORMATDESCRIPTOR pfd;
 int n;
	HGLRC hrc;

 m_pDC = new CClientDC(this);

 ASSERT(m_pDC != NULL);

 if (!bSetupPixelFormat())
    return;

 n = ::GetPixelFormat(m_pDC->GetSafeHdc());
 ::DescribePixelFormat(m_pDC->GetSafeHdc(), n, sizeof(pfd), &pfd);
	
    // create a rendering context and make it current
        
 hrc = wglCreateContext(m_pDC->GetSafeHdc());
 wglMakeCurrent(m_pDC->GetSafeHdc(), hrc);
 
 GetClientRect(&m_oldRect);
 glClearDepth(1.0f);
	glEnable(GL_DEPTH_TEST);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f,(GLdouble)512.0/480.0f,1,length);
 glMatrixMode(GL_MODELVIEW);
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	CWinGLDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
 pDoc->MrGame->Init();

	VERIFY(SetTimer(1,50, NULL) != 0);
}

void CWinGLView::OnSize(UINT nType, int cx, int cy) 
{
	WindowWidth = cx;
	WindowHeight = cy;
	CView::OnSize(nType, cx, cy);
//	MessageBox("Sizing","!!",MB_OK);
    if (cy > 0)
    {    
        glViewport(0, 0, cx, cy);

        if ((m_oldRect.right > cx) || (m_oldRect.bottom > cy))
            if (RedrawWindow()==0)
													MessageBox("!!!","Big Trouble!",MB_OK);

								m_oldRect.right = cx;
        m_oldRect.bottom = cy;
 
     glMatrixMode(GL_PROJECTION);
     glLoadIdentity();
    	gluPerspective(45.0f,(GLdouble)cx/cy,1,length+200);
     glMatrixMode(GL_MODELVIEW);

    }	
}

void CWinGLView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CWinGLDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	char filename[20];
 switch (nChar)
	{
	 case 'F':
			if (Camera==0||Camera==3)
				Keys.right=1;
			else
				Keys.up=1;
			break;
	 case 'D':
			if (Camera==0||Camera==3)
				Keys.down=1; 
			else
				Keys.right=1;
			break;
		case 'S':
			if (Camera==0||Camera==3)
				Keys.left=1;
			else
				Keys.down=1;
			break;
		case 'E':
						if (Camera==0||Camera==3)
				Keys.up=1;
			else
				Keys.left=1;
			break;
		case ' ':Keys.shoot=1; break;
		case 'J':Keys.pass=1; break;
  case 'K':Keys.dump=1; break;
  case 'L':if (Keys.nextplayer==0)
			Keys.nextplayer=1;
	       else Keys.nextplayer=2;
	   	   break;
  case '1':Camera=0; break;
  case '2':Camera=1; break;
  case '3':Camera=2; break;
  case '4':Camera=3; break;
  case '5':Camera=4; break;
  case '6':Camera=5; break;
  case 'P':
   sprintf(filename, "mhockey%03d.tif", ScreenShotNumber++);
   pDoc->MrGame->WriteTiff(filename,"mHockey Screenshot", 0, 0, WindowWidth, WindowHeight, COMPRESSION_LZW);
   break;

  case 27: 
			AfxGetMainWnd()->PostMessage(WM_CLOSE);
			//delete pDoc->MrGame;
			//pDoc->MrGame=NULL;
			//exit(0);
			break;
  case '0':
				if (pDoc->MrGame->HomeControl.PuckHog==-1)
				{
     pDoc->MrGame->HomeControl.PuckHog=1;
					pDoc->MrGame->HomeControl.Player=1;
					pDoc->MrGame->MrGame->CurrentPlayer=0;
				}
				else
			 {
     pDoc->MrGame->HomeControl.PuckHog=-1;
					pDoc->MrGame->HomeControl.Player=-1;
					pDoc->MrGame->MrGame->CurrentPlayer=-1;
				}
   break;


	}
	//CMainFrame *blah;
	//blah=(CMainFrame*)GetParentFrame();
	//blah->m_wndStatusBar.SetPaneText(0,"Key Down");
	
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}


void CWinGLView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
 switch (nChar)
	{
	 case 'F':
			if (Camera==0||Camera==3)
				Keys.right=0;
			else
				Keys.up=0;
			break;
	 case 'D':
			if (Camera==0||Camera==3)
				Keys.down=0; 
			else
				Keys.right=0;
			break;
		case 'S':
			if (Camera==0||Camera==3)
				Keys.left=0;
			else
				Keys.down=0;
			break;
		case 'E':
						if (Camera==0||Camera==3)
				Keys.up=0;
			else
				Keys.left=0;
			break;
		case ' ':Keys.shoot=0; break;
		case 'J':Keys.pass=0; break;
		case 'K':Keys.dump=0; break;
		case 'L':Keys.nextplayer=0;break;
	}
	
	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}


void CWinGLView::OnHomecoach() 
{
	CWinGLDoc *pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	CCoachDialog *x=new CCoachDialog(&pDoc->MrGame->HomeCoachSettings, pDoc->MrGame->MrGame->Home[0], this);
	x->DoModal();
}

void CWinGLView::OnVisitorcoach() 
{
	CWinGLDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	CCoachDialog *x=new CCoachDialog(&pDoc->MrGame->VisitorCoachSettings, pDoc->MrGame->MrGame->Home[1],this);
	x->DoModal();

}

void CWinGLView::OnHomeControl() 
{
	CWinGLDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	CControlDialog *x=new CControlDialog(&pDoc->MrGame->HomeControl,this);
	x->DoModal();
	
}



void CWinGLView::OnFileNew() 
{
	//KillTimer(1);
	MessageBox("This feature is not yet implemented","Hockey");
}

void CWinGLView::OnFileOpen() 
{
	MessageBox("This feature is not yet implemented","Hockey");
}

void CWinGLView::OnFileSave() 
{
	MessageBox("This feature is not yet implemented","Hockey");
}

void CWinGLView::OnFileSaveAs() 
{
	MessageBox("This feature is not yet implemented","Hockey");
}

void CWinGLView::OnHelp() 
{
	MessageBox("This feature is not yet implemented","Hockey");
}

void CWinGLView::OnPressbox() 
{
	Camera=0;
}

void CWinGLView::On34Overhead() 
{
	Camera=1;
}

void CWinGLView::OnPuckMode() 
{
	Camera=2;
}

void CWinGLView::OnDirectOverhead() 
{
	Camera=3;
}

void CWinGLView::OnHomeGoalieCam() 
{
	Camera=4;
}

void CWinGLView::OnZoomedOverhead() 
{
	Camera=5;
}

void CWinGLView::OnIceTextures() 
{
	CWinGLDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->MrGame->IceTexturesOn=!pDoc->MrGame->IceTexturesOn;
}

void CWinGLView::OnPlayerTextures() 
{
	CWinGLDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->MrGame->PlayerTexturesOn=!pDoc->MrGame->PlayerTexturesOn;
}
