#define QUICKSIM
#include <time.h>
#include <stdlib.h>
#include "Main.h"
#include "Constants.h"
#include <iostream.h>
using namespace std;

void main(int argc, char **argv)
{
	srand((unsigned int)time(NULL));
	KeyData Keys;

  int t1=1, t2=2;
 
  if (argc==3)
    {
      t1=atoi(argv[1]);
      t2=atoi(argv[2]);
    }
  else
    {
    cout<<"You can now pick teams to play by providing their id's as arguments...ie "<<endl;
    cout<<" $ quicksim 1 4 "<<endl;
    }

	GameDriver g(0,t1,t2);
	for (int z=0;z<60*TicksPerMinute;z++)
	{
		if (z%TicksPerMinute==0)
			cout<<"Period "<<z/(20*TicksPerMinute)+1<<".  "<<
			    "Home "<<g.GetHomeScore()<<" ("<<g.GetHomeShots()<<" shots), "<<
							"Visitor "<<g.GetVisitorScore()<<" ("<<g.GetVisitorShots()<<" shots)."<<endl;
		g.Play(&Keys);
	}
	cout<<"Home "<<g.GetHomeScore()<<", Visitor "<<g.GetVisitorScore()<<endl;
	cout<<"Home Strength:  "<<g.GetHomeStrength()<<".  Visitor Strength:  "<<g.GetVisitorStrength()<<endl;
	cout<<"Home Goalie Strength:  "<<g.GetHomeGoalieStrength()<<".  Visitor Strength:  "<<g.GetVisitorGoalieStrength()<<endl;

}
