#include <fstream>
#include <stdlib.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "teamutil.h"
#include "Database.h"

using namespace std;

int ID = 0;

void GeneratePlayer( PLAYER_TYPE &myplayer, int position)
{
        myplayer.ID = ID;       
        ID++;
	myplayer.UniformNumber=ID%100;
        myplayer.CaptainStatus = 0;
        myplayer.HallOfFamePoints = 75;
        myplayer.Age = 20;
        myplayer.Height = rand () % 8 + 72 - rand () % 8;
        myplayer.Weight = rand () % 50 + 175;
        myplayer.YearsInContract = 4;
        myplayer.JuniorLeagueID = 1;
        myplayer.DraftPickNumber = 1;
        myplayer.Intelligence = rand () % 25 + 75;
        myplayer.Attitude = rand () % 25 + 75;
        myplayer.Ego = rand () % 25 + 75;
        myplayer.Discipline = rand () % 25 + 75;
        myplayer.Aggressiveness = rand () % 25 + 75;
        myplayer.SkatingSpeed = rand () % 20 + 80;
        myplayer.Quickness = rand () % 25 + 75;
        myplayer.StickHandling = rand () % 25 + 75;
        myplayer.Passing = rand () % 25 + 75;
        myplayer.PuckControl = rand () % 25 + 75;
        myplayer.Stamina = rand () % 25 + 75;
        myplayer.Durability = rand () % 25 + 75;
        myplayer.FightingAbility = rand () % 25 + 75;
        myplayer.InjuryType = rand () % 25 + 75;
        myplayer.InjuryLength = rand () % 25 + 75;
        myplayer.InjuryVulnerability = rand () % 25 + 75;
        myplayer.ShotPower = rand () % 25 + 75;
        myplayer.ShotAccuracy = rand () % 25 + 75;
        
        if (position == GOALIE)
        {
                myplayer.Glove = rand() % 25 + 75;
                myplayer.Blocker = rand() % 25 + 75;
                myplayer.Stick = rand() % 25 + 75;
                myplayer.Pads = rand() % 25 + 75;
                myplayer.Concentration = rand() % 25 + 75;
        }
        else
                myplayer.Strength = rand() % 25 + 75;
                myplayer.Checking = rand() % 25 + 75;

}

void WriteOut(PLAYER_TYPE myplayer)
{
        cout << "---------------------------------------------------" << endl;
	cout << "Position:  " << myplayer.Position << endl;
        cout << "CaptainStatus: " << myplayer.CaptainStatus << endl;
        cout << "HallOfFamePoints:" <<  myplayer.HallOfFamePoints<< endl;
        cout << "Age: " << myplayer.Age  << endl;
        cout << "Height: " << myplayer.Height  << endl; 
        cout << "Weight: " << myplayer.Weight << endl ;
        cout << "YearsInContract: " << myplayer.YearsInContract << endl;
        cout << "JuniorLeagueID: "<< myplayer.JuniorLeagueID << endl;
        cout << "DraftPickNumber: " << myplayer.DraftPickNumber << endl; 
        cout << "Intelligence: " << myplayer.Intelligence << endl ;
        cout << "Attitude: " << myplayer.Attitude  << endl;
        cout << "Ego: " << myplayer.Ego  << endl;
        cout << "Discipline: " << myplayer.Discipline  << endl;
        cout << "Agressiveness: " << myplayer.Aggressiveness  << endl;
        cout << "SkatingSpeed: " << myplayer.SkatingSpeed  << endl;
        cout << "Quickness: " << myplayer.Quickness  << endl;
        cout << "StickHandling: " << myplayer.StickHandling  << endl;
        cout << "Passing: " << myplayer.Passing  << endl;
        cout << "PuckControl: " << myplayer.PuckControl << endl ;
        cout << "Stamina: " << myplayer.Stamina << endl ;
        cout << "Durability: " << myplayer.Durability  << endl;
        cout << "FightingAbility: " << myplayer.FightingAbility << endl; 
        cout << "InjuryType: " << myplayer.InjuryType  << endl;
        cout << "InjuryLength: " << myplayer.InjuryLength << endl;
        cout << "InjuryVulnerability: " << myplayer.InjuryVulnerability  <<
endl;
        cout << "ShotPower: " << myplayer.ShotPower  << endl;
        cout << "ID: " << myplayer.ID << endl;
        cout << "TeamID: " << myplayer.TeamID << endl;
}


void GenerateTeam(int teamID)
{
        //generate 20 players and 2 goalies 
        char *teamname="players.dat";
        PLAYER_TYPE myp;
	int count = 0;
        // 12 forwards
        for (int i = 0; i < 12; i++ )
        {
       	        GeneratePlayer(myp,i%3/*FORWARD*/);
                myp.Position = i%3;//FORWARD;
		myp.Line = LINE1RW + count;
                myp.TeamID = teamID;
		//		WriteOut(myp);
                WritePlayer("players.dat", myp);
		count++;
        }
        
        // 8 defensemen
	count = 0;
        for (int i = 0; i < 8; i++ )
        {
                GeneratePlayer(myp,i%2+3/*DEFENSE*/);
                myp.Position = i%2+3;//DEFENSE;
		myp.Line = LINE1RD + count;
                myp.TeamID = teamID;
		//		WriteOut(myp);
                WritePlayer("players.dat", myp);
        }
        // 2 goalies
        for (int i=0; i < 2; i++ )
        {
                GeneratePlayer(myp,GOALIE);
                myp.Position = GOALIE;
		//                myp.TeamID = teamID;
                WritePlayer("players.dat", myp);
        }
}


void main(void)
{
  srand((unsigned int)time(NULL));
	GenerateTeam(1);
	GenerateTeam(2);
	GenerateTeam(3);
	GenerateTeam(4);
	GenerateTeam(5);
	GenerateTeam(6);
	 
}
