// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


// WinGLView.h : interface of the CWinGLView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WINGLVIEW_H__75DDFB0C_ABB4_11D1_B9EE_A06AF7491437__INCLUDED_)
#define AFX_WINGLVIEW_H__75DDFB0C_ABB4_11D1_B9EE_A06AF7491437__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "wingldoc.h"

class CWinGLView : public CView
{
protected: // create from serialization only
	CWinGLView();
	KeyData Keys;
	int WindowWidth, WindowHeight;
	int Camera;
	int ViewAngle;
	int ScreenShotNumber;
	DECLARE_DYNCREATE(CWinGLView)
public:
 void DrawScene();
 BOOL bSetupPixelFormat();
	CRect		m_oldRect;
 CClientDC   *m_pDC;
	void Init();
// Attributes
public:
	CWinGLDoc* GetDocument();
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinGLView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CWinGLView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CWinGLView)
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnPressbox();
	afx_msg void On34Overhead();
	afx_msg void OnDirectOverhead();
	afx_msg void OnPuckMode();
	afx_msg void OnHomeGoalieCam();
	afx_msg void OnHomecoach();
	afx_msg void OnVisitorcoach();
	afx_msg void OnHomeControl();
	afx_msg void OnFileNew();
	afx_msg void OnFileOpen();
	afx_msg void OnFileSave();
	afx_msg void OnFileSaveAs();
	afx_msg void OnDestroy();
	afx_msg void OnHelp();
	afx_msg void OnIceTextures();
	afx_msg void OnPlayerTextures();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnZoomedOverhead();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in WinGLView.cpp
inline CWinGLDoc* CWinGLView::GetDocument()
   { return (CWinGLDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINGLVIEW_H__75DDFB0C_ABB4_11D1_B9EE_A06AF7491437__INCLUDED_)
