// Nuke2000 Tutorial 5
// (C)1999-2000 Nuke Software/Odin Jensen
// Demonstrates overlay drawing

// Include N2K_Window header
#include <n2k_window.h>

// Include N2K_3DRender header
#include <n2k_3drender.h>

// Include math header for color conversion
#include <n2k_3dmath.h>

// Create new window component
IN2K_Window *pWindow = NULL; 

// Create new 3D render component
IN2K_3DRender *pRender = NULL;

// A little box to display

// Box indices into vertex list
WORD pBoxIndex[12*3]=
{
	0,2,3, 
	3,1,0,
	4,5,7,
	7,6,4,
	0,1,5,
	5,4,0,
	1,3,7,
	7,5,1,
	3,2,6,
	6,7,3,
	2,0,4,
	4,6,2
};

// The actual vertices of our box
// Will be assigned in our winmain function
N2K_Vertex pBoxVertices[8]; 

// Position matrix of object and camera
CN2K_Matrix ObjPos,Camera;


// X Position of object
float fX=0;

// Z Position of object (Depth)
float fZ=300;

// X Position of overlay 
// (Offset to outside screen for smooth scroll as it's auto-clipped)
int OPosX=-256;

// User defined Update function. 
void Update()
{
	// Begin 3D rendering
	pRender->BeginScene();
	
	// Clear viewport to black
	pRender->ClearViewport(0,0,0);
	
	// Setup object position down and back.
	
	// Reset matrix
	ObjPos.SetIdentity();
	
	// Move matrix
	ObjPos.SetTranslate(0,-30,300);
	
	// Load matrix as world
	pRender->LoadWorldMatrix(&ObjPos);

	// Select texture.
	// Note that the texture cache/manager will not
	// Reselect this texture if already selected, so we can safely call this each frame.
	pRender->MakeTextureCurrent("texture.bmp");
	
	// Render model as triangles.
	pRender->RenderTriangles(pBoxVertices,pBoxIndex,8,12);
		
	// Advance overlay and reset when screen width exceeded
	OPosX++;
	if (OPosX>640) OPosX=-256;
	
	// Render overlay. Note how we strecth the image on the Y axis.
	// That's because the texture is kept square, because some hardware only
	// takes square textures. (Haven't seen that in a while, so it's hopefully dead :)
	pRender->DrawOverlay(OPosX,300,0,-128,"overlay.bmp");
	
	// End 3D rendering
	pRender->EndScene();

	// Update main screen with contents from offscreen buffer.
	pRender->Flip();

	// Old DirectInput 1 keyboard handling :)
	
	// Check for left/right and move along x-axis accordingly.
	if (GetAsyncKeyState(VK_LEFT)) fX-=1.0f;
	if (GetAsyncKeyState(VK_RIGHT)) fX+=1.0f;

	// Check for up/down and move back/forwared accordingly.
	if (GetAsyncKeyState(VK_UP)) fZ+=1;
	else
	if (GetAsyncKeyState(VK_DOWN)) fZ-=1;
	
	// Setup camera position
	
	// Reset matrix
	Camera.SetIdentity();
	
	// Move matrix
	Camera.SetTranslate(fX,0,fZ);
	
	// Load matrix as view
	pRender->LoadViewMatrix(&Camera);		
}

// Windows entry point
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	
	// Initialize COM Library
	CoInitialize(NULL) ;
	
	
	// Try to get window interface
	if (FAILED(N2K_GetWindowInterface(pWindow)))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 Window component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}
	
	// Check if we failed.
	if (FAILED(N2K_Get3DRenderInterface(pRender)))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 3D Render component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		
		// Release window interface
		pWindow->Release();		
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}
		
    // Try to init window. -1,-1 means center at middile of desktop, 640x480 pixel size, visible and title
	// bar with X close button. Call the window Test and we want the default icon.
	if (!pWindow->Init(hInstance,Update,-1,-1,640,480,WS_VISIBLE|WS_SYSMENU,"Test" ,0))
	{
		// COM components have to be released
		pWindow->Release();
		pRender->Release();
	
		// Uninitialize COM Library
		CoUninitialize() ;

		return false;

	}
	
	// Show cursor
	pWindow->ShowCursor(true);
	
	// Init 3D render. Always let z-buffer be 0.0f - 1.0f as real values are set with SetPerspective.
	if (!pRender->Init(pWindow->GetHandle(),640,480, pWindow->GetDesktopBPP(), 16, 0.0f, 1.0f, FALSE))
	{
		// COM components have to be released
		pRender->Release();	
		pWindow->Release();
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}

	// Setup perspective 
	// (Note we use radians, use the N2K_DEG2RAD macro to convert from angles. Also, 45.0f means 90.0f/2 = 90.0f fov)
	// (Z-Buffer goes from 10.0f to 1000.0f. 
	pRender->SetPerspective(N2K_DEG2RAD(45.0f),10.0f,1000.0f);

	// Set fog to same as clipping plane, with a density of 1.0f and a color of black
	pRender->SetupFog(10.0f,1000.0f,1.0f,RGB(0,0,0));
	
	// Turn fog on
	pRender->EnableFog(false);
				
	pBoxVertices[0].x=(float)-20.5021;
	pBoxVertices[0].y=(float)-0.0000;
	pBoxVertices[0].z=(float)-29.7071;
	pBoxVertices[0].color=N2K_BUILDRGBA(1,0,0,1);
	pBoxVertices[0].u=0.0f;
	pBoxVertices[0].v=0.0f;

	
	pBoxVertices[1].x=(float)58.9958;
	pBoxVertices[1].y=(float)-0.0000;
	pBoxVertices[1].z=(float)-29.7071;
	pBoxVertices[1].color=N2K_BUILDRGBA(0,1,0,1);
	pBoxVertices[1].u=0.0f;
	pBoxVertices[1].v=1.0f;


	pBoxVertices[2].x=(float)-20.5021;
	pBoxVertices[2].y=(float)0.0000;
	pBoxVertices[2].z=(float)40.5858;
	pBoxVertices[2].color=N2K_BUILDRGBA(0,0,1,1);
	pBoxVertices[2].u=1.0f;
	pBoxVertices[2].v=0.0f;


	pBoxVertices[3].x=(float)58.9958;
	pBoxVertices[3].y=(float)0.0000;
	pBoxVertices[3].z=(float)40.5858;
	pBoxVertices[3].color=N2K_BUILDRGBA(1,0,0,1);
	pBoxVertices[3].u=1.0f;
	pBoxVertices[3].v=1.0f;


	pBoxVertices[4].x=(float)-20.5021;
	pBoxVertices[4].y=(float)-69.4561;
	pBoxVertices[4].z=(float)-29.7071;
	pBoxVertices[4].color=N2K_BUILDRGBA(0,1,0,1);
	pBoxVertices[4].u=1.0f;
	pBoxVertices[4].v=0.0f;


	pBoxVertices[5].x=(float)58.9958;
	pBoxVertices[5].y=(float)-69.4561;
	pBoxVertices[5].z=(float)-29.7071;
	pBoxVertices[5].color=N2K_BUILDRGBA(0,0,1,1);
	pBoxVertices[5].u=1.0f;
	pBoxVertices[5].v=1.0f;


	pBoxVertices[6].x=(float)-20.5021;
	pBoxVertices[6].y=(float)-69.4561;
	pBoxVertices[6].z=(float)40.5858;
	pBoxVertices[6].color=N2K_BUILDRGBA(1,0,0,1);
	pBoxVertices[6].u=1.0f;
	pBoxVertices[6].v=0.0f;

	
	pBoxVertices[7].x=(float)58.9958;
	pBoxVertices[7].y=(float)-69.4561;
	pBoxVertices[7].z=(float)40.5858;
	pBoxVertices[7].color=N2K_BUILDRGBA(0,1,0,1);
	pBoxVertices[7].u=1.0f;
	pBoxVertices[7].v=1.0f;


	// Create texture cache for 10 textures
	if (!pRender->CreateTextureCache(10))
	{
		pRender->Release();
		pWindow->Release();

		CoUninitialize();

		return FALSE;
	}
		
	// Cache texture.bmp
	if (!pRender->CacheTexture("texture.bmp",0))
	{
		pRender->Release();
		pWindow->Release();

		CoUninitialize();

		return FALSE;
	}	

	// Cache overlay.bmp
	if (!pRender->CacheTexture("overlay.bmp",0))
	{
		pRender->Release();
		pWindow->Release();

		CoUninitialize();

		return FALSE;
	}	

	
	// Do message loop. Don't return until your press escape.
	int iReturnValue=pWindow->DoMessageLoop();
	
	
	// COM components have to be released	
	pRender->Release();	
	pWindow->Release();
	
	// Uninitialize COM Library
	CoUninitialize() ;
	
	// Return message loop return value
	return iReturnValue;
}



