// Nuke2000 Tutorial 2
// (C)1999-2000 Nuke Software/Odin Jensen
// Demonstrates 3D Render setup

// Include N2K_Window header
#include <n2k_window.h>

// Include N2K_3DRender header
#include <n2k_3drender.h>

// Create new window component
IN2K_Window *pWindow = NULL; 

// Create new 3D render component
IN2K_3DRender *pRender = NULL;

// User defined Update function. 
void Update()
{
	// Begin 3D rendering
	pRender->BeginScene();
	
	// Clear screen to blue
	pRender->ClearViewport(0,0,255);
	
	// End 3D rendering
	pRender->EndScene();

	// Update main screen with contents from offscreen buffer.
	pRender->Flip();
}

// Windows entry point
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	
	// Initialize COM Library
	CoInitialize(NULL) ;
				
	// Try to get window interface
	if (FAILED(N2K_GetWindowInterface(pWindow)))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 Window component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}
	
	// Check if we failed.
	if (FAILED(N2K_Get3DRenderInterface(pRender)))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 3D Render component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		
		// Release window interface
		pWindow->Release();		
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}

		
    // Try to init window. -1,-1 means center at middile of desktop, 640x480 pixel size, visible and title
	// bar with X close button. Call the window Test and we want the default icon.
	if (!pWindow->Init(hInstance,Update,-1,-1,640,480,WS_VISIBLE|WS_SYSMENU,"Test" ,0))
	{
		// COM components have to be released
		pWindow->Release();
		pRender->Release();
	
		// Uninitialize COM Library
		CoUninitialize() ;

		return false;

	}
	
	// Show cursor
	pWindow->ShowCursor(true);
	
	// Init 3D render. Always let z-buffer be 0.0f - 1.0f as real values are set with SetPerspective.
	if (!pRender->Init(pWindow->GetHandle(),640,480, pWindow->GetDesktopBPP(), 16, 0.0f, 1.0f, FALSE))
	{
		// COM components have to be released
		pRender->Release();	
		pWindow->Release();
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}

	// Setup perspective 
	// (Note we use radians, use the N2K_DEG2RAD macro to convert from angles. Also, 45.0f means 90.0f/2 = 90.0f fov)
	// (Z-Buffer goes from 10.0f to 1000.0f. 
	pRender->SetPerspective(N2K_DEG2RAD(45.0f),10.0f,1000.0f);

	// Do message loop. Don't return until your press escape.
	int iReturnValue=pWindow->DoMessageLoop();
	
	
	// COM components have to be released	
	pRender->Release();	
	pWindow->Release();
	
	// Uninitialize COM Library
	CoUninitialize() ;
	
	// Return message loop return value
	return iReturnValue;
}



