// Nuke 2000 AppWizard generated 3D template project
// (C)1999-2000 Nuke Software/Odin Jensen

// Include N2K_Window header
#include <n2k_window.h>

// Include N2K_Audio header
#include <n2k_audio.h>

// Include math header
#include <n2k_3dmath.h>

// Create new window component
IN2K_Window *pWindow = NULL; 

// Create audio component
IN2K_Audio *pAudio = NULL;

// Windows size and bitdepth
#define WINDOW_WIDTH 640
#define WINDOW_HEIGHT 480
#define WINDOW_BITDEPTH 16

// Should app run fullscreen?
#define FULLSCREEN false

// Appname
#define APPNAME "Nuke2000 Audio Tutorial"

// Sample id
static int SampleID=0;

// User defined Update function. 
void Update()
{
	static float xpos = -10.0f; // Initial xpos
	static float incr = 0.0002f; //scale this depending on your cpu speed 
	
	// Just like the 3D engine, the 3D sound engine must have a begin/endframe pair.
	pAudio->BeginFrame();

	// Set sample position (Yup. True 3D x,y,z)
	pAudio->SetSamplePosition(SampleID,xpos,0,0);
	
	// Play sample
	pAudio->PlaySample(SampleID,N2K_SOUND_LOOP);

	// Move sample between -10.0f and 10.0f
	xpos += incr;
	if (xpos > 10.0f || xpos < -10.0f)
		incr = -incr;


	// End audio frame (Sound is double buffered :)
	pAudio->EndFrame();
}

// Shutdown function
void Shutdown()
{
	// Release COM interfaces
	if (pAudio) pAudio->Release();
	if (pWindow) pWindow->Release();

	// Uninitialize COM Library
	CoUninitialize();
}

// Windows entry point
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	
	// Initialize COM Library
	CoInitialize(NULL) ;
	
	
	// Call CoCreateInstance with window identifiers and ask for window component and interface.
	HRESULT hr = ::CoCreateInstance(CLSID_N2K_WINDOW1,
	                                NULL, 
	                                CLSCTX_INPROC_SERVER,
	                                IID_N2K_WINDOW, 
	                                (void**)&pWindow) ;
	
	// Check if we failed.
	if (FAILED(hr))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 Window component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		
		Shutdown();

		return FALSE;
	}

	
	if (FAILED(N2K_GetAudioInterface(pAudio)))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 Audio component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		
		Shutdown();

		return FALSE;
	}
    
	// Try to init window. -1,-1 means center at middile of desktop, 640x480 pixel size, visible and title
	// bar with X close button. Call the window Test and we want the default icon.
	if (!pWindow->Init(hInstance,Update,-1,-1,WINDOW_WIDTH,WINDOW_HEIGHT,WS_VISIBLE|WS_SYSMENU,APPNAME ,0))
	{
		MessageBox(GetActiveWindow(),pWindow->GetLastError(),"ERROR",MB_ICONSTOP|MB_OK);		
		
		Shutdown();
				
		return FALSE;		
	}
		
	// Init 3D sound. Normal means, that other applications are allowed to play sound as well :)
	if (!pAudio->Init(N2K_SOUNDMODE_NORMAL,false))
	{
		MessageBox(GetActiveWindow(),pWindow->GetLastError(),"ERROR",MB_ICONSTOP|MB_OK);		
		
		Shutdown();
				
		return FALSE;		
	
	}
	
	// Create sample
	SampleID=pAudio->CreateSample();

	// Load sample
	if (!pAudio->LoadSample(SampleID,"heli.wav"))
	{
		MessageBox(GetActiveWindow(),pWindow->GetLastError(),"ERROR",MB_ICONSTOP|MB_OK);		
		
		Shutdown();
				
		return FALSE;		
	}	

	// Setup listener
	pAudio->SetListener(0,0,0,0,0,0);

	// Do message loop. Don't return until your press escape.
	int iReturnValue=pWindow->DoMessageLoop();
		
	// Shutdown COM objects
	Shutdown();
	
	// Return message loop return value
	return iReturnValue;
}



