// Nuke2000 Tutorial 7
// (C)1999-2000 Nuke Software/Odin Jensen
// Demonstrates loading and displaying N3D objects.

// Include N2K_Window header
#include <n2k_window.h>

// Include N2K_3DRender header
#include <n2k_3drender.h>

// Include N2K_3DEngine header
#include <n2k_3dengine.h>

// Create new window component
IN2K_Window *pWindow = NULL; 

// Create new 3D render component
IN2K_3DRender *pRender = NULL;

// Create new 3D engine component.
IN2K_3DEngine *pEngine = NULL;

// Nuke2000 3D object
CN2K_3DModel Test;

// Position matrix of object and camera
CN2K_Matrix ObjPos,Camera;

// X Position of object
float fX=0;

// Z Position of object (Depth)
float fZ=300;

// User defined Update function. 
void Update()
{
	// Begin 3D rendering
	pRender->BeginScene();
	
	// Clear viewport to black
	pRender->ClearViewport(0,0,0);
		
	// Reset matrix
	ObjPos.SetIdentity();
		
	// Load matrix as world
	pRender->LoadWorldMatrix(&ObjPos);

	// Render object at frame 0 (Only 1 frame supported now, so don't change)
	// Note how DrawModel automatically selects the right texture.
	pEngine->DrawModel(&Test,0);

	// End 3D rendering
	pRender->EndScene();

	// Update main screen with contents from offscreen buffer.
	pRender->Flip();

	// Old DirectInput 1 keyboard handling :)
	
	// Check for left/right and move along x-axis accordingly.
	if (GetAsyncKeyState(VK_LEFT)) fX-=1.0f;
	if (GetAsyncKeyState(VK_RIGHT)) fX+=1.0f;

	// Check for up/down and move back/forwared accordingly.
	if (GetAsyncKeyState(VK_UP)) fZ+=1;
	else
	if (GetAsyncKeyState(VK_DOWN)) fZ-=1;
	
	// Setup camera position
	
	// Reset matrix
	Camera.SetIdentity();
	
	// Move matrix
	Camera.SetTranslate(fX,-10,fZ);
	
	// Load matrix as view
	pRender->LoadViewMatrix(&Camera);		
}

// Windows entry point
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	
	// Initialize COM Library
	CoInitialize(NULL) ;
	
	
	// Try to get window interface
	if (FAILED(N2K_GetWindowInterface(pWindow)))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 Window component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}
	
	// Check if we failed.
	if (FAILED(N2K_Get3DRenderInterface(pRender)))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 3D Render component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		
		// Release window interface
		pWindow->Release();		
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}
	
	// Check if we failed.
	if (FAILED(N2K_Get3DEngineInterface(pEngine)))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 3D Engine component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		
		// Release render interface.
		pRender->Release();
		
		// Release window interface
		pWindow->Release();		
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}


		
    // Try to init window. -1,-1 means center at middile of desktop, 640x480 pixel size, visible and title
	// bar with X close button. Call the window Test and we want the default icon.
	if (!pWindow->Init(hInstance,Update,-1,-1,640,480,WS_VISIBLE|WS_SYSMENU,"Test" ,0))
	{
		// COM components have to be released
		pEngine->Release();
		pWindow->Release();
		pRender->Release();
	
		// Uninitialize COM Library
		CoUninitialize() ;

		return false;

	}
	
	// Show cursor
	pWindow->ShowCursor(true);
	
	// Init 3D render. Always let z-buffer be 0.0f - 1.0f as real values are set with SetPerspective.
	if (!pRender->Init(pWindow->GetHandle(),640,480, pWindow->GetDesktopBPP(), 16, 0.0f, 1.0f, FALSE))
	{
		// COM components have to be released
		pEngine->Release();
		pRender->Release();	
		pWindow->Release();
		
		// Uninitialize COM Library
		CoUninitialize() ;

		return FALSE;
	}

	// Setup perspective 
	// (Note we use radians, use the N2K_DEG2RAD macro to convert from angles. Also, 45.0f means 90.0f/2 = 90.0f fov)
	// (Z-Buffer goes from 10.0f to 1000.0f. 
	pRender->SetPerspective(N2K_DEG2RAD(45.0f),10.0f,1000.0f);

	// Set fog to same as clipping plane, with a density of 1.0f and a color of black
	pRender->SetupFog(10.0f,1000.0f,1.0f,RGB(0,0,0));
	
	// Turn fog on
	pRender->EnableFog(false);

	// Hook 3D engine up to render
	pEngine->HookUp(pRender);
	
	// Try to load 3D model. Notice that 1.0f scales object to it's original size. 
	// Try changing this for different sized object. Notice you multiply each of the objects x,y,z coords with
	// a scale factor.
	if (!pEngine->LoadModel("test.n3d",&Test,1.0f))
	{
		// Show error
		MessageBox(pWindow->GetHandle(),pEngine->GetLastError(),"FATAL ERROR!",MB_ICONSTOP|MB_OK);
		
		pEngine->Release();
		pRender->Release();
		pWindow->Release();

		CoUninitialize();

		return FALSE;
	}
	
	// Create texture cache for 10 textures
	if (!pRender->CreateTextureCache(1))
	{
		pEngine->Release();
		pRender->Release();
		pWindow->Release();

		CoUninitialize();

		return FALSE;
	}
		
	// Cache texture.bmp
	if (!pRender->CacheTexture("texture.bmp",0))
	{
		pEngine->Release();
		pRender->Release();
		pWindow->Release();

		CoUninitialize();

		return FALSE;
	}	

	
	// Do message loop. Don't return until your press escape.
	int iReturnValue=pWindow->DoMessageLoop();
	
	
	// COM components have to be released	
	pEngine->Release();
	pRender->Release();	
	pWindow->Release();
	
	// Uninitialize COM Library
	CoUninitialize() ;
	
	// Return message loop return value
	return iReturnValue;
}



