// Nuke2000 Tutorial 1
// (C)1999-2000 Nuke Software/Odin Jensen
// Demonstrates basic window setup 

// Include N2K_Window header
#include <n2k_window.h>

// Create new window component
IN2K_Window *pWindow = NULL ; 
	

// User defined Update function. Does nothing for now.
void Update()
{
}

// Windows entry point
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	
	// Initialize COM Library
	CoInitialize(NULL) ;
		
	// Try to get window interface
	if (FAILED(N2K_GetWindowInterface(pWindow)))
	{
		MessageBox(GetActiveWindow(),"Nuke2000 Window component not installed!","ERROR",MB_ICONSTOP|MB_OK);
		return FALSE;
	}

    // Try to init window. -1,-1 means center at middile of desktop, 640x480 pixel size, visible and title
	// bar with X close button. Call the window Test and we want the default icon.
	if (!pWindow->Init(hInstance,Update,-1,-1,640,480,WS_VISIBLE|WS_SYSMENU,"Test" ,0))
	{
		// COM components have to be released
		pWindow->Release();
	
		// Uninitialize COM Library
		CoUninitialize() ;

		return false;

	}
	
	// Show cursor
	pWindow->ShowCursor(true);
	
	// Do message loop. Don't return until your press escape.
	int iReturnValue=pWindow->DoMessageLoop();
	
	// COM components have to be released
	pWindow->Release();
	
	// Uninitialize COM Library
	CoUninitialize() ;
	
	// Return message loop return value
	return iReturnValue;
}



