// +---------------------------------------------------------+
// | Nuke2000 library (C)1999-2000 Nuke Software/Odin Jensen |
// | Consult SDK documentation for legal information         |
// +---------------------------------------------------------+


// Make sure we are only included once
#ifndef __N2K_3DENGINE__H__
#define __N2K_3DENGINE__H__

// +--------------------------+
// | Files we need to include |
// +--------------------------+
#include <windows.h>  // All the standard windows types and functions.
#include <objbase.h>  // COM stuff
#include <N2K_3DStructs.h> // Include Nuke 2000 structs
#include <N2K_3DRender.h>

// +-----------------------------------+
// |   Macro to safely release memory  |
// |    Note the uppercase notation    |
// | I use this to recognise constants |
// |     and macros from functions.    |
// +-----------------------------------+
#ifndef SAFE_RELEASE
#define SAFE_RELEASE(x) if (x) {x->Release();x=NULL;}
#endif

// +-----------------------+
// | Interface identifiers |
// +-----------------------+

// N2K_3DEngine component interface.
// Use this to get the main interface.

// {4AA07669-7755-485d-BA93-88A84329DDAF}
static const IID IID_N2K_3DENGINE = 
{ 0x4aa07669, 0x7755, 0x485d, 
{ 0xba, 0x93, 0x88, 0xa8, 0x43, 0x29, 0xdd, 0xaf } };

// N2K_3DEngine main interface.

// {3B63F0E5-383C-4513-9435-1561BFC27A56}
static const CLSID CLSID_N2K_3DENGINE1 = 
{ 0x3b63f0e5, 0x383c, 0x4513, 
{ 0x94, 0x35, 0x15, 0x61, 0xbf, 0xc2, 0x7a, 0x56 } };

// Macro for easy getting the interface
#define N2K_Get3DEngineInterface(x) ::CoCreateInstance(CLSID_N2K_3DENGINE1,NULL, CLSCTX_INPROC_SERVER,IID_N2K_3DENGINE, (void**)&x)

// N2K_Video interface
interface IN2K_3DEngine : IUnknown
{		
	// Hookup 3D Render
	virtual bool HookUp(IN2K_3DRender * pRender)=0;
	
	// Load model
	virtual bool LoadModel(char * pFileName, CN2K_3DModel * pModel, float fScaleFactor)=0;	
	virtual bool LoadNewModel(char * pFileName, CN2K_3DModel * pModel, float fScaleFactor)=0;

	// Get last error
	virtual char * GetLastError()=0;

	// Draw model without scene management
	virtual bool DrawModel(CN2K_3DModel * pModel, int iFrameNum)=0;

	// Spheremap surface
	virtual void ApplySphereMapToSurface(CN2K_Matrix CamMatrix, CN2K_Matrix ObjMatrix,N2K_Vertex * pVertices,DWORD dwNumVertices )=0;
};

#endif