// +---------------------------------------------------------+
// | Nuke2000 library (C)1999-2000 Nuke Software/Odin Jensen |
// | Consult SDK documentation for legal information         |
// +---------------------------------------------------------+


// Make sure we are only included once
#ifndef __N2K_3DMATH_H__
#define __N2K_3DMATH_H__

// Include stuff
#include <windows.h>
#include <math.h>

#ifndef N2K_PI
#define N2K_PI 3.1415926535897932384626433832795f
#endif

// Degree to radian conversion
#ifndef N2K_DEG2RAD
#define N2K_DEG2RAD(x) (float)(x*(2*N2K_PI))/360.0f
#endif

#ifndef N2K_BUILDRGBA
#define N2K_BUILDRGBA(r, g, b, a) \
    (   (((long)((a) * 255)) << 24) | (((long)((r) * 255)) << 16) \
    |   (((long)((g) * 255)) << 8) | (long)((b) * 255) \
    )
#endif

// Matrix Class
class CN2K_Matrix
{
	// Private members used internally by class.
	private:

		
	// Public members accessible by class users.
	public:

		union 
		{
         struct 
		 {
		
			// Matrix fields
			float _11, _12, _13, _14;
			float _21, _22, _23, _24;
			float _31, _32, _33, _34;
			float _41, _42, _43, _44;
		 };
         
		 // Override to access members directly
		 float m[4][4];
		};
    
		// Direct Access operators    
		float& operator()(int iRow, int iColumn) { return m[iRow][iColumn]; }
		const float& operator()(int iRow, int iColumn) const { return m[iRow][iColumn]; }
	
		// Constructor
		CN2K_Matrix()
		{
			SetIdentity();
		}

		// Destructor
		~CN2K_Matrix()
		{
		}

		// Set matrix to identity
		inline void SetIdentity()
		{
			_12 = _13 = _14 = _21 = _23 = _24 = 0.0f;
			_31 = _32 = _34 = _41 = _42 = _43 = 0.0f;
			_11 = _22 = _33 = _44 = 1.0f;
		}

		// Translate matrix
		inline void SetTranslate(float fX, float fY, float fZ)
		{
			SetIdentity();
			_41 = fX; 
			_42 = fY; 
			_43 = fZ; 
		}

		// Rotate about X axis
		inline void SetRotateX(float fAngle)
		{
			SetIdentity();
			_22 =  (float)cos(fAngle);
			_23 =  (float)sin(fAngle);
		    _32 = -(float)sin(fAngle);
			_33 =  (float)cos(fAngle);
		}

		// Rotate about Y axis
		inline void SetRotateY(float fAngle)
		{
			SetIdentity();
			_11 =  (float)cos(fAngle);
			_13 = -(float)sin(fAngle);
			_31 =  (float)sin(fAngle);
			_33 =  (float)cos(fAngle);
		}

		// Rotate about Z axis
		inline void SetRotateZ(float fAngle)
		{
		    SetIdentity();
		    _11  =  (float)cos(fAngle);
			_12  =  (float)sin(fAngle);
			_21  = -(float)sin(fAngle);
			_22  =  (float)cos(fAngle);
		}
		
		// Overload * operator for ops such as M3=M1*M2
		inline CN2K_Matrix CN2K_Matrix::operator*(const CN2K_Matrix &mat)
		{
			float* pA = (FLOAT*)&m;
			float* pB = (FLOAT*)&mat;
			CN2K_Matrix pQ;
			float  pM[16];

			ZeroMemory(pM, sizeof(float)*16);

			for(WORD i=0; i<4; i++ ) 
				for(WORD j=0; j<4; j++ ) 
					for(WORD k=0; k<4; k++ ) 
						pM[4*i+j] +=  pA[4*i+k] * pB[4*k+j];

			memcpy(&pQ, pM, sizeof(float)*16);

			return pQ;
		}

};

// End define
#endif 