// +---------------------------------------------------------+
// | Nuke2000 library (C)1999-2000 Nuke Software/Odin Jensen |
// | Consult SDK documentation for legal information         |
// +---------------------------------------------------------+


// Make sure we are only included once
#ifndef __N2K_3DRENDER__H__
#define __N2K_3DRENDER__H__

// +--------------------------+
// | Files we need to include |
// +--------------------------+
#include <windows.h>  // All the standard windows types and functions.
#include <objbase.h>  // COM stuff
#include <n2k_3dmath.h> // Nuke2K 3D math functions
#include <n2k_3dstructs.h> // Nuke2K 3D structures

// +-----------------------------------+
// |   Macro to safely release memory  |
// |    Note the uppercase notation    |
// | I use this to recognise constants |
// |     and macros from functions.    |
// +-----------------------------------+
#ifndef SAFE_RELEASE
#define SAFE_RELEASE(x) if (x) {x->Release();x=NULL;}
#endif

// +----------------------+
// | Alpha blending modes |
// +----------------------+

#define N2K3D_BLEND_ZERO 1
#define N2K3D_BLEND_ONE  2
#define N2K3D_BLEND_SRCCOLOR 3
#define N2K3D_BLEND_INVSRCCOLOR 4
#define N2K3D_BLEND_SRCALPHA 5
#define N2K3D_BLEND_INVSRCALPHA 6
#define N2K3D_BLEND_DESTALPHA 7
#define N2K3D_BLEND_INVDESTALPHA 8
#define N2K3D_BLEND_DESTCOLOR 9
#define N2K3D_BLEND_INVDESTCOLOR 10
#define N2K3D_BLEND_SRCALPHASAT 11    

// +---------------+
// | Shading modes |
// +---------------+

#define N2K3D_SHADE_FLAT 0
#define N2K3D_SHADE_SMOOTH 1

// +-----------------------+
// | Interface identifiers |
// +-----------------------+

// N2K_3DRender component interface.
// Use this to get the main interface.

// {11764B01-6205-11d3-915A-00105A06E937}
static const IID IID_N2K_3DRENDER = 
{ 0x11764b01, 0x6205, 0x11d3, 
{ 0x91, 0x5a, 0x0, 0x10, 0x5a, 0x6, 0xe9, 0x37 } };

// N2K_3DRender main interface.
// Used to register/unregister component. Don't use!!!

// {11764B02-6205-11d3-915A-00105A06E937}
static const CLSID CLSID_N2K_3DRENDER1 = 
{ 0x11764b02, 0x6205, 0x11d3, 
{ 0x91, 0x5a, 0x0, 0x10, 0x5a, 0x6, 0xe9, 0x37 } };

#define N2K_Get3DRenderInterface(x) ::CoCreateInstance(CLSID_N2K_3DRENDER1,NULL, CLSCTX_INPROC_SERVER,IID_N2K_3DRENDER, (void**)&x)


// N2K_Video interface
interface IN2K_3DRender : IUnknown
{
	// Render indexed list of triangles with vertex colors and texture coordinates.
	virtual bool RenderTriangles(N2K_Vertex * pVertexList, WORD * pTriangleList,int iNumVertices, int iNumTriangles)=0;
	
	// Add a texture to the cache
	virtual bool CacheTexture(char * pFileName, int iTexState)=0;
	
	// Create new texture cache. Only one can exist at any time.
	virtual bool CreateTextureCache(int iMaxTextures)=0;
	
	// Destroy the texture cache.
	virtual void DestroyTextureCache()=0;
	
	// Make texture current. Call before rendering triangles that use this texture.
	virtual void MakeTextureCurrent(char *pTexName)=0;
	
	// Remove texture from cache
	virtual void DestroyTexture(char *pTexName)=0;
	
	// Init render component
	virtual bool Init(HWND hWnd, int iWidth, int iHeight, int iBpp, int iZBufSize, float zMin, float zMax, BOOL bFullscreen)=0;
		
	// Load the world matrix. (Objects are transformed with this)	
	virtual void LoadWorldMatrix(CN2K_Matrix * pWorld)=0;
	
	// Load the view matrix. (Camera are transformed with this)
	virtual void LoadViewMatrix(CN2K_Matrix * pView)=0;
	
	// Set perspective
	virtual bool SetPerspective(float fFOV,float fNearPlane, float fFarPlane)=0;

	// Clear screen
	virtual void ClearViewport(unsigned char r, unsigned char g, unsigned char b)=0;
	
	// Setup fog
	virtual void SetupFog(float fNear, float fFar, float fDensity, DWORD dwColor)=0;
	
	// Enable/disable fog
	virtual void EnableFog(bool bEnable)=0;
	
	// Begin scene
	virtual bool BeginScene()=0;

	// End scene
	virtual void EndScene()=0;

	// Flip buffers (Update screen)
	virtual bool Flip()=0;

	// Draw overlay
	virtual bool DrawOverlay(int iX, int iY, int iStretchX, int iStretchY, char * pTexName)=0;

	// Enable blending
	virtual void EnableAlphaBlend(bool bEnable)=0;

	// Set alpha blend state
	virtual void SetAlphaBlendMode(int iSrc, int iDst)=0;

	// Set shade mode
	virtual void SetShadeMode(int iMode)=0;

	// Enable/disable clipping. Warning : App might crash if polys are outside the viewport!!!
	virtual void EnableClipping(bool bEnable)=0;	

	// Get last error
	virtual char * GetLastError()=0;			
	};


#endif