// +---------------------------------------------------------+
// | Nuke2000 library (C)1999-2000 Nuke Software/Odin Jensen |
// | Consult SDK documentation for legal information         |
// +---------------------------------------------------------+

// Make sure we are only included once
#ifndef __N2K_3DSTRUCTS_H__
#define __N2K_3DSTRUCTS_H__

// Vertex structure
typedef struct
{
	float x,y,z; // Vertex points
	DWORD color; // Color
	float u,v; // Texture coords
	float nx,ny,nz; // Vertex normals
} N2K_Vertex;

// Surface structure
class CN2K_3DSurface
{

public:

	// Number of vertex in surface
	int iNumVertex;
	
	// Number of triangles
	int iNumTriangles;
	
	// List of vertices in surface
	N2K_Vertex * pVertices;

	// Index list of vertices in surface
	WORD * pTriangles;

	// Surface color
	float r,g,b,a;

	// Name of texture on surface
	char * pTexName;

	// Should surface be drawn
	bool bDrawThis;

};

// Mesh structure
class CN2K_3DMesh
{
public:

	// Number of surfaces
	int iNumSurfaces;

	// List of surface
	CN2K_3DSurface * pSurfaces;
};

// Object structure
class CN2K_3DModel
{

public:
	
	// Number of meshes
	int iNumMeshes;

	// List of meshes
	CN2K_3DMesh * pMesh;

};

#endif 