// +---------------------------------------------------------+
// | Nuke2000 library (C)1999-2000 Nuke Software/Odin Jensen |
// | Consult SDK documentation for legal information         |
// +---------------------------------------------------------+


// Make sure we are only included once
#ifndef __N2K_AUDIO__H__
#define __N2K_AUDIO__H__

// +--------------------------+
// | Files we need to include |
// +--------------------------+
#include <windows.h>  // All the standard windows types and functions.
#include <objbase.h>  // COM stuff

// +-----------------------------------+
// |   Macro to safely release memory  |
// |    Note the uppercase notation    |
// | I use this to recognise constants |
// |     and macros from functions.    |
// +-----------------------------------+
#ifndef SAFE_RELEASE
#define SAFE_RELEASE(x) if (x) {x->Release();x=NULL;}
#endif

// Define mode of playback
#define N2K_SOUNDMODE_NORMAL    0x100
#define N2K_SOUNDMODE_EXCLUSIVE 0x101

#define N2K_SOUND_LOOP 0x102
#define N2K_SOUND_PLAYONCE 0x103

#define N2K_LEFT_HAND 0x104
#define N2K_RIGHT_HAND 0x105

// +-----------------------+
// | Interface identifiers |
// +-----------------------+

// N2K_Audio component interface.
// Use this to get the main interface.

static const IID IID_N2K_AUDIO = 
{ 0x9415cde9, 0x49bf, 0x40bc, 
{ 0x81, 0x53, 0xd8, 0xd8, 0x18, 0xed, 0x15, 0x6b } };

// Audio interface
static const CLSID CLSID_N2K_AUDIO1 = 
{ 0xcc0ca899, 0xa219, 0x47dd, 
{ 0x89, 0x57, 0xcd, 0x14, 0xf4, 0x7f, 0x4b, 0x51 } };

// Macro for easy getting the interface
#define N2K_GetAudioInterface(x) ::CoCreateInstance(CLSID_N2K_AUDIO1,NULL, CLSCTX_INPROC_SERVER,IID_N2K_AUDIO, (void**)&x)

// N2K_Audio interface
interface IN2K_Audio : IUnknown
{

	// Init Aureal audio engine
	virtual bool Init(WORD wAccess, bool bShowLogo)=0;

	// Shutdown
	virtual void ShutDown()=0;

	// Create new sample
	virtual UINT CreateSample()=0;

	// Play sample 
	virtual void PlaySample(UINT uiId, int pStyle)=0;

	// Erase sample from memory
	virtual void EraseSample(UINT uiID)=0;

	// Set sample 3D position
	virtual void SetSamplePosition(UINT uiID, float x, float y, float z)=0;

	// Set listener position position/rotation
	virtual void SetListener(float x, float y, float z, float rx, float ry, float rz)=0;

	// Begin frame
	virtual void BeginFrame()=0;

	// End frame
	virtual void EndFrame()=0;

	// Load WAV sample
	virtual bool LoadSample(UINT uiID, char * pSampleFile)=0;

	// Set master volume (0..1)
	virtual void SetMasterGain(float fVolume)=0;

	// Set sample gain
	virtual void SetSampleGain(UINT uiID, float fVolume)=0;

	// Get last error
	virtual char * GetLastError()=0;

	// Stop sound
	virtual void StopSample(UINT uiID)=0;
		
};



#endif