// +---------------------------------------------------------+
// | Nuke2000 library (C)1999-2000 Nuke Software/Odin Jensen |
// | Consult SDK documentation for legal information         |
// +---------------------------------------------------------+


// Make sure we are only included once
#ifndef __N2K_INPUT__H__
#define __N2K_INPUT__H__

// +--------------------------+
// | Files we need to include |
// +--------------------------+
#include <windows.h>  // All the standard windows types and functions.
#include <objbase.h>  // COM stuff

// +-----------------------------------+
// |   Macro to safely release memory  |
// |    Note the uppercase notation    |
// | I use this to recognise constants |
// |     and macros from functions.    |
// +-----------------------------------+
#ifndef SAFE_RELEASE
#define SAFE_RELEASE(x) if (x) {x->Release();x=NULL;}
#endif

// +-----------------------+
// | Interface identifiers |
// +-----------------------+

// N2K_Input component interface.
// Use this to get the main interface.

// {5C97657D-18D6-4a62-8447-0B24C8E47E5B}
static const IID IID_N2K_INPUT = 
{ 0x5c97657d, 0x18d6, 0x4a62, 
{ 0x84, 0x47, 0xb, 0x24, 0xc8, 0xe4, 0x7e, 0x5b } };
	
// N2K_Input main interface.
// Used to register/unregister component. Don't use!!!

// {B1BE9BF0-B9C3-4f30-8A37-034F4CB8AFDF}
static const CLSID CLSID_N2K_INPUT1 = 
{ 0xb1be9bf0, 0xb9c3, 0x4f30, 
{ 0x8a, 0x37, 0x3, 0x4f, 0x4c, 0xb8, 0xaf, 0xdf } };

// Define maximum number of buttons mouse supports
#ifndef N2K_MAX_MOUSE_BUTTONS
#define N2K_MAX_MOUSE_BUTTONS 8
#endif

// Define maximum number of buttons joystick supports
#ifndef N2K_MAX_JOYSTICK_BUTTONS
#define N2K_MAX_JOYSTICK_BUTTONS 32
#endif

// Macro for easy getting the interface
#define N2K_GetInputInterface(x) ::CoCreateInstance(CLSID_N2K_INPUT1,NULL, CLSCTX_INPROC_SERVER,IID_N2K_INPUT, (void**)&x)


// N2K_Video interface
interface IN2K_Input : IUnknown
{
		// Init input system	
		virtual bool Init(HWND hWnd, bool bWantJoystick, bool bWantMouse, bool bWantKeyboard)=0;

		// Check for joystick. Not needed for other input devices, as most people have them :)
		virtual bool Joystick()=0;
		
		// Get keys
		virtual bool ReadKeyboard(unsigned char * kBuf)=0;

		// Get mouse info
		virtual bool ReadMouse(int &x, int &y, int &z, bool *pButtons)=0;

		// Get joystick info 
		virtual bool ReadJoystick(int &x, int &y, int &z, bool *pButtons)=0;
	
		// Get last error
		virtual char * GetLastError()=0;		
};

// +----------------+
// | Key scan codes |
// +----------------+

#define N2K_ESCAPE          0x01
#define N2K_1               0x02
#define N2K_2               0x03
#define N2K_3               0x04
#define N2K_4               0x05
#define N2K_5               0x06
#define N2K_6               0x07
#define N2K_7               0x08
#define N2K_8               0x09
#define N2K_9               0x0A
#define N2K_0               0x0B
#define N2K_MINUS           0x0C    /* - on main keyboard */
#define N2K_EQUALS          0x0D
#define N2K_BACK            0x0E    /* backspace */
#define N2K_TAB             0x0F
#define N2K_Q               0x10
#define N2K_W               0x11
#define N2K_E               0x12
#define N2K_R               0x13
#define N2K_T               0x14
#define N2K_Y               0x15
#define N2K_U               0x16
#define N2K_I               0x17
#define N2K_O               0x18
#define N2K_P               0x19
#define N2K_LBRACKET        0x1A
#define N2K_RBRACKET        0x1B
#define N2K_RETURN          0x1C    /* Enter on main keyboard */
#define N2K_LCONTROL        0x1D
#define N2K_A               0x1E
#define N2K_S               0x1F
#define N2K_D               0x20
#define N2K_F               0x21
#define N2K_G               0x22
#define N2K_H               0x23
#define N2K_J               0x24
#define N2K_K               0x25
#define N2K_L               0x26
#define N2K_SEMICOLON       0x27
#define N2K_APOSTROPHE      0x28
#define N2K_GRAVE           0x29    /* accent grave */
#define N2K_LSHIFT          0x2A
#define N2K_BACKSLASH       0x2B
#define N2K_Z               0x2C
#define N2K_X               0x2D
#define N2K_C               0x2E
#define N2K_V               0x2F
#define N2K_B               0x30
#define N2K_N               0x31
#define N2K_M               0x32
#define N2K_COMMA           0x33
#define N2K_PERIOD          0x34    /* . on main keyboard */
#define N2K_SLASH           0x35    /* / on main keyboard */
#define N2K_RSHIFT          0x36
#define N2K_MULTIPLY        0x37    /* * on numeric keypad */
#define N2K_LMENU           0x38    /* left Alt */
#define N2K_SPACE           0x39
#define N2K_CAPITAL         0x3A
#define N2K_F1              0x3B
#define N2K_F2              0x3C
#define N2K_F3              0x3D
#define N2K_F4              0x3E
#define N2K_F5              0x3F
#define N2K_F6              0x40
#define N2K_F7              0x41
#define N2K_F8              0x42
#define N2K_F9              0x43
#define N2K_F10             0x44
#define N2K_NUMLOCK         0x45
#define N2K_SCROLL          0x46    /* Scroll Lock */
#define N2K_NUMPAD7         0x47
#define N2K_NUMPAD8         0x48
#define N2K_NUMPAD9         0x49
#define N2K_SUBTRACT        0x4A    /* - on numeric keypad */
#define N2K_NUMPAD4         0x4B
#define N2K_NUMPAD5         0x4C
#define N2K_NUMPAD6         0x4D
#define N2K_ADD             0x4E    /* + on numeric keypad */
#define N2K_NUMPAD1         0x4F
#define N2K_NUMPAD2         0x50
#define N2K_NUMPAD3         0x51
#define N2K_NUMPAD0         0x52
#define N2K_DECIMAL         0x53    /* . on numeric keypad */
#define N2K_OEM_102         0x56    /* < > | on UK/Germany keyboards */
#define N2K_F11             0x57
#define N2K_F12             0x58

#define N2K_F13             0x64    /*                     (NEC PC98) */
#define N2K_F14             0x65    /*                     (NEC PC98) */
#define N2K_F15             0x66    /*                     (NEC PC98) */

#define N2K_KANA            0x70    /* (Japanese keyboard)            */
#define N2K_ABNT_C1         0x73    /* / ? on Portugese (Brazilian) keyboards */
#define N2K_CONVERT         0x79    /* (Japanese keyboard)            */
#define N2K_NOCONVERT       0x7B    /* (Japanese keyboard)            */
#define N2K_YEN             0x7D    /* (Japanese keyboard)            */
#define N2K_ABNT_C2         0x7E    /* Numpad . on Portugese (Brazilian) keyboards */
#define N2K_NUMPADEQUALS    0x8D    /* = on numeric keypad (NEC PC98) */
#define N2K_PREVTRACK       0x90    /* Previous Track (N2K_CIRCUMFLEX on Japanese keyboard) */
#define N2K_AT              0x91    /*                     (NEC PC98) */
#define N2K_COLON           0x92    /*                     (NEC PC98) */
#define N2K_UNDERLINE       0x93    /*                     (NEC PC98) */
#define N2K_KANJI           0x94    /* (Japanese keyboard)            */
#define N2K_STOP            0x95    /*                     (NEC PC98) */
#define N2K_AX              0x96    /*                     (Japan AX) */
#define N2K_UNLABELED       0x97    /*                        (J3100) */
#define N2K_NEXTTRACK       0x99    /* Next Track */
#define N2K_NUMPADENTER     0x9C    /* Enter on numeric keypad */
#define N2K_RCONTROL        0x9D
#define N2K_MUTE            0xA0    /* Mute */
#define N2K_CALCULATOR      0xA1    /* Calculator */
#define N2K_PLAYPAUSE       0xA2    /* Play / Pause */
#define N2K_MEDIASTOP       0xA4    /* Media Stop */
#define N2K_VOLUMEDOWN      0xAE    /* Volume - */
#define N2K_VOLUMEUP        0xB0    /* Volume + */
#define N2K_WEBHOME         0xB2    /* Web home */
#define N2K_NUMPADCOMMA     0xB3    /* , on numeric keypad (NEC PC98) */
#define N2K_DIVIDE          0xB5    /* / on numeric keypad */
#define N2K_SYSRQ           0xB7
#define N2K_RMENU           0xB8    /* right Alt */
#define N2K_PAUSE           0xC5    /* Pause */
#define N2K_HOME            0xC7    /* Home on arrow keypad */
#define N2K_UP              0xC8    /* UpArrow on arrow keypad */
#define N2K_PRIOR           0xC9    /* PgUp on arrow keypad */
#define N2K_LEFT            0xCB    /* LeftArrow on arrow keypad */
#define N2K_RIGHT           0xCD    /* RightArrow on arrow keypad */
#define N2K_END             0xCF    /* End on arrow keypad */
#define N2K_DOWN            0xD0    /* DownArrow on arrow keypad */
#define N2K_NEXT            0xD1    /* PgDn on arrow keypad */
#define N2K_INSERT          0xD2    /* Insert on arrow keypad */
#define N2K_DELETE          0xD3    /* Delete on arrow keypad */
#define N2K_LWIN            0xDB    /* Left Windows key */
#define N2K_RWIN            0xDC    /* Right Windows key */
#define N2K_APPS            0xDD    /* AppMenu key */
#define N2K_POWER           0xDE    /* System Power */
#define N2K_SLEEP           0xDF    /* System Sleep */
#define N2K_WAKE            0xE3    /* System Wake */
#define N2K_WEBSEARCH       0xE5    /* Web Search */
#define N2K_WEBFAVORITES    0xE6    /* Web Favorites */
#define N2K_WEBREFRESH      0xE7    /* Web Refresh */
#define N2K_WEBSTOP         0xE8    /* Web Stop */
#define N2K_WEBFORWARD      0xE9    /* Web Forward */
#define N2K_WEBBACK         0xEA    /* Web Back */
#define N2K_MYCOMPUTER      0xEB    /* My Computer */
#define N2K_MAIL            0xEC    /* Mail */
#define N2K_MEDIASELECT     0xED    /* Media Select */

/*
 *  Alternate names for keys, to facilitate transition from DOS.
 */
#define N2K_BACKSPACE       N2K_BACK            /* backspace */
#define N2K_NUMPADSTAR      N2K_MULTIPLY        /* * on numeric keypad */
#define N2K_LALT            N2K_LMENU           /* left Alt */
#define N2K_CAPSLOCK        N2K_CAPITAL         /* CapsLock */
#define N2K_NUMPADMINUS     N2K_SUBTRACT        /* - on numeric keypad */
#define N2K_NUMPADPLUS      N2K_ADD             /* + on numeric keypad */
#define N2K_NUMPADPERIOD    N2K_DECIMAL         /* . on numeric keypad */
#define N2K_NUMPADSLASH     N2K_DIVIDE          /* / on numeric keypad */
#define N2K_RALT            N2K_RMENU           /* right Alt */
#define N2K_UPARROW         N2K_UP              /* UpArrow on arrow keypad */
#define N2K_PGUP            N2K_PRIOR           /* PgUp on arrow keypad */
#define N2K_LEFTARROW       N2K_LEFT            /* LeftArrow on arrow keypad */
#define N2K_RIGHTARROW      N2K_RIGHT           /* RightArrow on arrow keypad */
#define N2K_DOWNARROW       N2K_DOWN            /* DownArrow on arrow keypad */
#define N2K_PGDN            N2K_NEXT            /* PgDn on arrow keypad */

/*
 *  Alternate names for keys originally not used on US keyboards.
 */
#define N2K_CIRCUMFLEX      N2K_PREVTRACK       /* Japanese keyboard */



#endif