// +---------------------------------------------------------+
// | Nuke2000 library (C)1999-2000 Nuke Software/Odin Jensen |
// | Consult SDK documentation for legal information         |
// +---------------------------------------------------------+


// Make sure we are only included once
#ifndef __N2K_WINDOW__H__
#define __N2K_WINDOW__H__

// +--------------------------+
// | Files we need to include |
// +--------------------------+
#include <windows.h>  // All the standard windows types and functions.
#include <objbase.h>  // COM stuff

// +-----------------------------------+
// |   Macro to safely release memory  |
// |    Note the uppercase notation    |
// | I use this to recognise constants |
// |     and macros from functions.    |
// +-----------------------------------+
#ifndef SAFE_RELEASE
#define SAFE_RELEASE(x) if (x) {x->Release();x=NULL;}
#endif

// +-----------------------+
// | Interface identifiers |
// +-----------------------+

// N2K_Window component interface.
// Use this to get the main interface.

// {B5CBDD21-5EE3-11d3-915A-00105A06E937}
static const IID IID_N2K_WINDOW = 
	{ 0xb5cbdd21, 0x5ee3, 0x11d3, 
	{ 0x91, 0x5a, 0x0, 0x10, 0x5a, 0x6, 0xe9, 0x37 } };

// N2K_Window main interface.
// Used to register/unregister component. Don't use!!!

// {735F7826-5EE3-11d3-915A-00105A06E937}
static const CLSID CLSID_N2K_WINDOW1 = 
	{ 0x735f7826, 0x5ee3, 0x11d3, 
	{ 0x91, 0x5a, 0x0, 0x10, 0x5a, 0x6, 0xe9, 0x37 } };

// Macro for easy getting the interface
#define N2K_GetWindowInterface(x) ::CoCreateInstance(CLSID_N2K_WINDOW1,NULL, CLSCTX_INPROC_SERVER,IID_N2K_WINDOW, (void**)&x)


// N2K_Video interface
interface IN2K_Window : IUnknown
{

		// Init screen
		virtual bool Init(HINSTANCE hInst,void (*pUpdate)(), int iX, int iY, int iWidth, int iHeight,DWORD dwFlags, LPSTR lpszWinTitle,int iAppIcon)=0; 
		
		// Process message loop
		virtual int DoMessageLoop()=0;

		// Get window handle (Windows only?)
		virtual HWND GetHandle()=0;

		// Get window instance (Windows only?)
		virtual HINSTANCE GetInstance()=0;

		// Get window width
		virtual int GetDesktopWidth()=0;

		// Get window height
		virtual int GetDesktopHeight()=0;

		// Get window BPP
		virtual int GetDesktopBPP()=0;
		
		// Show cursor
		virtual void ShowCursor(bool bShow)=0;

		// Get last error
		virtual char * GetLastError()=0;

		// End app
		virtual void EndApp(int iExitCode)=0;

		
};



#endif