FILE           *ase_file;
char           *LineData,*CommandData;
int            obj=0,cmr=0,lig=0;

void read_value( unsigned short &value, char *line )
{
	char           *arg1;
	char           *arg2;
	arg1    = (char *)malloc( 80 );
	arg2    = (char *)malloc( 80 );

	sscanf( line, "%s %s", arg1, arg2 );
	value = atoi( arg2 );

	free( arg1 );
	free( arg2 );
	arg1 = NULL;
	arg2 = NULL;
}

void read_value( unsigned short *value, char *line )
{
	char           *arg1,*arg2,*arg3,*arg4;
	arg1    = (char *)malloc( 80 );
	arg2    = (char *)malloc( 80 );
	arg3    = (char *)malloc( 80 );
	arg4    = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s", arg1, arg2, arg3, arg4 );
	value[0] = atoi( arg2 );
	value[1] = atoi( arg3 );
	value[2] = atoi( arg4 );

	free( arg1 );
	free( arg2 );
	free( arg3 );
	free( arg4 );
	arg1 = arg2 = arg3 = arg4 = NULL;
}

void read_value( int &value, char *line )
{
	char           *arg1;
	char           *arg2;
	arg1    = (char *)malloc( 80 );
	arg2    = (char *)malloc( 80 );

	sscanf( line, "%s %s", arg1, arg2 );
	value = atoi( arg2 );

	free( arg1 );
	free( arg2 );
	arg1 = NULL;
	arg2 = NULL;
}

void read_value( float &value, char *line )
{
	char           *arg1,*arg2;
	arg1    = (char *)malloc( 80 );
	arg2    = (char *)malloc( 80 );

	sscanf( line, "%s %s", arg1, arg2 );
	value = (float)atof( arg2 );

	free( arg1 );
	free( arg2 );
	arg1 = arg2 = NULL;
}

void read_value( float *value, char *line )
{
	char           *arg1,*arg2,*arg3,*arg4;
	arg1    = (char *)malloc( 80 );
	arg2    = (char *)malloc( 80 );
	arg3    = (char *)malloc( 80 );
	arg4    = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s", arg1, arg2, arg3, arg4 );
	value[0] = (float)atof( arg2 );
	value[1] = (float)atof( arg3 );
	value[2] = (float)atof( arg4 );

	free( arg1 );
	free( arg2 );
	free( arg3 );
	free( arg4 );
	arg1 = arg2 = arg3 = arg4 = NULL;
}

void read_value( tag_mesh_vertex_list &Vertex, char *line )
{
	char           *arg1,*arg2,*arg3,*arg4,*arg5;
	arg1    = (char *)malloc( 80 );
	arg2    = (char *)malloc( 80 );
	arg3    = (char *)malloc( 80 );
	arg4    = (char *)malloc( 80 );
	arg5    = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s", arg1, arg2, arg3, arg4, arg5 );
	Vertex.x = (float)atof( arg3 );
	Vertex.y = (float)atof( arg4 );
	Vertex.z = (float)atof( arg5 );

	free( arg1 );
	free( arg2 );
	free( arg3 );
	free( arg4 );
	free( arg5 );
	arg1 = arg2 = arg3 = arg4 = arg5 = NULL;
}

void read_value( tag_mesh_face_list &Face, char *line )
{
	char  *arg[18];
	int   counter;

	for( counter=0; counter<18; counter++ )
		arg[counter] = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
		    arg[0], arg[1], arg[2], arg[3], arg[4], 
			arg[5], arg[6], arg[7], arg[8], arg[9], 
			arg[10],arg[11],arg[12],arg[13],arg[14], 
			arg[15],arg[16],arg[17] );

	Face.a = atoi(arg[3]);
	Face.b = atoi(arg[5]);
	Face.c = atoi(arg[7]);
	Face.ab= atoi(arg[9]);
	Face.bc= atoi(arg[11]);
	Face.ca= atoi(arg[13]);

	for( counter=0; counter<18; counter++ )
	{
		free( arg[counter] );
		arg[counter]=NULL;
	}
}

unsigned short read_value( tag_mesh_facenormal &normal, char *line )
{
	char           *arg1,*arg2,*arg3,*arg4,*arg5;
	unsigned short num;
	arg1 = (char *)malloc( 80 );
	arg2 = (char *)malloc( 80 );
	arg3 = (char *)malloc( 80 );
	arg4 = (char *)malloc( 80 );
	arg5 = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s", arg1, arg2, arg3, arg4, arg5 );

	num = atoi(arg2);

	normal.FACE = atoi(arg2);
	normal.x    = (float)atof(arg3);
	normal.y    = (float)atof(arg4);
	normal.z    = (float)atof(arg5);

	free( arg1 );
	free( arg2 );
	free( arg3 );
	free( arg4 );
	free( arg5 );
	arg1 = arg2 = arg3 = arg4 = arg5 = NULL;

	return num;
}

void read_value( tag_mesh_vertexnormal &vertexnormal, char *line )
{
	char           *arg1,*arg2,*arg3,*arg4,*arg5;
	arg1 = (char *)malloc( 80 );
	arg2 = (char *)malloc( 80 );
	arg3 = (char *)malloc( 80 );
	arg4 = (char *)malloc( 80 );
	arg5 = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s", arg1, arg2, arg3, arg4, arg5 );

	vertexnormal.VERTEX=atoi(arg2);
	vertexnormal.x    = (float)atof(arg3);
	vertexnormal.y    = (float)atof(arg4);
	vertexnormal.z    = (float)atof(arg5);

	free( arg1 );
	free( arg2 );
	free( arg3 );
	free( arg4 );
	free( arg5 );
	arg1 = arg2 = arg3 = arg4 = arg5 = NULL;
}

void read_value( tag_control_pos_bezier &translate, char *line )
{
	char           *arg[12];
	
	for( int i =0; i < 12; i++ )
		arg[i] = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s %s %s %s %s %s %s %s", arg[0], arg[1], arg[2], arg[3], arg[4],
		          arg[5], arg[6], arg[7], arg[8], arg[9], arg[10], arg[11] );

	translate.frame = atoi( arg[1] );
	translate.x     = (float)atof( arg[2] );
	translate.y     = (float)atof( arg[3] );
	translate.z     = (float)atof( arg[4] );
	translate.x1    = (float)atof( arg[5] );
	translate.y1    = (float)atof( arg[6] );
	translate.z1    = (float)atof( arg[7] );
	translate.x2    = (float)atof( arg[8] );
	translate.y2    = (float)atof( arg[9] );
	translate.z2    = (float)atof( arg[10] );
	translate.zz    = atoi( arg[11] );

	for( i=0; i< 12; i++ )
	{
		free( arg[i] );
		arg[i]=NULL;
	}
}

void read_value( tag_control_rot_tcb &rotate, char *line )
{
	char           *arg[11];
	
	for( int i =0; i < 11; i++ )
		arg[i] = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s %s %s %s %s %s %s", arg[0], arg[1], arg[2], arg[3], arg[4],
		          arg[5], arg[6], arg[7], arg[8], arg[9], arg[10] );

	rotate.frame = atoi( arg[1] );
	rotate.x     = (float)atof( arg[2] );
	rotate.y     = (float)atof( arg[3] );
	rotate.z     = (float)atof( arg[4] );
	rotate.x1    = (float)atof( arg[5] );
	rotate.y1    = (float)atof( arg[6] );
	rotate.z1    = (float)atof( arg[7] );
	rotate.x2    = (float)atof( arg[8] );
	rotate.y2    = (float)atof( arg[9] );
	rotate.z2    = (float)atof( arg[10] );

	for( i=0; i< 11; i++ )
	{
		free( arg[i] );
		arg[i]=NULL;
	}
}

void read_value( tag_control_scale_bezier &scale, char *line )
{
	char           *arg[16];
	
	for( int i =0; i < 16; i++ )
		arg[i] = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s", arg[0], arg[1], arg[2], arg[3], arg[4],
		          arg[5], arg[6], arg[7], arg[8], arg[9], arg[10], arg[11], arg[12], arg[13], arg[14], arg[15] );

	scale.frame = atoi( arg[1] );
	scale.x     = (float)atof( arg[2] );
	scale.y     = (float)atof( arg[3] );
	scale.z     = (float)atof( arg[4] );
	scale.x1    = (float)atof( arg[5] );
	scale.y1    = (float)atof( arg[6] );
	scale.z1    = (float)atof( arg[7] );
    scale.xx    = (float)atof( arg[8] );
	scale.x2    = (float)atof( arg[9] );
	scale.y2    = (float)atof( arg[10] );
	scale.z2    = (float)atof( arg[11] );
	scale.x3    = (float)atof( arg[12] );
	scale.y3    = (float)atof( arg[13] );
	scale.z3    = (float)atof( arg[14] );
	scale.zz    = atoi( arg[15] );

	for( i=0; i< 16; i++ )
	{
		free( arg[i] );
		arg[i]=NULL;
	}
}

void read_value( tag_control_pos_track &track, char *line )
{
	char  *arg[5];
	
	for( int i =0; i < 5; i++ )
		arg[i] = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s",arg[0], arg[1], arg[2], arg[3], arg[4] );

	track.frame = atoi( arg[1] );
	track.x     = (float)atof( arg[2] );
	track.y     = (float)atof( arg[3] );
	track.z     = (float)atof( arg[4] );

	for( i=0; i< 5; i++ )
	{
		free( arg[i] );
		arg[i]=NULL;
	}
}

void read_value( tag_control_rot_track &track, char *line )
{
	char  *arg[5];
	
	for( int i =0; i < 5; i++ )
		arg[i] = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s",arg[0], arg[1], arg[2], arg[3], arg[4] );

	track.frame = atoi( arg[1] );
	track.x     = (float)atof( arg[2] );
	track.y     = (float)atof( arg[3] );
	track.z     = (float)atof( arg[4] );

	for( i=0; i< 5; i++ )
	{
		free( arg[i] );
		arg[i]=NULL;
	}
}

void read_value( char *value, char *line )
{
	char           *arg1;
	char           *arg2;
	arg1    = (char *)malloc( 80 );
	arg2    = (char *)malloc( 80 );

	sscanf( line, "%s %s", arg1, arg2 );
	strcpy( value, arg2 );

	free( arg1 );
	free( arg2 );
	arg1 = NULL;
	arg2 = NULL;
}

void read_value( tag_mesh_tvertlist &tvertlist, char *line )
{
	char  *arg[5];
	
	for( int i =0; i < 5; i++ )
		arg[i] = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s",arg[0], arg[1], arg[2], arg[3], arg[4] );

	tvertlist.vertex = atoi( arg[1] );
	tvertlist.u     = (float)atof( arg[2] );
	tvertlist.v     = (float)atof( arg[3] );
	tvertlist.w     = (float)atof( arg[4] );

	for( i=0; i< 5; i++ )
	{
		free( arg[i] );
		arg[i]=NULL;
	}
}

void read_value( tag_mesh_tfacelist &tfacelist, char *line )
{
	char  *arg[5];
	
	for( int i =0; i < 5; i++ )
		arg[i] = (char *)malloc( 80 );

	sscanf( line, "%s %s %s %s %s",arg[0], arg[1], arg[2], arg[3], arg[4] );

	tfacelist.face= atoi( arg[1] );
	tfacelist.v1  = atoi( arg[2] );
	tfacelist.v2  = atoi( arg[3] );
	tfacelist.v3  = atoi( arg[4] );

	for( i=0; i< 5; i++ )
	{
		free( arg[i] );
		arg[i]=NULL;
	}
}

char *read_line()
{
	char   ch;

	memset( LineData, 0x00, _msize(LineData) );

	for( unsigned char counter=0; ; counter++ )
	{
		ch = fgetc( ase_file );

		if( ch == EOF ) return "EOF";

		LineData[counter] = ch;

		if( counter > 0 )
			if(	LineData[counter-1] == 0x0D )
			if( LineData[counter]   == 0x0A )
				break;
	}

	return LineData;
}

void ReadASE( char *name )
{
	char *temp_buffer;
	int  counter;
	LineData = (char *)malloc( 255 );
	CommandData = (char *)malloc( 255 );

	ase_file = fopen( name, "rb" );

//Ͱ ASE о̴ κԴϴ.
	read_value( ASE.MAX_ASCIIEXPORT, read_line() );
    read_value( ASE.COMMENT, read_line() );
//Scene б
	sscanf( read_line(), "%s", CommandData );
	if( strcmp( "*SCENE", CommandData ) == 0 )
	{
		read_value( ASE.SCENE.SCENE_FILENAME, read_line() );
		read_value( ASE.SCENE.SCENE_FIRSTFRAME, read_line() );
		read_value( ASE.SCENE.SCENE_LASTFRAME, read_line() );
		read_value( ASE.SCENE.SCENE_FRAMESPEED, read_line() );
		read_value( ASE.SCENE.SCENE_TICKSPERFRAME, read_line() );
		read_value( ASE.SCENE.SCENE_BACKGROUND_STATIC, read_line() );
		read_value( ASE.SCENE.SCENE_AMBIENT_STATIC, read_line() );
     	
		sscanf( read_line(), "%s", CommandData );
	    if( strcmp( "}", CommandData ) != 0 )
			return;
	}
//Material б.
	sscanf( read_line(), "%s", CommandData );
	if( strcmp( "*MATERIAL_LIST", CommandData ) == 0 )
	{
		read_value( ASE.MATERIAL_LIST.MATERIAL_COUNT, read_line() );

		ASE.MATERIAL_LIST.MATERIAL = ( tag_material * )malloc( sizeof tag_material
			                           * ASE.MATERIAL_LIST.MATERIAL_COUNT );

		for( int i=0; i<ASE.MATERIAL_LIST.MATERIAL_COUNT; i++ )
		{
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_NAME, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_CLASS, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_AMBIENT, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_DIFFUSE, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_SPECULAR, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_SHINE, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_SHINESTRENGTH, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_TRANSPARENCY, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_WIRESIZE, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_SHADING, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_XP_FALLOFF, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_SELFILLUM, read_line() );
			read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_FALLOFF, read_line() );

			sscanf( temp_buffer = read_line(), "%s", CommandData );
			if( strcmp( "*MATERIAL_SOFTEN", CommandData ) == 0 )
			{
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_SOFTEN, temp_buffer );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_XP_TYPE, read_line() );
			}
			else if( strcmp( "*MATERIAL_XP_TYPE", CommandData ) == 0 )
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_XP_TYPE, temp_buffer );

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "}", CommandData ) == 0 )
			{
				//߰ȣ ۵̶ ƹ . ^^;
			}
			else if( strcmp( "*MAP_DIFFUSE", CommandData ) == 0 )
			{
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.MAP_NAME, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.MAP_CLASS, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.MAP_SUBNO, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.MAP_AMOUNT, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.BITMAP, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.MAP_TYPE, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_U_OFFSET, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_V_OFFSET, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_U_TILING, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_V_TILING, read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_ANGLE,  read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_BLUR,  read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_BLUR_OFFSET,  read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_NOUSE_AMT,  read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_NOISE_SIZE,  read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_NOISE_LEVEL,  read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.UVW_NOISE_PHASE,  read_line() );
				read_value( ASE.MATERIAL_LIST.MATERIAL[i].MAP_DIFFUSE.BITMAP_FILTER,  read_line() );
				read_line(); // "}";
				read_line(); // "}";
			}
		}
		sscanf( read_line(), "%s", CommandData );
		if( strcmp( "}", CommandData ) != 0 )
			return;
	}
//Ʈ, , ī޶  б.

	while( 1 )
	{
		sscanf( temp_buffer = read_line(), "%s", CommandData );
		
		if( temp_buffer == "EOF" )
		{
			printf( "Read ASE Complete!!" );
			getchar();
			break;
		}
		//Ʈ б.
		else if( strcmp( "*GEOMOBJECT", CommandData ) == 0 )
		{
			if( obj == 0 )
			{
				ASE.GEOMOBJECT = ( tag_geomobject *)malloc( sizeof tag_geomobject );
				ase = ( tag_ase * )malloc( sizeof tag_ase );
			}
			else
			{
				ASE.GEOMOBJECT = ( tag_geomobject *)realloc( ASE.GEOMOBJECT
					             , sizeof tag_geomobject* ( obj + 1 ) );
				ase = ( tag_ase * )realloc( ase, sizeof tag_ase * ( obj + 1 ) );
			}
			//  ʱȭ κ.
			/*ase[obj].KeyFrame.total_translate = 0;
			ase[obj].KeyFrame.total_rotate = 0;
			ase[obj].KeyFrame.total_scale = 0;
			ase[obj].KeyFrame.TRSFlag = 0;
			ase[obj].KeyFrame.ObjCenter[0] = 0;
			ase[obj].KeyFrame.ObjCenter[1] = 0;
			ase[obj].KeyFrame.ObjCenter[2] = 0;*/
			ase[obj].total_morph = 0;
			ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_POS_BEZIER = NULL;
			ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_ROT_TCB = NULL;
			ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_SCALE_BEZIER = NULL;

			read_value( ASE.GEOMOBJECT[obj].NODE_NAME, temp_buffer = read_line() );
			strcpy( ASE.GEOMOBJECT[obj].NODE_PARENT, "*NONEPARENT" );

			sscanf( temp_buffer = read_line(), "%s", CommandData );
			if( strcmp( "*NODE_TM", CommandData ) == 0 ) { ; }
			else if( strcmp( "*NODE_PARENT", CommandData ) == 0 )
			{
				read_value( ASE.GEOMOBJECT[obj].NODE_PARENT, temp_buffer );
				read_line(); // *NODE_TM;
			}

			read_value( ASE.GEOMOBJECT[obj].NODE_TM.NODE_NAME, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.INHERIT_POS, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.INHERIT_ROT, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.INHERIT_SCL, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_ROW0, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_ROW1, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_ROW2, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_ROW3, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_POS, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_ROTAXIS, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_ROTANGLE, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_SCALE, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_SCALEAXIS, read_line() );
			read_value( ASE.GEOMOBJECT[obj].NODE_TM.TM_SCALEAXISANG, read_line() );

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "}", CommandData ) != 0 )
				return;

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "*MESH", CommandData ) != 0 )
				return;

			read_value( ASE.GEOMOBJECT[obj].MESH.TIMEVALUE, read_line() );
			read_value( ASE.GEOMOBJECT[obj].MESH.MESH_NUMVERTEX, read_line() );
			read_value( ASE.GEOMOBJECT[obj].MESH.MESH_NUMFACES, read_line() );

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "*MESH_VERTEX_LIST", CommandData ) == 0 )
			ASE.GEOMOBJECT[obj].MESH.MESH_VERTEX_LIST = ( tag_mesh_vertex_list * )malloc( sizeof
	                             tag_mesh_vertex_list * ASE.GEOMOBJECT[obj].MESH.MESH_NUMVERTEX );
			
			for( int ii = 0; ii < ASE.GEOMOBJECT[obj].MESH.MESH_NUMVERTEX; ii++ )
				read_value( ASE.GEOMOBJECT[obj].MESH.MESH_VERTEX_LIST[ii], read_line() );

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "}", CommandData ) != 0 )
				return;

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "*MESH_FACE_LIST", CommandData ) == 0 )
			ASE.GEOMOBJECT[obj].MESH.MESH_FACE_LIST = ( tag_mesh_face_list * )malloc( sizeof
				                 tag_mesh_face_list * ASE.GEOMOBJECT[obj].MESH.MESH_NUMFACES );
			for( ii = 0; ii < ASE.GEOMOBJECT[obj].MESH.MESH_NUMFACES; ii++ )
				read_value( ASE.GEOMOBJECT[obj].MESH.MESH_FACE_LIST[ii], read_line() );

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "}", CommandData ) != 0 )
				return;

			read_value( ASE.GEOMOBJECT[obj].MESH.MESH_NUMTVERTEX, read_line() );
			//ؽ Ͱ  д´.
			if( ASE.GEOMOBJECT[obj].MESH.MESH_NUMTVERTEX >= 1 )
			{
				ASE.GEOMOBJECT[obj].MESH.MESH_TVERTLIST = ( tag_mesh_tvertlist * )malloc( sizeof
					tag_mesh_tvertlist * ASE.GEOMOBJECT[obj].MESH.MESH_NUMTVERTEX );

				read_line();

				for( int qq = 0; qq < ASE.GEOMOBJECT[obj].MESH.MESH_NUMTVERTEX; qq++ )
					read_value( ASE.GEOMOBJECT[obj].MESH.MESH_TVERTLIST[qq], read_line() );
	
				read_line(); //"}";

				read_value( ASE.GEOMOBJECT[obj].MESH.MESH_NUMTVFACES, read_line() );
	
				if( ASE.GEOMOBJECT[obj].MESH.MESH_NUMTVFACES >= 1 )
				{
					ASE.GEOMOBJECT[obj].MESH.MESH_TFACELIST = ( tag_mesh_tfacelist * )malloc( sizeof
						tag_mesh_tfacelist * ASE.GEOMOBJECT[obj].MESH.MESH_NUMTVFACES );
	
					read_line();
	
					for( int qq = 0; qq < ASE.GEOMOBJECT[obj].MESH.MESH_NUMTVFACES; qq++ )
						read_value( ASE.GEOMOBJECT[obj].MESH.MESH_TFACELIST[qq], read_line() );

					read_line(); //"}";
				}
			}

			read_value( ASE.GEOMOBJECT[obj].MESH.MESH_NUMCVERTEX, read_line() );

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "*MESH_NORMALS", CommandData ) == 0 )
			{
				ASE.GEOMOBJECT[obj].MESH.MESH_NORMALS.MESH_FACENORMAL = ( tag_mesh_facenormal * )
					malloc( sizeof tag_mesh_facenormal * ASE.GEOMOBJECT[obj].MESH.MESH_NUMFACES );
				ASE.GEOMOBJECT[obj].MESH.MESH_NORMALS.MESH_VERTEXNORMAL = ( tag_mesh_vertexnormal * )
					malloc( sizeof tag_mesh_vertexnormal * ASE.GEOMOBJECT[obj].MESH.MESH_NUMFACES * 3 );
			}

			for( ii = 0; ii < ASE.GEOMOBJECT[obj].MESH.MESH_NUMFACES; ii++ )
			{
				read_value( ASE.GEOMOBJECT[obj].MESH.MESH_NORMALS.MESH_FACENORMAL[ii], read_line() );
				read_value( ASE.GEOMOBJECT[obj].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3  ], read_line() );
				read_value( ASE.GEOMOBJECT[obj].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3+1], read_line() );
				read_value( ASE.GEOMOBJECT[obj].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3+2], read_line() );
			}

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "}", CommandData ) != 0 )
				return;
			
			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "}", CommandData ) != 0 )
				return;

			read_value( ASE.GEOMOBJECT[obj].MESH.PROP_MOTIONBLUR, read_line() );
			read_value( ASE.GEOMOBJECT[obj].MESH.PROP_CASTSHADOW, read_line() );
			read_value( ASE.GEOMOBJECT[obj].MESH.PROP_RECVSHADOW, read_line() );

			//͸ Ƿ ? ƴϸ ׾տ ִϸ̼ ó ִ....
			sscanf( temp_buffer = read_line(), "%s", CommandData );
			if( strcmp( "*MATERIAL_REF", CommandData ) == 0 )
				read_value( ASE.GEOMOBJECT[obj].MESH.MATERIAL_REF, temp_buffer );
			else if( strcmp( "*WIREFRAME_COLOR", CommandData ) == 0 )
				read_value( ASE.GEOMOBJECT[obj].MESH.WIREFRAME_COLOR, temp_buffer );
			else if( strcmp( "*TM_ANIMATION", CommandData ) == 0 )
			{
				/*ase[obj].KeyFrame.ObjCenter[0] = ASE.GEOMOBJECT[obj].NODE_TM.TM_POS[0];
				ase[obj].KeyFrame.ObjCenter[1] = ASE.GEOMOBJECT[obj].NODE_TM.TM_POS[1];
				ase[obj].KeyFrame.ObjCenter[2] = ASE.GEOMOBJECT[obj].NODE_TM.TM_POS[2];*/

				read_value( ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.NODE_NAME, read_line() );

				for( ; ; )
				{
					sscanf( read_line(), "%s", CommandData );
					if( strcmp( "}", CommandData ) == 0 )
						break;

					if( strcmp( "*CONTROL_POS_BEZIER", CommandData ) == 0 ||
						strcmp( "*CONTROL_POS_TCB", CommandData ) == 0 )
					{
						//ase[obj].KeyFrame.TRSFlag += 1;

						for( counter=0; ;counter++ )
						{
							sscanf( temp_buffer = read_line(), "%s", CommandData );

							if( strcmp( "*CONTROL_BEZIER_POS_KEY", CommandData ) == 0 ||
								strcmp( "*CONTROL_TCB_POS_KEY", CommandData ) == 0 )
							{
								if( counter == 0 )
									ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_POS_BEZIER
									= ( tag_control_pos_bezier * )malloc( sizeof tag_control_pos_bezier );
								else
									ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_POS_BEZIER
									= ( tag_control_pos_bezier * )realloc( ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_POS_BEZIER,
									sizeof tag_control_pos_bezier * ( counter + 1 ) );

								read_value( ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.
									        CONTROL_POS_BEZIER[counter], temp_buffer );

								//ase[obj].KeyFrame.total_translate++;
							}

							else if( strcmp( "}", CommandData ) == 0 )
								break;
							else
								break; //  ó ټ ̴.
						}
					}
					else if( strcmp( "*CONTROL_ROT_TCB", CommandData ) == 0 )
					{
						//ase[obj].KeyFrame.TRSFlag += 2;
	
						for( counter=0; ;counter++ )
						{
							sscanf( temp_buffer = read_line(), "%s", CommandData );

							if( strcmp( "*CONTROL_TCB_ROT_KEY", CommandData ) == 0 )
							{
								if( counter == 0 )
									ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_ROT_TCB
									= ( tag_control_rot_tcb * )malloc( sizeof tag_control_rot_tcb );
								else
									ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_ROT_TCB
									= ( tag_control_rot_tcb * )realloc( ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_ROT_TCB,
									  sizeof tag_control_rot_tcb * ( counter + 1 ) );

								read_value( ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.
									        CONTROL_ROT_TCB[counter], temp_buffer );

								//ase[obj].KeyFrame.total_rotate++;
							}

							else if( strcmp( "}", CommandData ) == 0 )
								break;
							else
								break; //  ó ټ ̴.
						}
					}
					else if( strcmp( "*CONTROL_SCALE_BEZIER", CommandData ) == 0 ||
							 strcmp( "*CONTROL_SCALE_TCB", CommandData )  == 0 )
					{
						//ase[obj].KeyFrame.TRSFlag += 4;

						for( counter=0; ;counter++ )
						{
							sscanf( temp_buffer = read_line(), "%s", CommandData );

							if( strcmp( "*CONTROL_BEZIER_SCALE_KEY", CommandData ) == 0 ||
								strcmp( "*CONTROL_TCB_SCALE_KEY", CommandData ) == 0 )
							{
								if( counter == 0 )
									ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_SCALE_BEZIER
									= ( tag_control_scale_bezier * )malloc( sizeof tag_control_scale_bezier );
								else
									ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_SCALE_BEZIER
									= ( tag_control_scale_bezier * )realloc( ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.CONTROL_SCALE_BEZIER,
									  sizeof tag_control_scale_bezier * ( counter + 1 ) );

								read_value( ASE.GEOMOBJECT[obj].MESH.TM_ANIMATION.
									        CONTROL_SCALE_BEZIER[counter], temp_buffer );

								//ase[obj].KeyFrame.total_scale++;
							}

							else if( strcmp( "}", CommandData ) == 0 )
								break;
							else
								break; //  ó ټ ̴.
						}
					}
				}
				sscanf( temp_buffer = read_line(), "%s", CommandData );
				if( strcmp( "*MATERIAL_REF", CommandData ) == 0 )
					read_value( ASE.GEOMOBJECT[obj].MESH.MATERIAL_REF, temp_buffer );
				else if( strcmp( "*WIREFRAME_COLOR", CommandData ) == 0 )
					read_value( ASE.GEOMOBJECT[obj].MESH.WIREFRAME_COLOR, temp_buffer );
			}

			//ó Ͱ ִ  ׽ƮѴ.
			sscanf( read_line(), "%s", CommandData );
			// ó ?
			if(	strcmp( "}", CommandData ) == 0) { ; }
			//ó ?
			else if( strcmp( "*MESH_ANIMATION", CommandData ) == 0)
			{
				for( counter = 0; ; counter++ )
				{
					sscanf( read_line(), "%s", CommandData );
					if( strcmp( "*MESH", CommandData ) == 0 )
					{
						ase[obj].total_morph++;

						if( counter == 0 )
						{
							ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION = (tag_mesh_animation *)
							malloc( sizeof tag_mesh_animation );
						}
						else if( counter > 0 )
						{
							ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION = (tag_mesh_animation *)
							realloc(  ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION, 
							sizeof tag_mesh_animation * ( counter + 1 ) );
						}
					}
					else if( strcmp( "}", CommandData ) == 0 )
						break;

					read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].TIMEVALUE, read_line() );
					read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].NUMVERTEX, read_line() );
					read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].NUMFACES,  read_line() );

					//ؽ Ʈ б ʱȭ
					sscanf( read_line(), "%s", CommandData );
					if( strcmp( "*MESH_VERTEX_LIST", CommandData ) == 0 )
					{
						ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_VERTEX_LIST =
						(tag_mesh_vertex_list *)malloc( sizeof tag_mesh_vertex_list *
						ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].NUMVERTEX );
					}

					//ؽ Ʈ б.
					for( int zz=0; ; zz++ )
					{
						sscanf( temp_buffer = read_line(), "%s", CommandData );
		     			if( strcmp( "*MESH_VERTEX", CommandData ) == 0 )
						{
							read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter]
							.MESH_VERTEX_LIST[zz], temp_buffer );
						}
						else if( strcmp( "}", CommandData ) == 0 )
							break;
					}

					//̽ Ʈ б  ʱȭ
					sscanf( read_line(), "%s", CommandData );
					if( strcmp( "*MESH_FACE_LIST", CommandData ) == 0 )
					{
						ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_FACE_LIST =
						(tag_mesh_face_list *)malloc( sizeof tag_mesh_face_list *
						ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].NUMFACES );
					}
					//̽ Ʈ б
					for( zz=0; ; zz++ )
					{
						sscanf( temp_buffer = read_line(), "%s", CommandData );
		     			if( strcmp( "*MESH_FACE", CommandData ) == 0 )
						{
							read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter]
							.MESH_FACE_LIST[zz], temp_buffer );
						}
						else if( strcmp( "}", CommandData ) == 0 )
							break;
					}
					read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_NUMTVERTEX, read_line() );
					read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_NUMCVERTEX, read_line() );

					sscanf( temp_buffer = read_line(), "%s", CommandData );
					if( strcmp( "*MESH_NORMALS", CommandData ) == 0 )
					{
						ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_NORMALS.MESH_FACENORMAL
						= ( tag_mesh_facenormal * )malloc( sizeof tag_mesh_facenormal 
						* ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].NUMFACES );
						ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_NORMALS.MESH_VERTEXNORMAL
						= ( tag_mesh_vertexnormal * )malloc( sizeof tag_mesh_vertexnormal 
						* ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].NUMFACES * 3 );
					} 

					for( zz = 0; ; zz++ )
					{
						sscanf( temp_buffer = read_line(), "%s", CommandData );
						if( strcmp( "}", CommandData ) == 0 )
							break;
						read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_NORMALS.MESH_FACENORMAL[zz], temp_buffer );
						read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_NORMALS.MESH_VERTEXNORMAL[zz*3+0], read_line() );
						read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_NORMALS.MESH_VERTEXNORMAL[zz*3+1], read_line() );
						read_value( ASE.GEOMOBJECT[obj].MESH.MESH_ANIMATION[counter].MESH_NORMALS.MESH_VERTEXNORMAL[zz*3+2], read_line() );
					}
					sscanf( read_line(), "%s", CommandData );
					if( strcmp( "}", CommandData ) != 0 )
						return;
				}		
				read_line(); // "}";
			}
			obj++;
			printf( "%d Object Compelete!!",obj );
			getchar();
		}
		else if( strcmp( "*LIGHTOBJECT", CommandData ) == 0 )
		{
			if( lig == 0 )
				ASE.LIGHTOBJECT = ( tag_lightobject * )malloc( sizeof tag_lightobject );
			else if( lig > 0 )
				ASE.LIGHTOBJECT = ( tag_lightobject * )realloc( ASE.LIGHTOBJECT, 
				sizeof tag_lightobject * ( lig + 1 ) );

			read_value( ASE.LIGHTOBJECT[lig].NODE_NAME, read_line() );
			read_value( ASE.LIGHTOBJECT[lig].LIGHT_TYPE, read_line() );

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "*NODE_TM", CommandData ) == 0 )
			{
				for( int zz = 0; ; zz++ )
				{
					if( zz == 0 )
						ASE.LIGHTOBJECT[lig].NODE_TM = ( tag_node_tm * )malloc( sizeof tag_node_tm );
					else if( zz > 0 )
						ASE.LIGHTOBJECT[lig].NODE_TM = ( tag_node_tm * )
						realloc( ASE.LIGHTOBJECT[lig].NODE_TM, sizeof tag_node_tm * ( zz + 1 ) );

					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].NODE_NAME, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].INHERIT_POS, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].INHERIT_ROT, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].INHERIT_SCL, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_ROW0, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_ROW1, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_ROW2, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_ROW3, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_POS, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_ROTAXIS, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_ROTANGLE, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_SCALE, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_SCALEAXIS, read_line() );
					read_value( ASE.LIGHTOBJECT[lig].NODE_TM[zz].TM_SCALEAXISANG, read_line() );

					read_line(); // "}";

					sscanf( temp_buffer = read_line(), "%s", CommandData );
					if( strcmp( "*NODE_TM", CommandData ) != 0 )
						break;
				}
			}

			read_value( ASE.LIGHTOBJECT[lig].LIGHT_SHADOWS, temp_buffer );
			read_value( ASE.LIGHTOBJECT[lig].LIGHT_USELIGHT, read_line() );
			read_value( ASE.LIGHTOBJECT[lig].LIGHT_SPOTSHAPE, read_line() );
			read_value( ASE.LIGHTOBJECT[lig].LIGHT_USEGLOBAL, read_line() );
			read_value( ASE.LIGHTOBJECT[lig].LIGHT_ABSMAPBIAS, read_line() );
			read_value( ASE.LIGHTOBJECT[lig].LIGHT_OVERSHOOT, read_line() );
			read_line(); //*LIGHT_SETTINGS;

			if( strcmp( ASE.LIGHTOBJECT[lig].LIGHT_TYPE, "Omni" ) == 0 )
			{
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.TIMEVALUE, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_COLOR, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_INTENS, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_ASPECT, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_TDIST, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_MAPBIAS, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_MAPRANGE, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_MAPSIZE, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_RAYBIAS, read_line() );
			}
			if( strcmp( ASE.LIGHTOBJECT[lig].LIGHT_TYPE, "Target" ) == 0 )
			{
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.TIMEVALUE, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_COLOR, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_INTENS, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_ASPECT, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_HOTSPOT, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_FALLOFF, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_TDIST, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_MAPBIAS, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_MAPRANGE, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_MAPSIZE, read_line() );
				read_value( ASE.LIGHTOBJECT[lig].LIGHT_SETTINGS.LIGHT_RAYBIAS, read_line() );
			}
			read_line(); // "}";
			read_line(); // "}";
			lig++;
			printf( "%d Light Compelete!!",lig );
			getchar();
		}
		else if( strcmp( "*CAMERAOBJECT", CommandData ) == 0 )
		{
			if( cmr == 0 )
				ASE.CAMERAOBJECT = ( tag_cameraobject * )malloc( sizeof	tag_cameraobject );
			else if( cmr > 0 )
				ASE.CAMERAOBJECT = ( tag_cameraobject * )realloc( ASE.CAMERAOBJECT, sizeof tag_cameraobject*(cmr+1) );

			read_value( ASE.CAMERAOBJECT[cmr].NODE_NAME, read_line() );
			read_value( ASE.CAMERAOBJECT[cmr].CAMERA_TYPE,read_line() );

			sscanf( read_line(), "%s", CommandData );
			if( strcmp( "*NODE_TM", CommandData ) == 0 )
			{
				for( int zz = 0; ; zz++ )
				{
					if( zz == 0 )
						ASE.CAMERAOBJECT[cmr].NODE_TM = ( tag_node_tm * )
						malloc( sizeof tag_node_tm );
					else if( zz > 0 )
						ASE.CAMERAOBJECT[cmr].NODE_TM = ( tag_node_tm * )
						realloc( ASE.CAMERAOBJECT[cmr].NODE_TM, sizeof tag_node_tm * ( zz + 1 ) );

					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].NODE_NAME, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].INHERIT_POS, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].INHERIT_ROT, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].INHERIT_SCL, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_ROW0, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_ROW1, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_ROW2, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_ROW3, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_POS, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_ROTAXIS, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_ROTANGLE, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_SCALE, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_SCALEAXIS, read_line() );
					read_value( ASE.CAMERAOBJECT[cmr].NODE_TM[zz].TM_SCALEAXISANG, read_line() );
					read_line(); // "}";
					sscanf( temp_buffer = read_line(), "%s", CommandData );
					if( strcmp( "*NODE_TM", CommandData ) != 0 )
						break;
				}
			}

			if( strcmp( "*CAMERA_SETTINGS", CommandData ) != 0 )
				return;

			read_value( ASE.CAMERAOBJECT[cmr].CAMERA_SETTINGS.TIMEVALUE, read_line() );
			read_value( ASE.CAMERAOBJECT[cmr].CAMERA_SETTINGS.CAMERA_NEAR, read_line() );
			read_value( ASE.CAMERAOBJECT[cmr].CAMERA_SETTINGS.CAMERA_FAR, read_line() );
			read_value( ASE.CAMERAOBJECT[cmr].CAMERA_SETTINGS.CAMERA_FOV, read_line() );
			read_value( ASE.CAMERAOBJECT[cmr].CAMERA_SETTINGS.CAMERA_TDIST, read_line() );
			read_line(); // "}";

			for( int zz = 0; ; zz++ )
			{
				sscanf( read_line(), "%s", CommandData );
				if( strcmp( "}", CommandData ) == 0 )
                     break;
				else if( strcmp( "*TM_ANIMATION", CommandData ) == 0 )
				{
					if( zz == 0 )
						ASE.CAMERAOBJECT[cmr].TM_ANIMATION = ( tag_tm_animation *)
						malloc( sizeof tag_tm_animation );
					else if( zz > 0 )
						ASE.CAMERAOBJECT[cmr].TM_ANIMATION = ( tag_tm_animation *)
						realloc( ASE.CAMERAOBJECT[cmr].TM_ANIMATION, 
						sizeof tag_tm_animation * ( zz + 1 ) );

					read_value( ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].NODE_NAME, read_line() );

					for( int aa=0; ; aa++ )
					{
						sscanf( read_line(), "%s", CommandData );
						if( strcmp( "*CONTROL_POS_BEZIER",CommandData ) == 0 )
						{
							for( int qq=0; ; qq++ )
							{
								if( qq == 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_POS_BEZIER=
									( tag_control_pos_bezier * )malloc( sizeof tag_control_pos_bezier );
								else if( qq > 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_POS_BEZIER=
									( tag_control_pos_bezier * )realloc( ASE.CAMERAOBJECT[cmr].
									TM_ANIMATION[zz].CONTROL_POS_BEZIER, sizeof tag_control_pos_bezier*(qq+1) );

								sscanf( temp_buffer = read_line(), "%s", CommandData );

								if( strcmp( "}", CommandData ) == 0 )
									break;
								else if( strcmp( "*CONTROL_POS_BEZIER", CommandData ) == 0 )
									read_value( ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].
									CONTROL_POS_BEZIER[qq], temp_buffer );
							}
						}
						else if( strcmp( "*CONTROL_ROT_TCB",CommandData ) == 0 )
						{
							for( int qq=0; ; qq++ )
							{
								if( qq == 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_ROT_TCB =
									( tag_control_rot_tcb * )malloc( sizeof tag_control_rot_tcb );
								else if( qq > 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_ROT_TCB=
									( tag_control_rot_tcb * )realloc( ASE.CAMERAOBJECT[cmr].
									TM_ANIMATION[zz].CONTROL_ROT_TCB, sizeof tag_control_rot_tcb*(qq+1) );

								sscanf( temp_buffer = read_line(), "%s", CommandData );

								if( strcmp( "}", CommandData ) == 0 )
									break;
								else if( strcmp( "*CONTROL_ROT_TCB", CommandData ) == 0 )
									read_value( ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].
									CONTROL_ROT_TCB[qq], temp_buffer );
							}
						}
						else if( strcmp( "*CONTROL_SCALE_BEZIER",CommandData ) == 0 )
						{
							for( int qq=0; ; qq++ )
							{
								if( qq == 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_SCALE_BEZIER=
									( tag_control_scale_bezier * )malloc( sizeof tag_control_scale_bezier );
								else if( qq > 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_SCALE_BEZIER=
									( tag_control_scale_bezier * )realloc( ASE.CAMERAOBJECT[cmr].
									TM_ANIMATION[zz].CONTROL_SCALE_BEZIER, sizeof tag_control_scale_bezier*(qq+1) );
	
								sscanf( temp_buffer = read_line(), "%s", CommandData );

								if( strcmp( "}", CommandData ) == 0 )
									break;
								else if( strcmp( "*CONTROL_SCALE_BEZIER", CommandData ) == 0 )
									read_value( ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].
									CONTROL_SCALE_BEZIER[qq], temp_buffer );
							}
						}
						else if( strcmp( "*CONTROL_POS_TRACK",CommandData ) == 0 )
						{
							for( int qq=0; ; qq++ )
							{
								if( qq == 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_POS_TRACK=
									( tag_control_pos_track * )malloc( sizeof tag_control_pos_track );
								else if( qq > 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_POS_TRACK=
									( tag_control_pos_track * )realloc( ASE.CAMERAOBJECT[cmr].
									TM_ANIMATION[zz].CONTROL_POS_TRACK, sizeof tag_control_pos_track*(qq+1) );

								sscanf( temp_buffer = read_line(), "%s", CommandData );

								if( strcmp( "}", CommandData ) == 0 )
									break;
								else if( strcmp( "*CONTROL_POS_SAMPLE", CommandData ) == 0 )
									read_value( ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].
									CONTROL_POS_TRACK[qq], temp_buffer );
							}
						}
						else if( strcmp( "*CONTROL_ROT_TRACK", CommandData ) == 0 )
						{
							for( int qq=0; ; qq++ )
							{
								if( qq == 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_ROT_TRACK=
									( tag_control_rot_track * )malloc( sizeof tag_control_rot_track );
								else if( qq > 0 )
									ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].CONTROL_ROT_TRACK=
									( tag_control_rot_track * )realloc( ASE.CAMERAOBJECT[cmr].
									TM_ANIMATION[zz].CONTROL_ROT_TRACK, sizeof tag_control_rot_track*(qq+1) );

								sscanf( temp_buffer = read_line(), "%s", CommandData );

								if( strcmp( "}", CommandData ) == 0 )
									break;
								else if( strcmp( "*CONTROL_ROT_SAMPLE", CommandData ) == 0 )
									read_value( ASE.CAMERAOBJECT[cmr].TM_ANIMATION[zz].
									CONTROL_ROT_TRACK[qq], temp_buffer );
							}
						}
						else
						    break;
					}
				}
			}
			cmr++;
			printf( "%d Camera Compelete!!",cmr );
			getchar();
		}
    }
	//Ⱑ  Ʈ   ̻ о鿴ٰ   ִ.
	
	free( LineData );
	free( CommandData );
	fclose( ase_file );

	int i;

    // ü  ˾Ƴ.
	total_object = _msize(ASE.GEOMOBJECT)/(sizeof tag_geomobject);
    //Ʈ ʱȭ
	for( i = 0; i<total_object; i++ )
		ase[i].VERTEX = ( D3DVERTEX * )malloc( sizeof( D3DVERTEX ) 
			            * ASE.GEOMOBJECT[i].MESH.MESH_NUMFACES * 3);
    
    //͸  ޸  ʱȭ
	for( i = 0; i<ASE.MATERIAL_LIST.MATERIAL_COUNT; i++ )
	{
	    ZeroMemory( &ase[i].mtrl, sizeof(D3DMATERIAL) );
		ase[i].mtrl.dwSize       = sizeof(D3DMATERIAL);
		ase[i].mtrl.dcvDiffuse.r = ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_DIFFUSE[0];
		ase[i].mtrl.dcvDiffuse.g = ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_DIFFUSE[1];
		ase[i].mtrl.dcvDiffuse.b = ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_DIFFUSE[2];
		ase[i].mtrl.dcvEmissive.r =0.3f;
		ase[i].mtrl.dcvEmissive.g =0.3f;
		ase[i].mtrl.dcvEmissive.b =0.3f;
		ase[i].mtrl.dcvSpecular.r =ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_SPECULAR[0];
		ase[i].mtrl.dcvSpecular.g =ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_SPECULAR[1];
		ase[i].mtrl.dcvSpecular.b =ASE.MATERIAL_LIST.MATERIAL[i].MATERIAL_SPECULAR[2];
		ase[i].mtrl.dvPower       =10.0f;
		D3DMaterial->SetMaterial( &ase[i].mtrl );
	}
}