struct tag_Translate
{
	float x,y,z;
};

struct tag_Rotate
{
	float x,y,z,unit;
};

struct tag_Scale
{
	float x,y,z;
};

struct tag_KeyFrame
{
	char  TRSFlag;
	int   total_frame;

	int   total_translate;
	int   total_rotate;
	int   total_scale;

	tag_Translate *Translate;
	tag_Rotate    *Rotate;
	tag_Scale     *Scale;
};

struct tag_ase
{
	//͸ ó.
    D3DMATERIAL    mtrl;

	//Ʈ ó.
	//1.Ʈ
    unsigned short total_vertex;
    unsigned short total_faces;
	float          ObjCenter[3];
	float          TObjCenter[3];
    D3DVERTEX      *VERTEX;

	//2.Ű
	tag_KeyFrame   Key;

	//3.ó
	int            total_morph;
	int            *frame_m;
	D3DVERTEX      **TMORPHING;
	WORD           **TMIndex;
	D3DVERTEX      **MORPHING;
    WORD           **MIndex;

	//4.Ű ִ ó θ,ڽ 谡  ʿ ü.
    unsigned short TotalChild;
    unsigned short *ChildList;
} *ase;

//Ʒ ASE б ó κ......

struct tag_scene
{
	char           SCENE_FILENAME[255];
	unsigned short SCENE_FIRSTFRAME;
	unsigned short SCENE_LASTFRAME;
	unsigned short SCENE_FRAMESPEED;
	unsigned short SCENE_TICKSPERFRAME;
	float          SCENE_BACKGROUND_STATIC[3];
	float          SCENE_AMBIENT_STATIC[3];
};

struct tag_map_diffuse 
{
	char           MAP_NAME[255];
	char           MAP_CLASS[255];
	unsigned short MAP_SUBNO;
	float          MAP_AMOUNT;
	char           BITMAP[255];
	char           MAP_TYPE[255];
	float          UVW_U_OFFSET;
	float          UVW_V_OFFSET;
	float          UVW_U_TILING;
	float          UVW_V_TILING;
	float          UVW_ANGLE;
	float          UVW_BLUR;
	float          UVW_BLUR_OFFSET;
	float          UVW_NOUSE_AMT;
	float          UVW_NOISE_SIZE;
	unsigned short UVW_NOISE_LEVEL;
	float          UVW_NOISE_PHASE;
	char           BITMAP_FILTER[255];
};

struct tag_material
{
	unsigned short MATERIAL;
	char           MATERIAL_NAME[255];
	char           MATERIAL_CLASS[255];
	float	       MATERIAL_AMBIENT[3];
	float          MATERIAL_DIFFUSE[3];
	float          MATERIAL_SPECULAR[3];
	float          MATERIAL_SHINE;
	float          MATERIAL_SHINESTRENGTH;
	float          MATERIAL_TRANSPARENCY;
	float          MATERIAL_WIRESIZE;
	char           MATERIAL_SHADING[255];
	float          MATERIAL_XP_FALLOFF;
	float          MATERIAL_SELFILLUM;
	char           MATERIAL_FALLOFF[255];
	float          MATERIAL_SOFTEN; //ư  ֱ⵵ ϰ ⵵ ϴ.
	char           MATERIAL_XP_TYPE[255];
	tag_map_diffuse MAP_DIFFUSE;
};

struct tag_material_list
{
	unsigned short MATERIAL_COUNT;
	unsigned short CURRENT_MATERIAL;
	tag_material   *MATERIAL;
};

struct tag_node_tm
{
	char           NODE_NAME[255];
	unsigned short INHERIT_POS[3];
	unsigned short INHERIT_ROT[3];
	unsigned short INHERIT_SCL[3];
	float          TM_ROW0[3];
	float          TM_ROW1[3];
	float          TM_ROW2[3];
	float          TM_ROW3[3];
	float          TM_POS[3];
	float          TM_ROTAXIS[3];
	float          TM_ROTANGLE;
	float          TM_SCALE[3];
	float          TM_SCALEAXIS[3];
	float          TM_SCALEAXISANG;
};

struct tag_mesh_vertex_list
{
	float x,y,z;
};

struct tag_mesh_face_list
{
	unsigned short a,b,c,ab,bc,ca,MESH_SMOOTHING,MESH_MTLID;
};

struct tag_mesh_facenormal
{
	unsigned short  FACE;
	float           x,y,z;
};

struct tag_mesh_vertexnormal
{
	unsigned short VERTEX;
	float          x,y,z;
};

struct tag_mesh_normals
{
	tag_mesh_facenormal   *MESH_FACENORMAL;
	tag_mesh_vertexnormal *MESH_VERTEXNORMAL;
};

struct tag_control_pos_bezier
{
	int            frame;
	float          x,y,z;
	float          x1,y1,z1;
	float          x2,y2,z2;
	unsigned short zz;
};

struct tag_control_rot_tcb
{
	int            frame;
	float          x,y,z;
	float          x1,y1,z1;
	float          x2,y2,z2;
};

struct tag_control_scale_bezier
{
	int            frame;
	float          x,y,z;
	float          x1,y1,z1,xx;
	float          x2,y2,z2;
	float          x3,y3,z3;
	unsigned short zz;
};

struct tag_control_pos_track
{
	int      frame;
	float    x,y,z;
};

struct tag_control_rot_track
{
	int      frame;
	float    x,y,z;
};

struct tag_tm_animation
{
	char NODE_NAME[255];
	tag_control_pos_bezier   *CONTROL_POS_BEZIER;
	tag_control_rot_tcb      *CONTROL_ROT_TCB;
	tag_control_scale_bezier *CONTROL_SCALE_BEZIER;
	tag_control_pos_track    *CONTROL_POS_TRACK;
	tag_control_rot_track    *CONTROL_ROT_TRACK;
};

struct tag_mesh_animation
{
	int            TIMEVALUE;
	unsigned short NUMVERTEX;
	unsigned short NUMFACES;
	tag_mesh_vertex_list *MESH_VERTEX_LIST;
	tag_mesh_face_list   *MESH_FACE_LIST;
	unsigned short MESH_NUMTVERTEX;
	unsigned short MESH_NUMCVERTEX;
	tag_mesh_normals     MESH_NORMALS;
};

struct tag_mesh_tvertlist
{
	unsigned short vertex;
	float          u,v,w;
};

struct tag_mesh_tfacelist
{
	unsigned short face;
	unsigned short v1,v2,v3;
};

struct tag_mesh
{
	unsigned short       TIMEVALUE;
	unsigned short       MESH_NUMVERTEX;
	unsigned short       MESH_NUMFACES;
	tag_mesh_vertex_list *MESH_VERTEX_LIST;
	tag_mesh_face_list   *MESH_FACE_LIST;
	unsigned short       MESH_NUMTVERTEX;
	unsigned short       MESH_NUMTVFACES;
	tag_mesh_tvertlist   *MESH_TVERTLIST;
	tag_mesh_tfacelist   *MESH_TFACELIST;
	unsigned short       MESH_NUMCVERTEX;
	tag_mesh_normals     MESH_NORMALS;
	unsigned short       PROP_MOTIONBLUR;
	unsigned short       PROP_CASTSHADOW;
	unsigned short       PROP_RECVSHADOW;
	tag_tm_animation     TM_ANIMATION;
	unsigned short       MATERIAL_REF;
	float                WIREFRAME_COLOR[3];
	tag_mesh_animation   *MESH_ANIMATION;
};

struct tag_geomobject
{
	char               NODE_NAME[255];
	char               NODE_PARENT[255];
	tag_node_tm        NODE_TM;
	tag_mesh           MESH;
};

struct tag_light_settings
{
	int            TIMEVALUE;
	float          LIGHT_COLOR[3];
	float          LIGHT_INTENS;
	float          LIGHT_ASPECT;
	float          LIGHT_HOTSPOT;
	float          LIGHT_FALLOFF;
	float          LIGHT_TDIST;
	float          LIGHT_MAPBIAS;
	float          LIGHT_MAPRANGE;
	unsigned short LIGHT_MAPSIZE;
	float          LIGHT_RAYBIAS;
};

struct tag_lightobject
{
	char           NODE_NAME[255];
	char           LIGHT_TYPE[255];
	tag_node_tm    *NODE_TM;
	char           LIGHT_SHADOWS[255];
	unsigned short LIGHT_USELIGHT;
	char           LIGHT_SPOTSHAPE[255];
	unsigned short LIGHT_USEGLOBAL;
	unsigned short LIGHT_ABSMAPBIAS;
	unsigned short LIGHT_OVERSHOOT;
	tag_light_settings LIGHT_SETTINGS;
	tag_tm_animation   *TM_ANIMATION;
};

struct tag_camera_settings
{
	int    TIMEVALUE;
	float  CAMERA_NEAR;
	float  CAMERA_FAR;
	float  CAMERA_FOV;
	float  CAMERA_TDIST;
};

struct tag_cameraobject
{
	char                NODE_NAME[255];
	char                CAMERA_TYPE[255];
	tag_node_tm         *NODE_TM;
	tag_camera_settings CAMERA_SETTINGS;
	tag_tm_animation    *TM_ANIMATION;
};

struct tag_ASE
{
	unsigned short MAX_ASCIIEXPORT;
	char              COMMENT[255];
	tag_scene         SCENE;
	tag_material_list MATERIAL_LIST;
	tag_geomobject    *GEOMOBJECT;
	tag_lightobject   *LIGHTOBJECT;
	tag_cameraobject  *CAMERAOBJECT;
};

tag_ASE ASE;