D3DVERTEX MoveXYZ( D3DVERTEX Vertex, FLOAT move_x, FLOAT move_y, FLOAT move_z )
{
	Vertex.x+=move_x;
	Vertex.y+=move_y;
	Vertex.z+=move_z;

	return Vertex;
}

D3DVERTEX RotateXYZ( D3DVERTEX Vertex, FLOAT *Origin, FLOAT angle_x, FLOAT angle_y, FLOAT angle_z )
{
	float x,y,z;
	float fx,fy,fz;

	fx = -angle_x * Radian;
	fy = -angle_y * Radian;
	fz = -angle_z * Radian;

	if( angle_x != 0 )
	{
		y = float((Vertex.y-Origin[1])*cos( fx ) - (Vertex.z-Origin[2])*sin( fx ));
	    z = float((Vertex.y-Origin[1])*sin( fx ) + (Vertex.z-Origin[2])*cos( fx ));
		Vertex.y = y + Origin[1];
		Vertex.z = z + Origin[2];
	}

	if( angle_y != 0 )
	{
		x = float((Vertex.x-Origin[0])*cos( fy ) + (Vertex.z-Origin[2])*sin( fy ));
	    z = float(-(Vertex.x-Origin[0])*sin( fy ) + (Vertex.z-Origin[2])*cos( fy ));
		Vertex.x = x + Origin[0];
		Vertex.z = z + Origin[2];
	}

	if( angle_z != 0 )
	{
		x = float((Vertex.x-Origin[0])*cos( fz ) - (Vertex.y-Origin[1])*sin( fz ));
		y = float((Vertex.x-Origin[0])*sin( fz ) + (Vertex.y-Origin[1])*cos( fz ));
		Vertex.x = x + Origin[0];
		Vertex.y = y + Origin[1];
	}

	return Vertex;
}

D3DVERTEX ScaleXYZ( D3DVERTEX Vertex, FLOAT *Origin, FLOAT scale_x, FLOAT scale_y, FLOAT scale_z )
{
	if( Vertex.x == 0 )
	    Vertex.x = 0.000001f;
	if( Vertex.y == 0 )
	    Vertex.y = 0.000001f;
	if( Vertex.z == 0 )
        Vertex.z = 0.000001f;
	if( scale_x == 0 )
        scale_x = 0.000001f;
	if( scale_y == 0 )
        scale_x = 0.000001f;
	if( scale_z == 0 )
        scale_x = 0.000001f;

	Vertex.x =  Origin[0] + (Vertex.x - Origin[0]) * scale_x;
	Vertex.y =  Origin[1] + (Vertex.y - Origin[1]) * scale_y;
	Vertex.z =  Origin[2] + (Vertex.z - Origin[2]) * scale_z;

	return Vertex;
}

void Move( float *Vertex, FLOAT move_x, FLOAT move_y, FLOAT move_z )
{
	Vertex[0]+=move_x;
	Vertex[1]+=move_y;
	Vertex[2]+=move_z;
}

void Rotate( float *Vertex, FLOAT *Origin, FLOAT angle_x, FLOAT angle_y, FLOAT angle_z )
{
	float x,y,z;
	float fx,fy,fz;

	fx = -angle_x * Radian;
	fy = -angle_y * Radian;
	fz = -angle_z * Radian;

	if( angle_x != 0 )
	{
		y = float((Vertex[1]-Origin[1])*cos( fx ) - (Vertex[2]-Origin[2])*sin( fx ));
	    z = float((Vertex[1]-Origin[1])*sin( fx ) + (Vertex[2]-Origin[2])*cos( fx ));
		Vertex[1] = y + Origin[1];
		Vertex[2] = z + Origin[2];
	}

	if( angle_y != 0 )
	{
		x = float((Vertex[0]-Origin[0])*cos( fy ) + (Vertex[2]-Origin[2])*sin( fy ));
	    z = float(-(Vertex[0]-Origin[0])*sin( fy ) + (Vertex[2]-Origin[2])*cos( fy ));
		Vertex[0] = x + Origin[0];
		Vertex[2] = z + Origin[2];
	}

	if( angle_z != 0 )
	{
		x = float((Vertex[0]-Origin[0])*cos( fz ) - (Vertex[1]-Origin[1])*sin( fz ));
		y = float((Vertex[0]-Origin[0])*sin( fz ) + (Vertex[1]-Origin[1])*cos( fz ));
		Vertex[0] = x + Origin[0];
		Vertex[1] = y + Origin[1];
	}
}

void Rotate( D3DVECTOR &Vertex, D3DVECTOR &Origin, FLOAT angle_x, FLOAT angle_y, FLOAT angle_z )
{
	float x,y,z;
	float fx,fy,fz;

	fx = -angle_x * Radian;
	fy = -angle_y * Radian;
	fz = -angle_z * Radian;

	if( angle_x != 0 )
	{
		y = float((Vertex.y-Origin.y)*cos( fx ) - (Vertex.z-Origin.z)*sin( fx ));
	    z = float((Vertex.y-Origin.y)*sin( fx ) + (Vertex.z-Origin.z)*cos( fx ));
		Vertex.y = y + Origin.y;
		Vertex.z = z + Origin.z;
	}

	if( angle_y != 0 )
	{
		x = float((Vertex.x-Origin.x)*cos( fy ) + (Vertex.z-Origin.z)*sin( fy ));
	    z = float(-(Vertex.x-Origin.x)*sin( fy ) + (Vertex.z-Origin.z)*cos( fy ));
		Vertex.x = x + Origin.x;
		Vertex.z = z + Origin.z;
	}

	if( angle_z != 0 )
	{
		x = float((Vertex.x-Origin.x)*cos( fz ) - (Vertex.y-Origin.y)*sin( fz ));
		y = float((Vertex.x-Origin.x)*sin( fz ) + (Vertex.y-Origin.y)*cos( fz ));
		Vertex.x = x + Origin.x;
		Vertex.y = y + Origin.y;
	}
}

void Scale( float *Vertex, FLOAT *Origin, FLOAT scale_x, FLOAT scale_y, FLOAT scale_z )
{
	if( Vertex[0] == 0 )
	    Vertex[0] = 0.000001f;
	if( Vertex[1] == 0 )
	    Vertex[1] = 0.000001f;
	if( Vertex[2] == 0 )
        Vertex[2] = 0.000001f;
	if( scale_x == 0 )
        scale_x = 0.000001f;
	if( scale_y == 0 )
        scale_x = 0.000001f;
	if( scale_z == 0 )
        scale_x = 0.000001f;

	Vertex[0] =  Origin[0] + (Vertex[0] - Origin[0]) * scale_x;
	Vertex[1] =  Origin[1] + (Vertex[1] - Origin[1]) * scale_y;
	Vertex[2] =  Origin[2] + (Vertex[2] - Origin[2]) * scale_z;
}
