#define INITGUID
#define STRICT
#define D3D_OVERLOADS
#define SPRITE         1
#define PCX            0

#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <d3d.h>
#include <math.h>
#include <fcntl.h>
#include <io.h>

bool                  Mode555 = FALSE;
bool                  Mode565 = FALSE;
bool                  Texture555 = FALSE;
bool                  Texture565 = FALSE;
int                   screen_x=640,screen_y=480,bpp=16;
int                   bActive = FALSE;
float                 Radian = float(3.141592/180);
int                   now_time,old_time,frame,zframe;

LPDIRECTDRAW          DDraw;
LPDIRECTDRAW4         DDraw4;
LPDIRECTDRAWSURFACE4  DDSPrimary  = NULL;
LPDIRECTDRAWSURFACE4  DDSBack     = NULL;
LPDIRECTDRAWSURFACE4  DDS3DSurface= NULL;
LPDIRECTDRAWSURFACE4  DDSZBuffer  = NULL;
LPDIRECTDRAWSURFACE4  MAIN        = NULL;
LPDIRECT3D3           D3D         = NULL;
LPDIRECT3DDEVICE3     D3DDevice   = NULL;
LPDIRECT3DVIEWPORT3   D3DViewport = NULL;
LPDIRECT3DMATERIAL3   D3DMaterial = NULL;
LPDIRECT3DLIGHT       D3DLight    = NULL;
LPDDCOLORKEY          ddck;

D3DMATERIALHANDLE     hmtrl;
D3DVERTEX             TempVertex[2000];
WORD                  **Index;
int                   total_object;
HDC                   hdc;

char                  mframe[10];
int                   Ccounter=0;

D3DVECTOR             Viewer;

LRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM );
BOOL Render();
void Animation();
void ShowFPS( LPDIRECTDRAWSURFACE4 &Surface );
void InitKeyFrame();

#include "ase.h"
#include "Common.cpp"
#include "math.cpp"
#include "Texture.cpp"
#include "ReadASE.cpp"
#include "Morph.cpp"
#include "KeyFrame.cpp"
#include "ViewPoint.cpp"
#include "Read_PCX.cpp"

D3DVERTEX    Cube[36];

BOOL             Render()
{
    RECT        rect;

	rect.left=0;
	rect.right=screen_x;
	rect.top=0;
	rect.bottom=screen_y;

	D3DMATRIX matView;

	SetViewMatrix( matView, ViewPoint, LookAt, UpVector );
	D3DDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );

	D3DViewport->Clear2( 1UL, (D3DRECT *)&rect, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
		                 0x00000000, 1.0f, 0L );
	D3DDevice->BeginScene();

	DDS3DSurface->Blt( NULL, MAIN, NULL, DDBLT_WAIT , NULL );

    D3DDevice->SetTexture( 0, D3DTexture[0] );

	ProcessKeyAni();

	D3DDevice->EndScene();

    DDSBack->BltFast( 0, 0, DDS3DSurface, NULL, DDBLTFAST_WAIT );
	ShowFPS( DDSBack );
	DDSPrimary->Flip( NULL, DDFLIP_WAIT  );

    Ccounter++;
    if( Ccounter > ASE.SCENE.SCENE_LASTFRAME )
	{
	   Ccounter = 0;
	}

	return TRUE;
}

void ShowFPS( LPDIRECTDRAWSURFACE4 &Surface )
{
	now_time = timeGetTime();
	frame++;

	if( now_time > old_time + 1000)
	{
		old_time = now_time;
 		sprintf( mframe, "%d", frame );
 		frame = 0;
	}

	Surface->GetDC( &hdc );
	TextOut( hdc, 10, 10, mframe, 10 );
	Surface->ReleaseDC( hdc );
}

void InitObject()
{
	int            i,ii;
	unsigned short vnum[3];
	unsigned short tnum[3];
	float          u=0.0f,v=0.0f;

	for( i = 0; i < total_object; i++ )
	for( ii = 0;ii< ASE.GEOMOBJECT[i].MESH.MESH_NUMFACES; ii++ )
	{
		vnum[0] = ASE.GEOMOBJECT[i].MESH.MESH_FACE_LIST[ii].a;
		vnum[1] = ASE.GEOMOBJECT[i].MESH.MESH_FACE_LIST[ii].b;
		vnum[2] = ASE.GEOMOBJECT[i].MESH.MESH_FACE_LIST[ii].c;

		if( ASE.GEOMOBJECT[i].MESH.MESH_NUMTVERTEX > 0 )
		{
			tnum[0] = ASE.GEOMOBJECT[i].MESH.MESH_TFACELIST[ii].v1;
			tnum[1] = ASE.GEOMOBJECT[i].MESH.MESH_TFACELIST[ii].v2;
			tnum[2] = ASE.GEOMOBJECT[i].MESH.MESH_TFACELIST[ii].v3;
		}

		if( ASE.GEOMOBJECT[i].MESH.MESH_NUMTVERTEX > 0 )
		{
			u = ASE.GEOMOBJECT[i].MESH.MESH_TVERTLIST[tnum[0]].u;
			v = ASE.GEOMOBJECT[i].MESH.MESH_TVERTLIST[tnum[0]].v;
		}

		ase[i].VERTEX[ii*3+0] = D3DVERTEX( 
			D3DVECTOR(
			ASE.GEOMOBJECT[i].MESH.MESH_VERTEX_LIST[vnum[0]].x,
			ASE.GEOMOBJECT[i].MESH.MESH_VERTEX_LIST[vnum[0]].y,
			ASE.GEOMOBJECT[i].MESH.MESH_VERTEX_LIST[vnum[0]].z),
			D3DVECTOR( 
			ASE.GEOMOBJECT[i].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3].x,
			ASE.GEOMOBJECT[i].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3].y,
			ASE.GEOMOBJECT[i].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3].z),
			u, v );

		if( ASE.GEOMOBJECT[i].MESH.MESH_NUMTVERTEX > 0 )
		{
			u = ASE.GEOMOBJECT[i].MESH.MESH_TVERTLIST[tnum[1]].u;
			v = ASE.GEOMOBJECT[i].MESH.MESH_TVERTLIST[tnum[1]].v;
		}

		ase[i].VERTEX[ii*3+1] = D3DVERTEX( 
			D3DVECTOR(
			ASE.GEOMOBJECT[i].MESH.MESH_VERTEX_LIST[vnum[1]].x,
			ASE.GEOMOBJECT[i].MESH.MESH_VERTEX_LIST[vnum[1]].y,
			ASE.GEOMOBJECT[i].MESH.MESH_VERTEX_LIST[vnum[1]].z),
			D3DVECTOR( 
			ASE.GEOMOBJECT[i].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3+1].x,
			ASE.GEOMOBJECT[i].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3+1].y,
			ASE.GEOMOBJECT[i].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3+1].z),
			u, v );

		if( ASE.GEOMOBJECT[i].MESH.MESH_NUMTVERTEX > 0 )
		{
			u = ASE.GEOMOBJECT[i].MESH.MESH_TVERTLIST[tnum[2]].u;
			v = ASE.GEOMOBJECT[i].MESH.MESH_TVERTLIST[tnum[2]].v;
		}

		ase[i].VERTEX[ii*3+2] = D3DVERTEX( 
			D3DVECTOR(
			ASE.GEOMOBJECT[i].MESH.MESH_VERTEX_LIST[vnum[2]].x,
			ASE.GEOMOBJECT[i].MESH.MESH_VERTEX_LIST[vnum[2]].y,
			ASE.GEOMOBJECT[i].MESH.MESH_VERTEX_LIST[vnum[2]].z),
			D3DVECTOR( 
			ASE.GEOMOBJECT[i].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3+2].x,
			ASE.GEOMOBJECT[i].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3+2].y,
			ASE.GEOMOBJECT[i].MESH.MESH_NORMALS.MESH_VERTEXNORMAL[ii*3+2].z),
			u, v );
	}


//  б......
	InitMorph();

//Ű ִϸ̼  б......
	FindParent();
	InitKeyFrame();
}

static HRESULT WINAPI EnumZBufferCallback( DDPIXELFORMAT* pddpf,
                                           VOID* pddpfDesired )
{
    if( pddpf->dwFlags == DDPF_ZBUFFER )
    {
        memcpy( pddpfDesired, pddpf, sizeof(DDPIXELFORMAT) );

		return D3DENUMRET_CANCEL;
    }

    return D3DENUMRET_OK;
}

LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
    switch( uMsg )
    {
        case WM_ACTIVATEAPP:
			bActive = wParam;
			return TRUE;

		case WM_SETCURSOR:
			SetCursor(NULL);
			return TRUE;

		case WM_KEYDOWN:
            switch (wParam)
            {
                case VK_ESCAPE:
                case VK_F12:
                    PostMessage(hWnd, WM_CLOSE, 0, 0);
					break;
            }
			break;

		case WM_CLOSE:
            DestroyWindow( hWnd );
			break;
        
        case WM_DESTROY:
            PostQuitMessage(0);
			break;
    }
    return DefWindowProc( hWnd, uMsg, wParam, lParam );
}

INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR strCmdLine, int nCmdShow)
{
	MSG             msg;
	HRESULT         hr;

    WNDCLASS wndClass = 
	{
		CS_HREDRAW | CS_VREDRAW, 
		WndProc, 
		0, 
		0, 
		hInst,
		NULL,
        LoadCursor(NULL, IDC_ARROW), 
        (HBRUSH)GetStockObject(WHITE_BRUSH), 
		NULL,
        TEXT("Render Window")
	};

    RegisterClass( &wndClass );

    HWND hWnd = CreateWindowEx(
				    WS_EX_TOPMOST,
		            TEXT("Render Window"),
		            TEXT("Render Objects"),
					WS_POPUP,
				    0,
                    0,
					0,
					0,
				    0L,
				    0L,
				    hInst,
				    0L );

    ShowWindow( hWnd, SW_SHOWNORMAL );
    UpdateWindow( hWnd );

	DirectDrawCreate( NULL, &DDraw, NULL );
	DDraw->QueryInterface( IID_IDirectDraw4, (VOID**)&DDraw4 );
    
	DDraw4->SetCooperativeLevel(hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );
    DDraw4->SetDisplayMode( screen_x, screen_y, bpp, 0, 0 );

	DDSURFACEDESC2   ddsd;
    DDSCAPS2         ddscaps;

	ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
	ddsd.dwSize         = sizeof(DDSURFACEDESC2);
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
                          DDSCAPS_FLIP |
                          DDSCAPS_COMPLEX| DDSCAPS_3DDEVICE;
    ddsd.dwBackBufferCount = 1;
	DDraw4->CreateSurface( &ddsd, &DDSPrimary, NULL );
    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    DDSPrimary->GetAttachedSurface(&ddscaps, &DDSBack);

	ddsd.dwFlags        = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_3DDEVICE;
	ddsd.dwWidth  = screen_x;
	ddsd.dwHeight = screen_y;
	DDraw4->CreateSurface( &ddsd, &DDS3DSurface, NULL );

	LPDIRECTDRAWCLIPPER pcClipper;
	DDraw4->CreateClipper( 0, &pcClipper, NULL );
	pcClipper->SetHWnd( 0, hWnd );
	DDSPrimary->SetClipper( pcClipper );
	pcClipper->Release();

    DDraw4->QueryInterface( IID_IDirect3D3, (VOID**)&D3D );

	DDPIXELFORMAT ddpfZBuffer;
	hr = D3D->EnumZBufferFormats( IID_IDirect3DHALDevice,
		                        EnumZBufferCallback, (VOID*)&ddpfZBuffer );
	if( FAILED( hr ) )
	{
		D3D->EnumZBufferFormats( IID_IDirect3DRGBDevice,
		                        EnumZBufferCallback, (VOID*)&ddpfZBuffer );
	}

    if( sizeof(DDPIXELFORMAT) != ddpfZBuffer.dwSize )
        return E_FAIL;

    ddsd.dwFlags        = DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT|DDSD_PIXELFORMAT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER;
	ddsd.dwWidth        = screen_x;
	ddsd.dwHeight       = screen_y;
    memcpy( &ddsd.ddpfPixelFormat, &ddpfZBuffer, sizeof(DDPIXELFORMAT) );
	
	if( SUCCEEDED( hr ) )
		ddsd.ddsCaps.dwCaps |= DDSCAPS_VIDEOMEMORY;
	else
		ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;

    DDraw4->CreateSurface( &ddsd, &DDSZBuffer, NULL );
    DDS3DSurface->AddAttachedSurface( DDSZBuffer );

    hr = D3D->CreateDevice( IID_IDirect3DHALDevice, DDS3DSurface,
                               &D3DDevice, NULL );
	if( FAILED( hr ) )
	{
	    hr = D3D->CreateDevice( IID_IDirect3DRGBDevice, DDS3DSurface,
                                 &D3DDevice, NULL );
	}

	//Ʈ 
    D3DVIEWPORT2 vdData;
    ZeroMemory( &vdData, sizeof(D3DVIEWPORT2) );
    vdData.dwSize       = sizeof(D3DVIEWPORT2);
	vdData.dwWidth      = screen_x;
	vdData.dwHeight     = screen_y;
    vdData.dvClipX      = -1.0f;
    vdData.dvClipWidth  = 2.0f;
    vdData.dvClipY      = 1.0f;
    vdData.dvClipHeight = 2.0f;
    vdData.dvMaxZ       = 1.0f;

    D3D->CreateViewport( &D3DViewport, NULL );
    D3DDevice->AddViewport( D3DViewport );
    D3DViewport->SetViewport2( &vdData );
    D3DDevice->SetCurrentViewport( D3DViewport );

    LPDIRECT3D3 pD3D;
    if( FAILED( D3DDevice->GetDirect3D( &pD3D ) ) )
        return E_FAIL;
	pD3D->Release();

    if( FAILED( pD3D->CreateMaterial( &D3DMaterial, NULL ) ) )
        return E_FAIL;

    D3DMATERIAL       mtrl;
    D3DMATERIALHANDLE hmtrl;
    ZeroMemory( &mtrl, sizeof(D3DMATERIAL) );
    mtrl.dwSize       = sizeof(D3DMATERIAL);
    mtrl.dcvDiffuse.r = 1.0f;
    mtrl.dcvDiffuse.g = 1.0f;
    mtrl.dcvDiffuse.b = 1.0f;
    mtrl.dcvAmbient.r = 1.0f;
    mtrl.dcvAmbient.g = 1.0f;
    mtrl.dcvAmbient.b = 1.0f;
	mtrl.dcvEmissive.r= 0.5f;
	mtrl.dcvEmissive.g= 0.5f;
	mtrl.dcvEmissive.b= 0.5f;
    D3DMaterial->SetMaterial( &mtrl );
    D3DMaterial->GetHandle( D3DDevice, &hmtrl );

    D3DDevice->SetLightState(  D3DLIGHTSTATE_MATERIAL, hmtrl );

    D3D->CreateLight( &D3DLight, NULL );
    D3DLIGHT light;
    ZeroMemory( &light, sizeof(D3DLIGHT) );
    light.dwSize       = sizeof(D3DLIGHT);
    light.dltType      = D3DLIGHT_PARALLELPOINT;
    light.dcvColor.r   = 1.0f;
    light.dcvColor.g   = 1.0f;
    light.dcvColor.b   = 1.0f;
    light.dvPosition.x = 0.0f;
    light.dvPosition.y = 10.0f;
    light.dvPosition.z = 0.0f;
	light.dvDirection.x = 0.0f;
	light.dvDirection.y = 0.0f;
	light.dvDirection.z = 0.0f;
    light.dvAttenuation0 = 1.0f;
    D3DLight->SetLight( &light );
    D3DViewport->AddLight( D3DLight );

    D3DDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, TRUE );
    D3DDevice->SetRenderState( D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE );
    D3DDevice->SetRenderState( D3DRENDERSTATE_TEXTUREADDRESS, D3DTADDRESS_MIRROR );
    D3DDevice->SetRenderState( D3DRENDERSTATE_DITHERENABLE, TRUE );
    D3DDevice->SetRenderState( D3DRENDERSTATE_SPECULARENABLE, TRUE );
    D3DDevice->SetRenderState( D3DRENDERSTATE_SHADEMODE,D3DSHADE_GOURAUD);

//,, Ʈ ........
    D3DMATRIX mat;
	mat._11 = mat._22 = mat._33 = mat._44 = 1.0f;
	mat._12 = mat._13 = mat._14 = mat._41 = 0.0f;
	mat._21 = mat._23 = mat._24 = mat._42 = 0.0f;
	mat._31 = mat._32 = mat._34 = mat._43 = 0.0f;
	
	D3DMATRIX matWorld = mat;
    D3DDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );

	D3DMATRIX matProj = mat;
	matProj._11 =  2.5f;
	matProj._22 =  2.5f;
	matProj._34 =  1.0f;
	matProj._43 =  -1.0f;
	matProj._44 =  0.0f;
    D3DDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj );

	ViewPoint = D3DVECTOR( 300.0f,300.0f,300.0f );
	LookAt = D3DVECTOR( 0.0f,0.0f,0.0f );
	UpVector = D3DVECTOR( 0.0f,0.0f,0.0f );
	SetViewMatrix( mat, ViewPoint, LookAt, UpVector );
	D3DDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &mat );

	if ( CheckMode( DDSBack, 0 ) == 5 ) Mode555=TRUE;
	else if ( CheckMode( DDSBack, 0 ) == 6 ) Mode565=TRUE;

	read_pcx( "12.pcx" );
	InitTexture( "0.spr", 0, SPRITE );
	ReadASE( "zz.ase" );
	InitObject();

    while( WM_QUIT != msg.message )
    {
        if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
        {
            if (!GetMessage(&msg, NULL, 0, 0))
                return msg.wParam;

            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        else if ( bActive )
        {
			Render();
        }
        else
        {
            WaitMessage();
        }
	}
	return msg.wParam;
}