#define blue          0x001F
#define red_green_555 0x7FE0;
#define red_green_565 0xFFC0 

LPDIRECT3DTEXTURE2    D3DTexture[8];
LPDIRECTDRAWSURFACE4  DDSTexture[8];

D3DTEXTUREMAGFILTER g_dwLeftTexMagState;
D3DTEXTUREMINFILTER g_dwLeftTexMinState;
DWORD               g_dwLeftAnisotropyLevel;
D3DANTIALIASMODE    g_dwLeftAntialiasMode;

BOOL                g_bDeviceDoesFlatCubic;
BOOL                g_bDeviceDoesGaussianCubic;
DWORD               g_dwDeviceMaxAnisotropy;
BOOL                g_bDeviceDoesSortDependantAA;
BOOL                g_bDeviceDoesSortIndependantAA;

struct TEXTURESEARCHINFO
{
	DWORD dwDesiredBPP;
	BOOL  bUseAlpha;
	BOOL  bUsePalette;
	BOOL  bUseFourCC;
	BOOL  bFoundGoodFormat;

	DDPIXELFORMAT* pddpf;
};

static HRESULT CALLBACK TextureSearchCallback( DDPIXELFORMAT* pddpf,
											   VOID* param )
{
    if( NULL==pddpf || NULL==param )
        return DDENUMRET_OK;

	TEXTURESEARCHINFO* ptsi = (TEXTURESEARCHINFO*)param;

    if( pddpf->dwFlags & (DDPF_LUMINANCE|DDPF_BUMPLUMINANCE|DDPF_BUMPDUDV) )
        return DDENUMRET_OK;

	if( ptsi->bUsePalette )
	{
		if( !( pddpf->dwFlags & DDPF_PALETTEINDEXED8 ) )
			return DDENUMRET_OK;

        memcpy( ptsi->pddpf, pddpf, sizeof(DDPIXELFORMAT) );
		ptsi->bFoundGoodFormat = TRUE;
        return DDENUMRET_CANCEL;
    }

	if( pddpf->dwRGBBitCount < 16 )
		return DDENUMRET_OK;

    if( ptsi->bUseFourCC )
	{
		if( pddpf->dwFourCC == 0 )
		    return DDENUMRET_OK;

		return DDENUMRET_CANCEL;
	}

	if( pddpf->dwFourCC != 0 )
		return DDENUMRET_OK;

	if( (ptsi->bUseAlpha==TRUE) && !(pddpf->dwFlags&DDPF_ALPHAPIXELS) )
		return DDENUMRET_OK;
	if( (ptsi->bUseAlpha==FALSE) && (pddpf->dwFlags&DDPF_ALPHAPIXELS) )
		return DDENUMRET_OK;

    if( pddpf->dwRGBBitCount == ptsi->dwDesiredBPP )
    {
        memcpy( ptsi->pddpf, pddpf, sizeof(DDPIXELFORMAT) );
		ptsi->bFoundGoodFormat = TRUE;
        return DDENUMRET_CANCEL;
    }

    return DDENUMRET_OK;
}

BOOL Filtering()
{
    /*D3DDEVICEDESC ddHELDesc, ddHALDesc;
    ddHELDesc.dwSize = sizeof(D3DDEVICEDESC);
    ddHALDesc.dwSize = sizeof(D3DDEVICEDESC);
    D3DDevice->GetCaps( &ddHALDesc, &ddHELDesc );*/

    /*g_bDeviceDoesFlatCubic         = FALSE;
    g_bDeviceDoesGaussianCubic     = FALSE;
    g_dwDeviceMaxAnisotropy        = 1;
    g_bDeviceDoesSortDependantAA   = FALSE;
    g_bDeviceDoesSortIndependantAA = FALSE;*/
    
    g_dwLeftTexMagState      = D3DTFG_POINT;
    g_dwLeftTexMinState      = D3DTFN_POINT;
    //g_dwLeftAnisotropyLevel  = 1;
    g_dwLeftAntialiasMode    = D3DANTIALIAS_NONE;

    /*D3DDEVICEDESC* pDesc = (ddHALDesc.dwFlags) ? &ddHALDesc : &ddHELDesc;
    DWORD dwRasterCaps = pDesc->dpcTriCaps.dwRasterCaps;
    DWORD dwFilterCaps = pDesc->dpcTriCaps.dwTextureFilterCaps;
    if( dwRasterCaps & D3DPRASTERCAPS_ANISOTROPY )
        g_dwDeviceMaxAnisotropy = pDesc->dwMaxAnisotropy;
    if( dwRasterCaps & D3DPRASTERCAPS_ANTIALIASSORTDEPENDENT )
        g_bDeviceDoesSortDependantAA = TRUE;
    if( dwRasterCaps & D3DPRASTERCAPS_ANTIALIASSORTINDEPENDENT )
        g_bDeviceDoesSortIndependantAA = TRUE;
    if( dwFilterCaps & D3DPTFILTERCAPS_MAGFAFLATCUBIC )
        g_bDeviceDoesFlatCubic = TRUE;
    if( dwFilterCaps & D3DPTFILTERCAPS_MAGFGAUSSIANCUBIC )
        g_bDeviceDoesGaussianCubic = TRUE;*/

	return TRUE;
}

/*void read_pcx( char *name )
{


		DDSURFACEDESC2   ddsd;
		
		memset(&ddsd,0,sizeof(ddsd));
		ddsd.dwSize=sizeof(ddsd);
		ddsd.dwFlags=DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;
		ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
		ddsd.dwWidth=PCX_X;
		ddsd.dwHeight=PCX_Y;
		DDraw4->CreateSurface( &ddsd,&MAIN,NULL);
		ddsd.dwSize=sizeof(ddsd);
		MAIN->Lock(NULL,&ddsd,0,NULL);
		Desc=(unsigned char *)ddsd.lpSurface;
		Src=(unsigned char *)IMAGE2;
	
		for( counter=0; counter < PCX_Y ; counter++)
		{
			memcpy(Desc,Src,PCX_X*2);
			Desc+=ddsd.lPitch;
			Src+=PCX_X*2;
		}
	 
		MAIN->Unlock(NULL);

		free( LineData );
		free( IMAGE );
		free( IMAGE2 );
    }
}*/





BOOL InitTexture( char *FileName,int TextureNum, char type )
{
	// ...
	FILE           *file;
	short          counter;
	LPBYTE         Desc,Src;
	unsigned char  *IMAGE;
	unsigned short *IMAGE2;
	unsigned short Width,Height;

	// Ʈ б ....
	int            temp_width,temp_height;
	unsigned short temp_data, temp_data1;
    unsigned short blue_value;
    unsigned short red_green_value;

	// PCX б ....
	bool           break_flag=false;
	unsigned char  *LineData;
	int            handle;
	short          RGB=1;
	int            position=0;
	int            LineOffset = 0;
	short          line=0;
    
	LPDIRECTDRAWSURFACE4 pddsRender;
	D3DDevice->GetRenderTarget( &pddsRender );
	//pddsRender->GetDDInterface( (VOID**)&pddsRender );
	pddsRender->Release();

	//ؽķ   Ʈ...
	if( type == SPRITE )
	{
		unsigned char  compress;

		file = fopen( FileName, "rb" );
		fread( &compress,1,1,file );
		fread( &Width,2,1,file );
		fread( &Height,2,1,file );

		IMAGE2 = (unsigned short *)malloc( Width*Height*2 );

		if( compress == 0 )
		{
			for( int counter=0; counter < Width*Height; counter++ )
			{
				fread( &temp_data, 2, 1, file );
				IMAGE2[counter] = ((temp_data&red_green_565) >> 1 ) 
					             + (temp_data & blue);
			}
		}
		else if( compress == 1 )
		{
			for( int yy=0; yy < Height; yy++ )
			for( int xx=0; xx < Width; xx++ )
			{
				fread( &temp_data,2,1,file );
				
				if( temp_data == 0 )
				{
					fread( &temp_data,2,1,file );
					for( int rr=0; rr< temp_data; rr++ )
					{
						IMAGE2[xx+yy*Width]=0;
						xx++;
					}
					xx--;
				}
				else
				{
					for( int rr=0; rr< temp_data; rr++ )
					{
						fread( &temp_data1, 2, 1, file );
						//if( mode_555 == TRUE ) 
						{
							blue_value = temp_data1 & blue;
							red_green_value = ( temp_data1 & red_green_565 ) >> 1;
							temp_data1 = red_green_value + blue_value;
						}
						/*if( mode_565 == TRUE ) 
							temp_data1=temp_data1;*/
						
						IMAGE2[xx+yy*Width]=temp_data1;
						xx++;
					}
					xx--;
				}
			}
		}
	}
	//ؽķ   PCX
	else if( type == PCX )
	{
		file= fopen( FileName, "rb" );
		handle=open( FileName , O_RDONLY | O_TEXT );
		fseek( file, 8, SEEK_SET );
		fread( &Width, 2, 1, file );
		fread( &Height, 2, 1, file );
		fseek( file, 128, SEEK_SET );

		Width++;
		Height++;

		IMAGE = (unsigned char *)malloc( filelength(handle)-128 );
		IMAGE2 = (unsigned short *)malloc( Width*Height*2 );

		fread( IMAGE, filelength(handle)-128, 1, file );
		close( handle );
		fclose( file );

		LineData = ( unsigned char * )malloc( Width * 3 + 3 );

		while( break_flag == false )
		{
			if( IMAGE[position] > 0xC0 )
			{
				position++;

				for( counter=0; counter < IMAGE[position-1]-0xC0; counter++ )
				{
					LineData[LineOffset]=IMAGE[position];
					LineOffset++;
				}
			}

			else
			{
				LineData[LineOffset]=IMAGE[position];
				LineOffset++;
			}

			position++;

			if( ( Width % 2 ) == 0 )
			if( LineOffset == ( Width * 3 ) )
			{
				for( counter=0; counter < Width; counter++ )
					IMAGE2[line*Width+counter] = 
					LineData[ Width * 0 + counter ] / 8 * 1024 +
					LineData[ Width * 1 + counter ] / 8 * 32 +
					LineData[ Width * 2 + counter ] / 8;
			
				LineOffset = 0;
				line++;

				if( line == Height )
					break_flag = true;
			}

			if( ( Width % 2 ) == 1 )
			if( LineOffset == ( Width * 3 + 3 ) )
			{
				for( counter=0; counter < Width; counter++ )
					IMAGE2[line*Width+counter] = 
					LineData[ Width * 0 + counter ] / 8 * 1024 +
					LineData[ Width * 1 + counter ] / 8 * 32 +
					LineData[ Width * 2 + counter ] / 8;
			
				LineOffset = 0;
				line++;

				if( line == Height )
					break_flag = true;
			}
		}
		free( IMAGE );
		free( LineData );
	}

	fclose(file);

    D3DDEVICEDESC ddHwDesc, ddSwDesc;
    DWORD         dwDeviceCaps;
    ddHwDesc.dwSize = sizeof(D3DDEVICEDESC);
    ddSwDesc.dwSize = sizeof(D3DDEVICEDESC);
    if( FAILED( D3DDevice->GetCaps( &ddHwDesc, &ddSwDesc ) ) )
        return FALSE;
    if( ddHwDesc.dwFlags ) dwDeviceCaps = ddHwDesc.dpcTriCaps.dwTextureCaps;
    else                   dwDeviceCaps = ddSwDesc.dpcTriCaps.dwTextureCaps;

    DDSURFACEDESC2 ddsd;
    ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
    ddsd.dwSize                 = sizeof(DDSURFACEDESC2);
    ddsd.ddpfPixelFormat.dwSize = sizeof(DDPIXELFORMAT);
    ddsd.dwFlags         = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH|
                           DDSD_PIXELFORMAT|DDSD_TEXTURESTAGE;
    ddsd.ddsCaps.dwCaps  = DDSCAPS_TEXTURE;
    ddsd.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
    ddsd.dwTextureStage  = TextureNum;

    if( dwDeviceCaps & D3DPTEXTURECAPS_POW2 )
    {
        for( temp_width=1; Width/2 > temp_width; temp_width<<=1 );
        for( temp_height=1;Height/2> temp_height;temp_height<<=1 );
		
		ddsd.dwWidth = temp_width;
		ddsd.dwHeight =temp_height;
    }

    if( dwDeviceCaps & D3DPTEXTURECAPS_SQUAREONLY )
    {
        if( ddsd.dwWidth > ddsd.dwHeight ) ddsd.dwHeight = ddsd.dwWidth;
        else                               ddsd.dwWidth  = ddsd.dwHeight;
    }

// 8Ʈ Į  Ʒ ȷ  TRUE Ѵ.-----------
	BOOL bUsePalette = FALSE;
//    Ʒ  TRUE Ѵ.
	BOOL bUseAlpha   = FALSE;
	
	//if( ptcTexture->dwFlags & (D3DTEXTR_TRANSPARENTWHITE|D3DTEXTR_TRANSPARENTBLACK) )
/*	if( FALSE & (D3DTEXTR_TRANSPARENTWHITE|D3DTEXTR_TRANSPARENTBLACK) )
	{
		if( bUsePalette )
		{
			if( dwDeviceCaps & D3DPTEXTURECAPS_ALPHAPALETTE )
			{
				bUseAlpha   = TRUE;
				bUsePalette = TRUE;
			}
			else
			{
				bUseAlpha   = TRUE;
				bUsePalette = FALSE;
			}
		}
	}*/

	TEXTURESEARCHINFO tsi;
	tsi.pddpf            = &ddsd.ddpfPixelFormat;
	tsi.bUseAlpha        = bUseAlpha;
	tsi.bUsePalette      = bUsePalette;
	tsi.bUseFourCC       = ( ddsd.ddpfPixelFormat.dwFlags & DDPF_FOURCC );
	tsi.dwDesiredBPP     = 16;
	tsi.bFoundGoodFormat = TRUE;
	//if( FALSE & D3DTEXTR_32BITSPERPIXEL )
	//	tsi.dwDesiredBPP = 32;

    D3DDevice->EnumTextureFormats( TextureSearchCallback, &tsi );

	//if( ptcTexture->dwFlags== tsi.bFoundGoodFormat && bUsePalette )
	/*if( FALSE == tsi.bFoundGoodFormat && bUsePalette )
	{
		tsi.bUsePalette  = FALSE;
		tsi.dwDesiredBPP = 16;
	    D3DDevice->EnumTextureFormats( TextureSearchCallback, &tsi );
		if( FALSE == tsi.bFoundGoodFormat )
			return FALSE;
	}*/
	
    DDraw4->CreateSurface( &ddsd, &DDSTexture[TextureNum], NULL );
    DDSTexture[TextureNum]->QueryInterface( IID_IDirect3DTexture2, (VOID**)&D3DTexture[TextureNum] );

    // Setup the new surface desc
    ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
    ddsd.dwSize                 = sizeof(DDSURFACEDESC2);
    ddsd.ddpfPixelFormat.dwSize = sizeof(DDPIXELFORMAT);
    DDSTexture[TextureNum]->GetSurfaceDesc( &ddsd );
    ddsd.dwFlags          = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH|DDSD_PIXELFORMAT|
		                    DDSD_TEXTURESTAGE;
    ddsd.ddsCaps.dwCaps   = DDSCAPS_TEXTURE|DDSCAPS_SYSTEMMEMORY;
    ddsd.ddsCaps.dwCaps2  = 0L;
    ddsd.dwWidth          = Width;
    ddsd.dwHeight         = Height;

    LPDIRECTDRAWSURFACE4 pddsTempSurface;
    DDraw4->CreateSurface( &ddsd, &pddsTempSurface, NULL );
    pddsTempSurface->Lock(NULL,&ddsd,0,NULL);

	Desc=(LPBYTE)ddsd.lpSurface;
	Src=(LPBYTE)IMAGE2;

	for( counter=0; counter < Height ; counter++)
	{
		memcpy(Desc,Src,Width*2);
	    Desc+=ddsd.lPitch;
	    Src+=Width*2; 
	}
   
    pddsTempSurface->Unlock(NULL);

	RECT      rect1, rect2;

	SetRect( &rect1, 0, 0, temp_width, temp_height );
	SetRect( &rect2, 0, 0, Width, Height );

    DDSTexture[TextureNum]->Blt( &rect1, pddsTempSurface, &rect2, DDBLT_WAIT, NULL );

    pddsTempSurface->Release();

	free( IMAGE2 );

	return TRUE;
}
