#include "cinputdevice.h"


void CInputDevice::Init(HINSTANCE hInstance, HWND hWnd)
{
	DirectInputCreate( hInstance, DIRECTINPUT_VERSION, &m_lpdi, NULL);
	

	LPDIRECTINPUTDEVICE lpdid1;
	m_lpdi->CreateDevice ( GUID_SysKeyboard,&lpdid1, NULL);
	lpdid1->QueryInterface ( IID_IDirectInputDevice2, (void**) &m_lpdid2);
	lpdid1->Release();

	m_lpdid2->SetDataFormat ( &c_dfDIKeyboard);
	
	DWORD cl, cl1;
	cl = DISCL_NONEXCLUSIVE;
	cl1 = DISCL_FOREGROUND;

	m_lpdid2->SetCooperativeLevel( hWnd, cl|cl1);

	DIPROPDWORD dipdw =
	{
		{
			sizeof(DIPROPDWORD),
			sizeof(DIPROPHEADER),
			0,
			DIPH_DEVICE,
		},
		BUFFERSIZE,
	};
	
	m_lpdid2->SetProperty ( DIPROP_BUFFERSIZE, &dipdw.diph);
	
	SetAcquireState(TRUE);
	

}

BOOL CInputDevice::SetAcquireState( BOOL acq)
{
	HRESULT hr;

	if( ! acq)
	{
		hr = m_lpdid2->Unacquire();
	}
	else
	{
		hr = m_lpdid2->Acquire();
	}


	return ( SUCCEEDED (hr));
}



void CInputDevice::ExitInit()
{
    if ( m_lpdid2 != NULL ) 
    {
        SetAcquireState( FALSE );
        m_lpdid2->Release();
        m_lpdid2 = NULL;
    }

    if ( m_lpdi != NULL )
    { 
        m_lpdi->Release();
        m_lpdi = NULL;
    }
}

BOOL CInputDevice::PollDevice( void )
{
//    DIJOYSTATE   dijs;
    char         keys[256]; 
    static       DWORD LastClickTime;
     
    HRESULT            hr;
    DIDEVICEOBJECTDATA rgdod[BUFFERSIZE];
    DWORD              dwItems; 

    if ( !m_lpdid2 ) return FALSE;

getBufferedData:
    m_lpdid2->Poll();  // May be unnecessary but never hurts.

    dwItems = BUFFERSIZE;
    hr = m_lpdid2->GetDeviceData( sizeof( DIDEVICEOBJECTDATA ), 
                     rgdod,         // Where to put data?
                     &dwItems,      // How many items?
                     0 );           // Flags.

    // If data stream was interrupted, reacquire the device and try again.
    if ( hr == DIERR_INPUTLOST )
    {
        if ( SetAcquireState( TRUE ) )
            goto getBufferedData;
    }

    // We can't get the device. Quit.
    if ( hr == DIERR_NOTACQUIRED )
    {
        OutputDebugString( "Device not acquired!" );
        return FALSE;
    }


getImmediateData:
    hr = m_lpdid2->GetDeviceState( sizeof( keys ), keys );  

    if ( hr == DIERR_INPUTLOST )
    {
        if ( SetAcquireState( TRUE ) )
            goto getImmediateData;
    }
    if ( hr == DIERR_NOTACQUIRED )
    {
        OutputDebugString( "Device not acquired!" );
        return FALSE;
    }

    // We got immediate input, let's act on it.  
    if ( SUCCEEDED( hr ) )
    {

		int OverScreenResult;

        if ( BUTTONDOWN( keys[DIK_LEFT] ) )
		{
			m_bActive = TRUE;
			m_direction = 0;
			m_x-=4;					// 4 ũ 
			if ( m_x<0) 
			{
				m_x=0;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE", MB_OK);
				return OverScreenResult = 0;
			}
		}
	    

        if ( BUTTONDOWN( keys[DIK_RIGHT] ) )
		{
			m_bActive = TRUE;
			m_direction = 1;
			m_x+=4;
			if ( m_x>768)	// 800 - 32
			{
				m_x=768;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE",MB_OK);
				return OverScreenResult = 1;
			}
		}
         

        if ( BUTTONDOWN( keys[DIK_UP] ) )
		{
			m_bActive = TRUE;
			m_direction = 2;
			m_y-=4;
			if( m_y<0) 
			{
				m_y=0;//MessageBox(NULL,"Over Screen","TRYOVER MESSAGE", MB_OK);
				return OverScreenResult = 2;
			}
		}
        
        if ( BUTTONDOWN( keys[DIK_DOWN] ) )
		{
			m_bActive = TRUE;
			m_direction = 3;
			m_y+=4;
			if (m_y>545)		// 577 - 32
			{
				m_y=545;//MessageBox(NULL,"Over Screen","TRYOVER Message", MB_OK);
				return OverScreenResult = 3;
			}
		}
        
		return OverScreenResult=4;
    }
    else              // FAILED( hr )
        return FALSE;
}  // PollDevice()
